# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ManageFriend.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::ManageFriend;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Affelio::App::Standalone::FriendRoutines;

    use Exporter;
    @Affelio::App::Standalone::Admin::ManageFriend::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::ManageFriend::EXPORT = qw (manage_top modify_member show_member subscribe_group unsubscribe_group remove_member handler);


    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();
	
	my $sub_mode = $wi->PTN_mode($cgi->url_param("mode2"));
	
	try{
	    if($sub_mode eq "modify_member"){
		modify_member($af, $cgi->url_param("uid"), $cgi);

	    }elsif($sub_mode eq "unsubscribe_group"){
		unsubscribe_group($af, $cgi->url_param("gid"), 
				  $cgi->url_param("uid"));

	    }elsif($sub_mode eq "subscribe_group"){
		my @add_group_inputs = $cgi->param("add_group");
		foreach my $i (@add_group_inputs){
		    subscribe_group($af, $i, $cgi->url_param("uid"));
		}

	    }elsif($sub_mode eq "delete"){
		remove_member($af, $cgi->url_param("uid"), $cgi);
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};
	

	if( ($sub_mode eq "subscribe_group") 
	    || ($sub_mode eq "unsubscribe_group")
	    || ($sub_mode eq "show_member") 
	    || ($sub_mode eq "modify_member") ){
	    $out_ref->{tmpl_file} = "$af->{site__tmpl_dir}/owner_side/admin_managefriends_showmember.tmpl";
	    show_member($af, $cgi->url_param("uid"), $out_ref);
	    
	}else{
	    $out_ref->{tmpl_file} = "$af->{site__tmpl_dir}/owner_side/admin_managefriends_top.tmpl";
	    manage_top($af, $out_ref);
	}

    }


    #####################################################################
    #modify_member
    #####################################################################
    sub modify_member{
	my $af = shift;                 #arg(1) AF
	my $uid = shift;                #arg(2) uid
	my $cgi = shift;                #arg(3) CGI

	debug_print("StandAlone::modify_member uid[$uid] start.");

	my $attr = $cgi->url_param("modified");
	my $value = $cgi->param($attr);
	debug_print("StandAlone::modify_member [$attr] is modified to [$value]");

	$af->getFM->set_attribute_by_id($uid, $attr, $value);

	debug_print("StandAlone::modify_member uid[$uid] end.");
    }

    #####################################################################
    #remove_member
    #####################################################################
    sub remove_member{
	my $af = shift;                 #arg(1) AF
	my $uid = shift;                #arg(2) uid
	my $cgi = shift;                #arg(3) cgi

	debug_print("StandAlone::remove_member uid[$uid] start.");
	my $afid = $af->getFM->get_attribute_by_uid($uid, "af_id");

	#Remove entry(uid) from AFuser_CORE_friends
	#Remove uid from friends of others in AFuser_CORE_friends
	#Remove entry(uid) from AFuser_CORE_friendsfriends
	#Remove uid from friends of others in AFuser_CORE_friendsfriends
	$af->getFM->remove_friend($uid);

	#Remove uid from groups
	$af->getGM->remove_person_from_all($uid);

	#add uid to erasedfriends



	debug_print("StandAlone::remove_member uid[$uid] end.");
    }

    #####################################################################
    #show_member
    #####################################################################
    sub show_member{
	my $af = shift;                 #arg(1) AF
	my $uid = shift;                #arg(2) uid
	my $output_ref = shift;         #arg(3) ref of %output_data; 
	
	debug_print("StandAlone::show_member uid[$uid] start.");

	my @person = $af->getFM->get_friend_by_uid($uid);
	#  returns array(0uid, 1af_id, 2nickname, 3timestamp, 
	#            4password, 5intro, 6option_pid, 7lastupdated, 8 f2list)
	debug_print("StandAlone::show_member [@person]");

	$output_ref->{"uid"} = $person[0];

	#Set nickname and image URL
	$output_ref->{"nickname"} = $person[2];
	my $image_URL = generate_getcontentURL($af,
					       $af->{site__user_afid},
					       "self",
					       $person[1],
					       $person[4],
					       "core",
					       "/profile/profile_face.jpg");

	$output_ref->{"image_URL"} = $image_URL;

	#Set this friend's intro message
	$output_ref->{"intro"} = $person[5];
	
	#####################
	
	#Get attribute table
	my $attributes = $af->getPM->get_attribute_table();

	#####################
	#F1 

	#Get permission list of "F1"
	my $perm_result = $af->getPERM->get_permission("f", "f1");
	my @perm_F1 = $perm_result->fetchrow_array;
	debug_print("StandAlone::show_member: perm_F1=[@perm_F1]");

	#Set values
	my @row=();
	while(@row = $attributes->fetchrow_array){
	    #debug_print("StandAlone::show_member: row=[@row]");

	    my $attribute_name = $row[1];
	    
	    my $aid = $row[0];  #attribute ID
	    my $TMPL_var_value = $perm_F1[$aid+3];
	    # Why +3?
	    #  [0] ... Permission ID
	    #  [1] ... "f"
            #  [2] ... "f1"
            #  [3] ... perm for "nickname" which is always 1.
            #  [4] ... 1st element. <=

	    if($TMPL_var_value >= 1){
		$output_ref->{"f1_$attribute_name"} = $TMPL_var_value;
		$output_ref->{"sum_$attribute_name"} = $TMPL_var_value;
	    }else{
		$output_ref->{"f1_$attribute_name"} = "";
	    }
	}

	#####################
	#Group

	#Get group lists which the target friends belongs to
	my $groups_SQL = $af->getGM->get_groups_by_uid($person[0]);

	my @groups_ret=();

	#For each group returned...
	while( (my ($gid, $group_name, $members, $option_pid) 
		= $groups_SQL->fetchrow_array)){

	    debug_print("StandAlone::show_member: User uid[$uid] is in group[$gid].");
	    debug_print("StandAlone::show_member: gid=[$gid], gname=[$group_name], member=[$members], pid=[$option_pid]");

	    if($gid <1){last;}

	    my %this_group_ret =();
	    $this_group_ret{"group_name"} = $group_name;

	    #For each group, get the permission list.
	    my $g_perm_result = $af->getPERM->get_permission("g", "$gid");
	    my @g_perm = $g_perm_result->fetchrow_array;
	    debug_print("StandAlone::show_member: group_permission=[@g_perm]");

	    #Get attribute table
	    my $attributes = $af->getPM->get_attribute_table();

	    #Set values
	    while(my ($attr_id, $attr_name, $attr_type) 
		  = $attributes->fetchrow_array){

		if($attr_id < 0) {last;}
		#debug_print("StandAlone::show_member: [$attr_name]");

		if($g_perm[$attr_id+3] >= 1){
		    $this_group_ret{$attr_name} = $g_perm[$attr_id+3];
		    $output_ref->{"sum_$attr_name"} = $g_perm[$attr_id+3];
		}else{
		    $this_group_ret{$attr_name} = "";
		}
	    }

	    $this_group_ret{"gid"} = $gid;
	    $this_group_ret{"uid"} = $uid;
#	    $this_group_ret{"tmpl_path"} = $output_ref->{tmpl_path};
	    push(@groups_ret, \%this_group_ret);


	}#while

	$output_ref->{"groups"} = \@groups_ret;

	##################################################
	#Groups that the user DOES NOT belong to
	my $add_groups_SQL = $af->getGM->get_unsubscribing_groups_by_uid($uid);

	my @add_groups_ret=();

	#For each group returned...
	while( (my ($gid, $group_name, $members, $option_pid) 
		= $add_groups_SQL->fetchrow_array)){

	    push(@add_groups_ret, {group_name =>$group_name,
				   gid => $gid}
		 );
	}
	$output_ref->{"add_groups"} = \@add_groups_ret;
    }



    #####################################################################
    #subscribe_group
    #####################################################################
    sub subscribe_group{
	my $af = shift;                 #arg(1) AF
	my $gid = shift;                #arg(3) GID
	my $uid = shift;                #arg(2) UID

	debug_print("StandAlone::subscribe_group: start. g[$gid] u[$uid]");

	$af->getGM->add_member($gid, $uid);

	debug_print("StandAlone::subscribe_group: end.");
    }

    #####################################################################
    #unsubscribe_group
    #####################################################################
    sub unsubscribe_group{
	my $af = shift;                 #arg(1) AF
	my $gid = shift;                #arg(3) GID
	my $uid = shift;                #arg(2) UID

	debug_print("StandAlone::unsubscribe_group: start. g[$gid] u[$uid]");

	$af->getGM->remove_member($gid, $uid);

	debug_print("StandAlone::unsubscribe_group: end.");
    }


    #####################################################################
    #manage_top
    #####################################################################
    sub manage_top{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(2) ref of %output_data; 

	my @friends_list=();
	my $result = $af->getFM->get_all_friend_list(sort => 'nickname');

	while( my @row = $result->fetchrow_array ){

	    my $userhome_URL = $af->{site__user_afid} 
                              . "/outgoing.cgi?dest_url=" . $row[1];

	    my $editlink_URL = 'admin.cgi?mode=manage_friends&mode2=show_member&uid=' . $row[0];
	    my $delete_URL = 'admin.cgi?mode=manage_friends&mode2=delete&uid=' . $row[0];

	    push(@friends_list, {nickname      => $row[2],
				 userhome_URL  => $userhome_URL,
				 editlink_URL  => $editlink_URL,
				 delete_URL  => $delete_URL,
				 tmpl_path     => $output_ref->{tmpl_path}
			     });
	}

	$output_ref->{"friends"} = \@friends_list;
    }


}#package
1;
