# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ManageGroup.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::ManageGroup;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);

    use Exporter;
    @Affelio::App::Standalone::Admin::ManageGroup::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::ManageGroup::EXPORT = qw (manage_top rename_group  add_group remove_group handler);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	my $wi = new Affelio::misc::WebInput();
	
	my $sub_mode = $wi->PTN_mode($cgi->url_param("mode2"));

	try{
	    if($sub_mode eq "rename"){
		rename_group($af, $cgi->url_param("gid"), 
			     $cgi->param("new_name"));
	    }elsif($sub_mode eq "add_group"){
		add_group($af, $cgi->param("new_group_name"));
	    }elsif($sub_mode eq "remove_group"){
		remove_group($af, $cgi->url_param("gid"), $cgi);
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};

	if($sub_mode eq "show_group"){
	    $out_ref->{tmpl_file}= "$af->{site__tmpl_dir}/owner_side/admin_managegroups_showgroup.tmpl";
	    show_group($af, $cgi->url_param("gid"), $out_ref);
	}else{
	    $out_ref->{tmpl_file} = "$af->{site__tmpl_dir}/owner_side/admin_managegroups_top.tmpl";
	    manage_top($af, $out_ref);
	}
    }

    #####################################################################
    #rename_group
    #####################################################################
    sub rename_group{
	my $af = shift;                 #arg(1) AF
	my $gid = shift;                #arg(2) gid
	my $new_name = shift;           #arg(3) new_name

	$af->getGM->rename_group($gid,$new_name);
    }

    #####################################################################
    #add_group
    #####################################################################
    sub add_group{
	my $af = shift;                 #arg(1) AF
	my $group_name = shift;         #arg(2) new_name

	if($group_name eq ""){
	    return;
	}

	debug_print("StandAlone::ManageGroup:add_group start.[$group_name]");

	#Create a new group
	my $gid = $af->getGM->add_group($group_name);
	debug_print("StandAlone::ManageGroup:add_group added group.");

	#Get attribute table
	my $attributes = $af->getPM->get_attribute_table();
	#Set values
	my @g_perm=();
	while(my ($attr_id, $attr_name, $attr_type) 
	      = $attributes->fetchrow_array){
	    $g_perm[$attr_id] = 0;
	}
	$g_perm[1] = 1;

	debug_print("StandAlone::ManageGroup:add_group newg group=[@g_perm]");

	$af->getPERM->add_permission("g", $gid, \@g_perm);

	debug_print("StandAlone::ManageGroup:add_group end.");
    }

    #####################################################################
    #remove_group
    #####################################################################
    sub remove_group{
	my $af = shift;          #arg(1) AF
	my $gid = shift;         #arg(2) gid
	my $q = shift;           #arg(3) CGI

	$af->getGM->remove_group($gid);
    }


    #####################################################################
    #manage_top
    #####################################################################
    sub manage_top{
	my $af = shift;                 #arg(1) AF
	my $output_ref = shift;         #arg(2) ref of %output_data; 

	my @friends_list=();
	my $result = $af->getGM->get_all_group_list();

	while( my @row = $result->fetchrow_array ){

	    my $group_attr_URL = 'admin.cgi?mode=access_control';
	    my $group_member_URL = 'admin.cgi?mode=group_member_table';
	    my $removelink_URL = 'admin.cgi?mode=manage_groups&mode2=remove_group&gid=' . $row[0];
	    my $rename_URL = 'admin.cgi?mode=manage_groups&mode2=rename&gid=' . $row[0];

	    push(@friends_list, {group_name      => $row[1],
				 rename_URL      => $rename_URL,
				 group_attr_URL  => $group_attr_URL,
				 group_member_URL  => $group_member_URL,
				 removelink_URL  => $removelink_URL,
#				 tmpl_path     => $output_ref->{tmpl_path}
			     });
	}

	$output_ref->{"friends"} = \@friends_list;
    }


}#package
1;
