# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: NeighborNews.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::NeighborNews;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);
    use Fcntl;
    use LWP::Simple 'get';
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::WebInput qw(delete_HTML);
    use Affelio::exception::IOException;
    use Affelio::misc::Time;

    use Exporter;
    @Affelio::App::Standalone::Admin::NeighborNews::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::NeighborNews::EXPORT = qw (show_news);

    #######################################################################
    #show_news
    #######################################################################    
    sub show_news{
	my $af = shift;
	my $output_ref = shift;

	my $ret="";

	my $sqlret = $af->getNghrNews()->retrieve_news(10);
	my $index = 0;
	my @row=();
	while(($index < 10) && (@row = $sqlret->fetchrow_array) ){

#datetime, af_id, nickname, app_install_name, title, description, creator, URL
	    my $datetime = Affelio::misc::Time::timestamp2string($row[0]);
	    my $af_id = $row[1];
	    my $name = $row[2] . "/" . $row[3];
	    my $title = $row[4];
	    my $url1 = $row[7];

	    my $url2 = "$af->{site__user_afid}/outgoing.cgi?"
		. "dest_url=$af_id&dest_url2=$url1";

	    debug_print("StandAlone::$url2");

	    $ret .= "<TR><TH>$datetime</TH>"
		. "<TD><A HREF=\"$af_id\" target=\"_blank\">$name</A></TD>"
		. '<TD><A HREF="' . $url2 . '" target="_blank">' . $title. "</A></TD>"
		. "</TR>";

	    debug_print("StandAlone::$ret");

	    $index++;
	}	    

	$output_ref->{NeighborNews} = $ret;
    }


}
1;
