# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: SendInvitation.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::SendInvitation;
{
    use strict;

    use lib("../../../../../extlib/");
    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);

    use Exporter;
    @Affelio::App::Standalone::Admin::SendInvitation::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::SendInvitation::EXPORT = qw (send_invitation);

    #####################################################################
    #send_invitation
    #####################################################################
    sub send_invitation{
	my $af = shift;
	my $dest_address  = shift;      #arg(2) destination address
	my $output_ref = shift;         #arg(3) ref of %output_data; 
	
	debug_print("StandAlone::send_invitation: start. dest=[$dest_address]");

	my $encoded_subject = "Invitation to Affelio";

	my $TMPL_FILE = "$af->{site__tmpl_dir}/invitation_email.tmpl";
	my $emailbody = `cat $TMPL_FILE`;

	$emailbody =~ s/\[TO_ADDR\]/$dest_address/g;
	$emailbody =~ s/\[FROM_NICKNAME\]/$af->{user__nickname}/g;
	$emailbody =~ s/\[FROM_ADDR\]/$af->{user__email1}/g;
	$emailbody =~ s/\[FROM_URL\]/$af->{site__user_afid}/g;

	my $intro_url= "http://www.handshaker.jp/?from=" 
	    . $af->{site__web_root} . "&preferred="
	    . $af->{userpref__preferred_hosting_service};

	$emailbody =~ s/\[INTRO_URL\]/$intro_url/g;


	open(MAIL, " | $af->{cmd__nkf} -j | $af->{cmd__sendmail} -t ");
	print MAIL "To: $dest_address\n";
	print MAIL "From: $af->{user__email1}\n";
	print MAIL "Subject: $encoded_subject\n";
	print MAIL "Content-Type: text/plain; charset=iso-2022-jp\n";
	print MAIL "MIME-Version: 1.0\n\n";
	print MAIL $emailbody;
	close(MAIL);	

	#Set notice message
	$output_ref->{'notice'} = "Email sent to $dest_address";

	debug_print("StandAlone::send_invitation: end.");
    }

}#package
1;
