# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Top.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::Admin::Top;
{
    use strict;

    use lib("../../../../../extlib/");
    use Error qw(:try);

    use lib("../../../");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Time qw(timestamp2string get_timestamp);
    use Affelio::misc::WebInput;
    use Affelio::exception::CommunicationException;

    use Exporter;
    @Affelio::App::Standalone::Admin::Top::ISA = "Exporter";
    @Affelio::App::Standalone::Admin::Top::EXPORT = qw (show post_mystatus handler);

    #######################################################################
    #handler
    #######################################################################
    sub handler{
	my $cgi = shift;
	my $af = shift;
	my $out_ref = shift;
	
	debug_print("StandAlone::Top::handler: start.");

	my $wi = new Affelio::misc::WebInput();
	my $sub_mode = $wi->PTN_mode($cgi->url_param("action"));

	###############################
	#post my news
	###############################
	try{
	    if( $sub_mode eq "post_mystatus" ){
		debug_print("StandAlone::Top::handler: before post_mystatus...");
		post_mystatus($af, $cgi->param("my_currentstatus"));
		debug_print("StandAlone::Top::handler: after post_mystatus...");
	    }
	}catch Error with{
	    my $e = shift;
	    $out_ref->{err_msg} .= $e->stacktrace . '<BR>';
	};

	###############################
	#normal show
	###############################
	$out_ref->{tmpl_file}
	= "$af->{site__tmpl_dir}/owner_side/admin_top.tmpl";
	
	show($af, $cgi, $out_ref);
	debug_print("StandAlone::Top::handler: end.");
    }

    #######################################################################
    #post_mystatus
    #######################################################################
    sub post_mystatus{
	my $af = shift;
	my $currentstatus = shift;

	debug_print("StandAlone::Top::post_mystatus: start [$currentstatus]");

	$af->{user__currentstatus} = $currentstatus;

	$af->getPM->save_profile();

	debug_print("StandAlone::MyStatus::post end");
    }

    #######################################################################
    #show
    #######################################################################    
    sub show{
	my $af= shift;
	my $q=shift;
	my $out_ref = shift;
	debug_print("StandAlone::Top::show start.");

	use Affelio::App::Standalone::Admin::NeighborNews;
	Affelio::App::Standalone::Admin::NeighborNews::show_news($af, $out_ref);

	use Affelio::App::Standalone::Admin::AffelioNews;
	Affelio::App::Standalone::Admin::AffelioNews::getnews($af, $out_ref);

	$out_ref->{my_currentstatus}= $af->{user__currentstatus};

	debug_print("StandAlone::Top::show end.");
    }


}
1;


