# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: FriendRoutines.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::FriendRoutines;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../../lib");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::MyCrypt qw( msg_encrypt url_encode);
    use Affelio::misc::Time qw(get_timestamp get_expire_stamp);
    use Affelio::misc::NetMisc qw(get_remote_host);

    use Exporter;
    @Affelio::App::Standalone::FriendRoutines::ISA = "Exporter";
    @Affelio::App::Standalone::FriendRoutines::EXPORT = qw (get_friends_list_IF get_friends_list generate_getcontentURL get_summed_permission_list);

    #####################################################################
    #get_summed_permission_list
    #####################################################################
    sub get_summed_permission_list{
	my $af = shift;                 #arg(1) AF
	my $visitor_id = shift;         #arg(2) visitor_ID  
	my $visitor_mode = shift;       #arg(3) visitor_mode
	my @ret_list=();

	debug_print("StandAlone::get_summed_permission_list: start.");
	debug_print("StandAlone::get_summed_permission_list: visitor_id  = $visitor_id");
	debug_print("StandAlone::get_summed_permission_list: visitor_mode= $visitor_mode");

	if($visitor_mode eq "f2" || $visitor_mode eq "pb"){
	    ####################
	    # f2 or PB
	    ####################

	    my $SQL_ret = $af->getPERM->get_permission("f", $visitor_mode);
	    @ret_list = $SQL_ret->fetchrow_array;
	    # Now...
	    # $ret_list[0] = Permission ID
	    # $ret_list[1] = "f"
	    # $ret_list[2] = "f2"
	    # $ret_list[3] = perm for nickname      ...aid=1
	    # $ret_list[4] = perm for 1st element   ...aid=2

	    shift(@ret_list);
	    shift(@ret_list);
	    shift(@ret_list);
	    # $ret_list[0] = perm for nickname      ...aid=0
	    # $ret_list[1] = perm for 1st element   ...aid=1

	}elsif($visitor_mode eq "self"){

	    ####################
	    # self
	    ####################

	    #In case of "self" .... everything is 1.
	    my $attributes = $af->getPM->get_attribute_table();

	    my @row=();
	    while(@row = $attributes->fetchrow_array){
		push(@ret_list, 1)
	    }

	}else{
	    ####################
	    # f1
	    ####################
	    #We will make 
	    #  perm(f1) OR Vx(perm(G))

	    #Get permssion for F1
	    my $SQL_ret1 = $af->getPERM->get_permission("f", $visitor_mode);
	    @ret_list = $SQL_ret1->fetchrow_array;

	    #Get the visitor's UID
	    my ($t_uid, $t_afid, $t_nickname, $t_time,
		$t_pass, $t_intro, $t_pid, $t_lastupdated, $t_f2list) 
		= $af->getFM->get_friend_by_afid($visitor_id);

	    #Get the visitor's groups
	    my $SQL_result = $af->getGM->get_groups_by_uid($t_uid);

	    #For each group...
	    my @g_data=();
	    while(@g_data = $SQL_result->fetchrow_array) {	    
		my $gid = $g_data[0];
		my $SQL_ret2 = $af->getPERM->get_permission("g", $gid);
		my @list1 = $SQL_ret2->fetchrow_array;

		#For each value...
		my $i=0;
		for($i=0; $i <= $#list1; $i++){

		    $ret_list[$i] = $ret_list[$i] | $list1[$i]
		} 
	    }

	    # Now...
	    # $ret_list[0] = Permission ID
	    # $ret_list[1] = "f"
	    # $ret_list[2] = "f2"
	    # $ret_list[3] = perm for nickname      ...aid=1
	    # $ret_list[4] = perm for 1st element   ...aid=2

	    shift(@ret_list);
	    shift(@ret_list);
	    shift(@ret_list);
	    # Now...
	    # $ret_list[0] = perm for nickname      ...aid=0
	    # $ret_list[1] = perm for 1st element   ...aid=1
	}


	return(@ret_list);
    }



    #####################################################################
    #get_friends_list
    #####################################################################
    sub get_friends_list{
	my $af = shift;                 #arg(1) AF
	my $visitor_id = shift;         #arg(2) visitor_ID  
	my $visitor_type = shift;       #arg(3) visitor_ID  
	my $max_friend_num = shift;     #arg(4) max num
	my $sort = shift;               #arg(5) sort
	my $mode = shift;               #arg(6) mode 
	my @ret_list;

	if ($visitor_id eq ""){
	    $visitor_id = "anonymous";
	}

	debug_print("StandAlone::FriendRoutines: visitor_id=$visitor_id");
	debug_print("StandAlone::FriendRoutines: visitor_type=$visitor_type");

	######################################
	#Get all friends' table from FriendManager
	######################################
	my $do_sort="";
	my $do_order="asc";

	debug_print("StandAlone::FriendRoutines: sort = [$sort]\n");
	if($sort eq "link_old"){
	    $do_sort = "timestamp";
	    $do_order = "asc";
	}
	if($sort eq "link_new"){
	    $do_sort = "timestamp";
	    $do_order = "desc";
	}
	if($sort eq "access_latest"){
	    $do_sort = "last_access";
	    $do_order = "desc";
	}
	if($sort eq "access_freq"){
	    $do_sort = "count_access";
	    $do_order = "desc";
	}
	if($sort eq "incoming"){
	    $do_sort = "count_incoming";
	    $do_order = "desc";
	}
	if($sort eq "outgoing"){
	    $do_sort = "count_outgoing";
	    $do_order = "desc";
	}

	my $sth = $af->getFM->get_all_friend_list(sort => $do_sort,
						  order => $do_order);

	######################################
	#Build up a return array
	######################################
	my @person=();
	my $count = $max_friend_num; 

	while((@person = $sth->fetchrow_array)
	      && (($count > 0) || ($count == -1))
	      ) {
	    debug_print("StandAlone::FriendRoutines: friend=(@person)");
	    #$person[0] uid
	    #$person[1] af_id
	    #$person[2] nickname
	    #$person[3] timestamp
	    #$person[4] password
	    #$person[5] intro
	    #$person[6] option_pid
	    #$person[7] lastupdated
	    #$person[8] f2list
	    
	    my $image_URL = generate_getcontentURL($af,
						   $visitor_id,
						   $visitor_type,
						   $person[1],
						   $person[4],
						   "core",
						   "/profile/profile_face.jpg");
	    debug_print("StandAlone::FriendRoutines: image_URL= $image_URL\n");

	    my $mystatus_URL = "";

	    if($mode eq "iframe"){
		$mystatus_URL = generate_getcontentURL($af,
						       $visitor_id,
						       $visitor_type,
						       $person[1],
						       $person[4],
						       "core",
						       "/profile/mystatus_iframe");
	    }else{
		$mystatus_URL = generate_getcontentURL($af,
						       $visitor_id,
						       $visitor_type,
						       $person[1],
						       $person[4],
						       "core",
						       "/profile/mystatus");
	    }
	    debug_print("StandAlone::FriendRoutines: mystatus_URL= $mystatus_URL\n");
		
	    #Generate Hyperlink target URL
	    my $dest_URL = $af->{site__user_afid} . "/outgoing.cgi?dest_url=" . $person[1];

	    my $editurl="";
	    if($visitor_type eq "self"){
		$editurl = $af->{site__user_afid} . "/admin.cgi?mode=manage_friends&mode2=show_member&uid=" . $person[0];
	    }
	    my $mailurl="";
	    if($visitor_type eq "self"){
		$mailurl = $af->{site__user_afid} . "/admin.cgi?mode=messages&action=compose&reply_to=" . $person[1];
	    }

	    push(@ret_list, {nickname  => $person[2],
			     URL       => $dest_URL,
			     image_URL => $image_URL,
			     editurl   => $editurl,
			     mailurl   => $mailurl,
			     intro     => $person[5],
			     mystatus_URL => $mystatus_URL
			     }
	     	 );

	    if($max_friend_num > 0){
		$count--;
	    }
	}#while

	return(@ret_list);

    }




		



    ######################################################################
    #generate_contentURL
    #   returns image_URL
    #   arg(1) af
    #   arg(2) visitor's ID
    #   arg(3) visitor's type
    #   arg(4) friend's AF_ID
    #   arg(5) friend's password
    #   arg(6) destination module "core" "app1" "app2" etc..
    #   arg(7) content name
    ######################################################################
    sub generate_getcontentURL{
	my $af = shift;
	my $visitor_afid = shift;
	my $visitor_type = shift;
	my $f_af_id      = shift;
	my $f_password   = shift;
	my $module       =shift;  
	my $content      =shift;  

	#1.PassAB(timestamp, 
        #         expire,  
        #         browser's IP, 
        #         AF_ID,             Who is accessing?
        #         type)

	my $plaintext = 
	    get_timestamp()            . "*" . 
	    get_expire_stamp(0,0,15)   . "*" . 
	    get_remote_host(%ENV)      . "*" . 
	    $visitor_afid              . '*' . 
	    $visitor_type              . '*';

	debug_print("StandAlone::generate_getcontentURL: [$plaintext]\n");

	my $getcontentURL = $f_af_id
	    . "/bin/get_content.cgi?module=$module&content=$content&cfid=" 
	    . url_encode( msg_encrypt($plaintext, $f_password)) 
	    . "&referrer=" . $af->{site__user_afid};

	return($getcontentURL);

    }#func




}#package
1;
