# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: MyNewsRoutines.pm,v 1.1 2006/03/07 14:39:09 slash5234 Exp $

package Affelio::App::Standalone::MyNewsRoutines;
{
    use strict;

    use lib("../../../../extlib/");
    use lib("../../../../lib");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Time;

    use Exporter;
    @Affelio::App::Standalone::MyNewsRoutines::ISA = "Exporter";
    @Affelio::App::Standalone::MyNewsRoutines::EXPORT = qw(show_news);

    #####################################################################
    #show_news
    #####################################################################
    sub show_news{
	my $af = shift;                 #arg(1) AF
	my $visitor_afid = shift;         #arg(2) visitor_ID  
	my $visitor_type = shift;       #arg(3) visitor_type
	#
	my @ret_list=();


	my @app_list=();
	my $this_app_ref;
	my $tmp_name;
	while ( ($tmp_name, $this_app_ref) = each( %{$af->getAM->{apps}} ) ){
	    my %this_app = %$this_app_ref;
	    
	    my $perm_to_tab=0;
	    $perm_to_tab
		= $af->getAM->get_summed_app_perm($visitor_afid,
						  $visitor_type,
						  $this_app{'install_name'},
						  "DF_access");
	    if($perm_to_tab ==1 ){
		push(@app_list, $this_app{'install_title'});
	    }	
	    debug_print("StandAlone::S::get_news: [$tmp_name]");
	}
	#while
	debug_print("StandAlone::S::get_news: app_list = @app_list");
	
	#################################
	#get what's new contents
	#################################
	my $news = $af->getMyNews()->retrieve_news(app_list => \@app_list,
						   laterthan => 0);

	my @row=();
	my $count=0;
	while((@row = $news->fetchrow_array) && ($count < 10)){
	    push(@ret_list, {date => timestamp2stringB($row[1]),
			     app => $row[2],
			     title => $row[3],
			     url => $row[6]});
	    $count++;
	}

	return @ret_list;
    }
}
1;
