# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: get_content.pm,v 1.1 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::App::Standalone::Public::Bin::get_content;
{
    use strict;

    use lib("../../../../../../extlib/");
    use lib("../../../../../../lib/");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);

    use Exporter;
    @Affelio::App::Standalone::Public::Bin::get_content::ISA = "Exporter";
    @Affelio::App::Standalone::Public::Bin::get_content::EXPORT = qw (run);

    #######################################################################
    #run
    #######################################################################
    sub run{
	$| = 1;

use CGI qw(-unique_headers);
use CGI::Session; #qw(-ip_match);
use Error qw(:try);

use Affelio;
use Affelio::App::Standalone::Env;
use Affelio::App::Standalone::FriendRoutines qw(get_summed_permission_list);
use Affelio::misc::MyCrypt qw(url_decode msg_decrypt);
use Affelio::misc::Time qw(get_timestamp);
use Affelio::misc::NetMisc qw(get_remote_host);
use Affelio::misc::WebInput;

#Load Affelio and CGI
my $q = new CGI;
my $cfg_dir = "../config/";
my $af = new Affelio(ConfigDir => $cfg_dir,
		     CGI => $q);
my $wi = new Affelio::misc::WebInput(); 

#Retrieve args
my $module = $wi->PTN_word($q->param("module"));
if($module eq "" || !defined($module)){
    error($q,"Input parameters are not defined.(module)");
}

my $content = $wi->PTN_getcontent_content($q->param("content"));
if($content eq "" || !defined($content)){
    error($q,"Input parameters are not defined.(content)");
}

my $ck_visitor_type=0;
my $ck_visitor_type_str="pb"; 
my $ck_visitor_afid = "";

############################################################################
#Load session from cookie
############################################################################
my $session = $af->getSM()->get_session();

if(!$session){
    debug_print("StandAlone::get_content: session not found.");
    $ck_visitor_type=0;
    $ck_visitor_type_str="pb"; 
    $ck_visitor_afid = "";
}else{
    my $type = $session->param("type");

    if($type eq "self"){
	debug_print("StandAlone::get_content: session found. [self]");
	$ck_visitor_type=3; 
	$ck_visitor_type_str="self"; 
	$ck_visitor_afid = $session->param("user_afid");
    }elsif($type eq "f1"){
	debug_print("StandAlone::get_content: session found. [f1]");
	$ck_visitor_type=2; 
	$ck_visitor_type_str="f1"; 
	$ck_visitor_afid = $session->param("user_afid");
    }elsif($type eq "f2"){
	debug_print("StandAlone::get_content: session found. [f2]");
	$ck_visitor_type=1; 
	$ck_visitor_type_str="f2"; 
	$ck_visitor_afid = $session->param("user_afid");
    }
}


#CFID check
my $CFID_timestamp;
my $CFID_expire;
my $CFID_remotehost;
my $CFID_visitor_afid;
my $CFID_visitor_type=0;
my $CFID_visitor_type_str="pb";

if( ($ck_visitor_type <= 2) 
    && ( $q->param("referrer") ne "")
    && ( $q->param("cfid") ne "" )       
    ){

    my $referrer = $wi->PTN_URL($q->param("referrer"));
    if($referrer =~ /(.*)\/$/){
	$referrer = $1;
    }

    my $passAB = $af->getFM->get_attribute_by_afid($referrer, "password");
    if($passAB eq "" || !defined($passAB)){
	error($q,"Parameters are not defined. (1): Your peer does not have shared password with you...");
    }

    my $cfid = msg_decrypt( url_decode($q->param("cfid") ) , $passAB) ;
    if($cfid eq "" || !defined($cfid)){
	error($q,"Parameters are not defined. (2): Invalid encryption: After decryption, we could not valid your encrypted message...");
    }

    #######################################################################
    #Check cfid
    ($CFID_timestamp, $CFID_expire, $CFID_remotehost, $CFID_visitor_afid, $CFID_visitor_type_str) = split('\*', $cfid);

    #check timestamp
    #check expire
    #check remotehost
    #check visitor_afid
    debug_print("StandAlone::get_content: Information extracted from CFID");
    debug_print("StandAlone::get_content: \ttimestamp    =$CFID_timestamp\n");
    debug_print("StandAlone::get_content: \texpire       =$CFID_expire\n");
    debug_print("StandAlone::get_content: \tremote_host  =$CFID_remotehost\n");
    debug_print("StandAlone::get_content: \tvisitor_afid =$CFID_visitor_afid\n");
    debug_print("StandAlone::get_content: \tvisitor_type(original) =$CFID_visitor_type_str\n");

    #check visitor_type_str
    if($CFID_visitor_type_str eq "self") { 
	$CFID_visitor_type_str = "f1";
	$CFID_visitor_type =2;
    }elsif($CFID_visitor_type_str eq "f1") { 
	$CFID_visitor_type_str = "f2";
	$CFID_visitor_type =1;
    }else{
	$CFID_visitor_type_str = "pb";
	$CFID_visitor_type =0;
    }
    debug_print("StandAlone::get_content: \tvisitor_type(decreased) =$CFID_visitor_type_str\n");

}


############################################################################
#Well, after all, who is it?
############################################################################
my $visitor_type=0;              #3=self 2=f1 1=f2 0=pb
my $visitor_type_str="pb";
my $visitor_afid="";

if($ck_visitor_type == 3){

    $visitor_type = $ck_visitor_type;
    $visitor_type_str = $ck_visitor_type_str;
    $visitor_afid = $ck_visitor_afid;

}elsif($ck_visitor_type > $CFID_visitor_type){

    $visitor_type = $ck_visitor_type;
    $visitor_type_str = $ck_visitor_type_str;
    $visitor_afid = $ck_visitor_afid;

}else{

    $visitor_type = $CFID_visitor_type;
    $visitor_type_str = $CFID_visitor_type_str;
    $visitor_afid = $CFID_visitor_afid;
}

#######################################
#Is this visitor a friend of this site?

if($visitor_type < 3){
    my $tmp1 = $af->getFM->get_attribute_by_afid($visitor_afid, "password");

    if($tmp1 ne ""){
	$visitor_type = 2;  
	$visitor_type_str="f1"; 
	$visitor_afid = $CFID_visitor_afid;
    }
}

debug_print("StandAlone::get_content: Finally...");
debug_print("StandAlone::get_content: \tvisitor_type = [$visitor_type] [$visitor_type_str]");
debug_print("StandAlone::get_content: \tvisitor_type = [$visitor_afid]");
debug_print("StandAlone::get_content: \tmodule    = [$module]\n");
debug_print("StandAlone::get_content: \tcontent   = [$content]\n");


############################################################################
#Output content
############################################################################
if($module eq "core"){

    if($content =~ /^\/profile\/profile\_face([0-9a-zA-Z\_]*)\.jpg$/){

	debug_print("StandAlone::get_content: image!");

	#Get summarized permission list for the given user
	my @list 
	    =  get_summed_permission_list($af, 
					  $visitor_afid, 
					  $visitor_type_str);

	debug_print("StandAlone::get_content: Got summarized permission...");
	debug_print("StandAlone::get_content: \t[@list]");

	my $permission = $list[5] ;
	debug_print("StandAlone::get_content: Pic perm: $permission");

	my $real_filename = $content;
	$real_filename =~ s|/profile/||;

	my $actual_file="";
	if( $permission ==1)
	{
	    $actual_file = "$af->{site__user_dir}/$real_filename";
	}else{
	    $actual_file = "$af->{site__fs_root}/skins/$af->{userpref__skin}/0_face.jpg";
	}
	open(IMG, "< $actual_file");
	print "Content-type: image/jpeg\n";
	print "Pragma: no-cache\n\n"; 
	binmode (IMG);
	binmode (STDOUT);
	print <IMG>;
	close IMG;
    }

    if($content eq "/profile/mystatus"){

	debug_print("StandAlone::get_content: mystatus!");
	my $mystatus="&nbsp;";
	if( $visitor_type >= 2){
	    $mystatus = $af->{user__currentstatus};
	}
	print "Content-type:application/x-javascript\n\n";
	print "document.write(\"$mystatus\");";
	print "\n\n";
	exit(1);
    }

    if($content eq "/profile/mystatus_iframe"){

	debug_print("StandAlone::get_content: mystatus!");
	my $mystatus="&nbsp;";
	if( $visitor_type >= 2){
	    $mystatus = $af->{user__currentstatus};
	}
	print "Content-type: text/html; charset=UTF-8\n";
	print "Pragma: no-cache\n\n"; 

	# " ni kiwo tsukero!!!! escape! escape! " --> \"
        print "<HTML><body TOPMARGIN=0 LEFTMARGIN=0 MARGINHEIGHT=0 MARGINWIDTH=0><div style=\"margin:0px; padding:0px; font-family:sans-serif; font-size:xx-small;\">$mystatus</div></body></HTML>";
	debug_print("StandAlone::get_content: mystatus!");
	exit(1);
    }

    print "Content-type: text/html; charset=UTF-8\n";
    print "Pragma: no-cache\n\n"; 
    print "<HTML></HTML>";
    exit(1);

}
exit(1);



    }#method
    #######################################################################
}
1;
