# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: logoutexec.pm,v 1.1 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::App::Standalone::Public::Bin::logoutexec;
{
    use strict;

    use lib("../../../../../../extlib/");
    use lib("../../../../../../lib/");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);

    use Exporter;
    @Affelio::App::Standalone::Public::Bin::logoutexec::ISA = "Exporter";
    @Affelio::App::Standalone::Public::Bin::logoutexec::EXPORT = qw (run);

    #######################################################################
    #run
    #######################################################################
    sub run{
use CGI qw(-unique_headers);
use CGI::Session; #qw(-ip_match);
use HTML::Template;
use Error qw(:try);
use Affelio;
use Affelio::App::Standalone::Env;
use Affelio::SNS::Handshaker_c;
use Affelio::misc::NetMisc;
use Affelio::misc::MyCrypt;
use Affelio::misc::Time;

debug_print("StandAlone::logoutexec.cgi: start.");

my $q = new CGI;
############################################################################
#Load Affelio
############################################################################
my $cfg_dir = "../config/";
my $af;
try{
    $af = new Affelio(ConfigDir => $cfg_dir,
		      CGI => $q);
}catch Error with{
    my $e = shift;
    error($q, "Affelio load error.\n" . $e);
};
my $wi = new Affelio::misc::WebInput;

############################################################################
#Check session w/ cookie
############################################################################
my $sid = $q->cookie("affelio-$af->{user__nickname}");
my $session = $af->getSM->get_session();

if($session){
    #Output expired cookie and redirect the user to index.
    $session->delete();
    $session->flush();
    undef($session);

    #Output expired cookie and redirect the user to index.
}

print $q->redirect( -url => $af->{site__user_afid});

debug_print("StandAlone::logoutexec.cgi: end.");
exit(1);




    }#method
    #######################################################################
}
1;
