# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Index.pm,v 1.1 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::App::Standalone::Public::Index;
{
    use strict;

    use lib("../../../../../extlib/");
    use lib("../../../../../lib/");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time;
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Standalone::Public::Index::ISA = "Exporter";
    @Affelio::App::Standalone::Public::Index::EXPORT = qw (run);

    #######################################################################
    #run
    #######################################################################
    sub run{
	use CGI qw(-unique_headers);
	use CGI::Session; #qw(-ip_match);
	use HTML::Template;
	use Error qw(:try);
	use Fcntl;
	
	use Affelio;
	use Affelio::misc::CGIError;
	use Affelio::misc::Debug qw(debug_print);
	use Affelio::misc::NetMisc;
	use Affelio::misc::Time;
	use Affelio::misc::WebInput;

	debug_print("StandAlone::index.cgi: start.");
	my $q = new CGI;

        #################################################################
        #Load Affelio
        #################################################################
	my $wi = new Affelio::misc::WebInput(); 
	my $cfg_dir = "./config/";
	my $af;
	try{
	    $af = new Affelio(ConfigDir => $cfg_dir,
			      CGI => $q);
	}catch Error with{
	    my $e = shift;
	    error($q, "Affelio load error.\n" . $e);
	};

        #################################################################
        #Check session w/ cookie
        #################################################################
	my $session = $af->getSM->get_session();

        #################################################################
	my $visitor_type="pb";
	my $visitor_nickname="anonymous";
	my $visitor_afid="";
	
	if($session){
	    $visitor_type 
		= $wi->PTN_visitor_type($session->param("type"));
	    $visitor_nickname 
		= $wi->PTN_nickname($session->param("user_nickname"));
	    
	    $visitor_afid 
		= $wi->PTN_URL($session->param("user_afid"));
	}
	if($visitor_type eq ""){
	    $visitor_type="pb";
	    $visitor_nickname="anonymous";
	}
	debug_print("StandAlone::index.cgi: visitor_type=      $visitor_type");
	debug_print("StandAlone::index.cgi: visitor_nickname=  $visitor_nickname");
	debug_print("StandAlone::index.cgi: visitor_afid=      $visitor_afid");
	
        #################################################################
        #Main
        #################################################################
	my %output_data = ();
	my $TMPL_FILE ="";
	my $INJ_FILE ="";
	
	$af->load_ApplicationManager();
	
        ######################################################
        #Template file
        ######################################################
	my $mode = $wi->PTN_mode($q->url_param("mode"));
	if(($af->{userpref__toppage_app_installname} eq "Affelio")
	   || ($mode ne "") ){
	    #top page is Affelio module.
	    debug_print("StandAlone::index.cgi CGI mode = [$mode]");
	    if($mode eq "") {
		$mode="index";
	    }
	    $TMPL_FILE = "$af->{site__tmpldyn_dir}/"  . $mode . ".tmpl";
	    $INJ_FILE = "$af->{site__tmpldyn_dir}/"  . $mode . ".inj";
	    
	}else{
	    
	    #top page is NOT Affelio module but one of applications.
	    my $abs_next_URL = $af->{site__web_root} . "/" . 
		$af->{userpref__toppage_app_path};
	    
	    print "Location: $abs_next_URL", "\n\n";    
	    exit(1);
	}
	
        ######################################################
        #Data prep (1)
        ######################################################
	
        #################
        #Site info
        #################
	$output_data{"site__web_root"}  = $af->{site__web_root}; 
	$output_data{"site__user_afid"} = $af->{site__user_afid};
	$output_data{"site__skin_dir"} = $af->{site__web_root} . "/skins/" . $af->{userpref__skin};
	$output_data{"site__locale"} = $af->{site__locale};
	
	try{
	    $af->get_module_list(\%output_data, $visitor_afid, $visitor_type);
	    if($visitor_type eq "self"){
		$af->get_guest_owner_list(\%output_data);
	    }
	}catch Error with{
	    my $e = shift;
	    error($q, "Affelio init error.\n" . $e);
	};
	
        #################
        #Client info
        #################
	$output_data{'client_afid'}= $visitor_afid;
#
	my $relation;
	if($visitor_type eq "self"){
	    $relation = $af->{lh}->maketext("_VISITOR_TYPE_SELF");
	}elsif($visitor_type eq "f1"){
	    $relation = $af->{lh}->maketext("_VISITOR_TYPE_F1");
	}elsif($visitor_type eq "f2"){
	    $relation = $af->{lh}->maketext("_VISITOR_TYPE_F2");
	}else{
	    $relation = $af->{lh}->maketext("_VISITOR_TYPE_PB");
	}
	$output_data{'client_relationship'}= $relation;
	
	$output_data{'client_type'}= $visitor_type;
	$output_data{'client_nickname'}= $visitor_nickname;
	$output_data{'client_type_' . $visitor_type}= "true";
	
        #################
        #Default profile info
        #################
	$output_data{'profile_nickname'} = $af->{user__nickname};
	$output_data{"profile_intromesg1"} = $af->{user__intromesg1};
	$output_data{'profile_myimage_path'} = 
	    "./bin/get_content.cgi?module=core&content=/profile/profile_face.jpg";
	
	if(($visitor_type eq "f1") ||  ($visitor_type eq "f2")){
	    $output_data{'send_mesg_URL'} = 
		$visitor_afid . "/admin.cgi?mode=messages&action=compose&to_url="
		. $af->{site__web_root};
	}else{
	    $output_data{'send_mesg_URL'} = "";
	}
	
	$output_data{'make_friend_URL'} 
	= $visitor_afid . "/admin.cgi?mode=makefriend&dest_url="
	    . $af->{site__web_root};
	
        ######################################################
        #Data prep from Models 
        ######################################################
	sysopen(INJ, $INJ_FILE, O_RDONLY);
	my $injection_flg = <INJ>;
	close INJ;
	
        #Inject Profile Data
	use Affelio::App::Standalone::ShowProfile;
	try{
	    Affelio::App::Standalone::ShowProfile::show_profile($af,
						    \%output_data, 
						    $visitor_type,
						    $visitor_afid);
	  }catch Error with{
	      my $e = shift;
	      error($q, "Affelio: model execution  error.\n" . $e);
	  };
	
        ##############################
        #Friendlist
 	use Affelio::App::Standalone::FriendRoutines;
        ##############################
	my $flist_sort = $wi->PTN_mode($q->param("flist_sort"));
	if ($flist_sort eq ""){ $flist_sort = "access_latest";}
	
	my @friendlist_5_IF;
	if($injection_flg =~ /block\_friendlist\_5\_IF\,/){
	    try{
		@friendlist_5_IF = get_friends_list($af,$visitor_afid, $visitor_type,5, $flist_sort, "iframe");
	    }catch Error with{
		my $e = shift;
		error($q, "Affelio: model execution  error.\n" . $e);
	    };
	    $output_data{"friendlist_5_IF"} = \@friendlist_5_IF;
	}
        ##############################
	my @friendlist_5;
	if($injection_flg =~ /block\_friendlist\_5\,/){
	    try{
		@friendlist_5 = get_friends_list($af, $visitor_afid, $visitor_type, 5, $flist_sort, "");
	    }catch Error with{
		my $e = shift;
		error($q, "Affelio: model execution  error.\n" . $e);
	    };
	    $output_data{"friendlist_5"} = \@friendlist_5;
	}
        ##############################
	my @friendlist_all;
	if($injection_flg =~ /block\_friendlist\_all\,/){
	    try{
		@friendlist_all = get_friends_list($af, $visitor_afid, $visitor_type, -1,$flist_sort, "");
	    }catch Error with{
		my $e = shift;
		error($q, "Affelio: model execution  error.\n" . $e);
	    };
	    $output_data{"friendlist_all"} = \@friendlist_all;
	}
        ##############################
	my @friendlist_all_IF;
	if($injection_flg =~ /block\_friendlist\_all_IF\,/){
	    try{
		@friendlist_all_IF=get_friends_list($af,$visitor_afid,$visitor_type,-1, $flist_sort, "iframe");
	    }catch Error with{
		my $e = shift;
		error($q, "Affelio: model execution  error.\n" . $e);
	    };
	    $output_data{"friendlist_all_IF"} = \@friendlist_all_IF;
	}
        ##############################
	my @newsbox;
	if($injection_flg =~ /block\_newsbox\,/){
	    try{
		require Affelio::App::Standalone::MyNewsRoutines;
		@newsbox = Affelio::App::Standalone::MyNewsRoutines::show_news($af,$visitor_afid,$visitor_type);
	    }catch Error with{
		my $e = shift;
		error($q, "Affelio: model execution  error.\n" . $e);
	    };
	    $output_data{"newsbox"} = \@newsbox;
	}
        ##############################
	try{
	    $output_data{"friend__F1count"} = $af->getFM->get_F1_count();
	    $output_data{"friend__F2count"} = $af->getFM->get_F2_count();
	}catch Error with{
	    my $e = shift;
	    error($q, "Affelio: error from FriendManager\n" . $e);
	};
        ######################################################		
        #Inject data into template 
        ######################################################	
	my $tmpl;
	try{
	    $tmpl = new HTML::Template( filename => $TMPL_FILE,
					die_on_bad_params => 0);
	    $tmpl->param(%output_data);
	}catch Error with{
	    my $e = shift;
	    error($q, "Affelio: error in HTML::Template init.\n" . $e);
	};
	
	
        ######################################################		
        #Output
        ######################################################	
	print "Content-type: text/html; charset=UTF-8\n";
	print "Pragma: no-cache", "\n\n"; 
	print $af->translate_templateL10N($tmpl->output);
	
        ######################################################		
        #AccessLog
        ######################################################	
	if($visitor_type ne "self"){
	    my $afid;
	    if($visitor_afid eq ""){
		$afid = $q->remote_host;
	    }else{
		$afid = $visitor_afid;
	    }
	    
	    try{
		$af->getALM->save_log($afid, $visitor_nickname, $visitor_type);
	    }catch Error with{
		my $e = shift;
		error($q, "Affelio: error in AccessLogging\n" . $e);
	    };
	}
        ######################################################	
        #NewsAggregator
        ######################################################	
	$a = $af->getNghrNews->get_one();
	
    }#method

}
1;
