# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Outgoing.pm,v 1.1 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::App::Standalone::Public::Outgoing;
{
    use strict;

    use lib("../../../../../extlib/");
    use lib("../../../../../lib/");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Time;
    use Affelio::misc::WebInput;

    use Exporter;
    @Affelio::App::Standalone::Public::Outgoing::ISA = "Exporter";
    @Affelio::App::Standalone::Public::Outgoing::EXPORT = qw (run);

    #######################################################################
    #run
    #######################################################################
    sub run{
	use CGI qw(-unique_headers);
	use CGI::Session; #qw(-ip_match);
	use Error qw(:try);
	
	use Affelio;
	use Affelio::App::Standalone::Env;
	use Affelio::misc::CGIError;
	use Affelio::misc::Debug;
	use Affelio::misc::Time;
	use Affelio::misc::MyCrypt;
	use Affelio::misc::NetMisc;
	use Affelio::misc::WebInput;
	
	debug_print("StandAlone::outgoing.cgi: start.\n");
	my $q = new CGI;
	
############################################################################
#Load Affelio
############################################################################
	my $cfg_dir = "./config/";
	my $af;
	try{
	    $af = new Affelio(ConfigDir => $cfg_dir,
			      CGI => $q);
	    
	}catch Error with{
	    my $e = shift;
	    error($q, "Affelio load error.\n" . $e);
	};
	my $wi = new Affelio::misc::WebInput(); 
	
############################################################################
#Check session w/ cookie
############################################################################
	my $session = $af->getSM()->get_session();
	
	my $visitor_type="pb";
	my $visitor_nickname="anonymous";
	my $visitor_afid="";
	
	if($session){
	    $visitor_type = $session->param("type");
	    $visitor_nickname = $session->param("user_nickname");
	    $visitor_afid = $session->param("user_afid");
	}
	debug_print("StandAlone::outgoing.cgi: visitor_type=      $visitor_type");
	debug_print("StandAlone::outgoing.cgi: visitor_nickname=  $visitor_nickname");
	debug_print("StandAlone::outgoing.cgi: visitor_afid=      $visitor_afid");
	
############################################################################
#Main
############################################################################
	
#########################################
# Retrieve user's IP current address
	my $user_addr = $q->remote_addr;
	my $user_addr_is_private = check_private_IP_addr($user_addr);
	debug_print("StandAlone::outgoing.cgi: user's IP= $user_addr\n");
	debug_print("StandAlone::outgoing.cgi: user's IP privateflag= $user_addr_is_private\n");
	
#########################################
# Retrieve destination URL
	my $dest_URL = $wi->PTN_URL($q->param("dest_url"));
	$dest_URL =~ s|/$||;
	my $dest_URL2 = $wi->PTN_URL($q->param("dest_url2"));
	debug_print("StandAlone::outgoing.cgi: dest_URL=$dest_URL");
	
#########################################
# retrieve passAB
	my $passAB="";
	try{
	    $passAB = $af->getFM->get_attribute_by_afid($dest_URL, "password");
	    
	    $af->getFM->set_attribute_by_afid($dest_URL,
					      "last_outgoing",
					      Affelio::misc::Time::get_timestamp());
	    
	    $af->getFM->incr_attribute_by_afid($dest_URL,
					       "count_outgoing");
	    
	}catch Error with{
	    my $e = shift;
	    error($q, "Error from FriendManager.\n" . $e);
	};
	debug_print("StandAlone::outgoing.cgi: passAB=$passAB\n");
	if(!defined($passAB) || $passAB eq ""){
	    print $q->redirect($dest_URL);
	    exit(1);
	}
	
	
	
#########################################
# Put this forwarding information into my DB
# so that we can logout this session in the future.
# XXX
	
#########################################
#Output HTTP reply (Location header).
#
# Location-header:
#  http://siteB.com/bin/incoming.cgi?session=(1)&referrer=(2)
#
#1.PassAB(timestamp, 
#         expire,  
#         browser's IP, 
#         AF_ID,             Who is accessing?
#         nickname,          Who is accessing?
#         type)
#
#2.URL(A)               Where is this forwarding from?

	my $plain_msg = "";
	if($visitor_type eq "self"){
	    $plain_msg = get_timestamp()    . "*" . 
		get_expire_stamp(1,0,0)     . "*" . 
		$q->remote_addr             . "*" . 
		url_encode($visitor_afid)       . "*" . 
		url_encode($visitor_nickname)   . "*" . 
		"self" .'*';
	}elsif($visitor_type eq "f1"){
	    $plain_msg = get_timestamp()    . "*" . 
		get_expire_stamp(1,0,0)     . "*" . 
		$q->remote_addr             . "*" . 
		url_encode($visitor_afid)       . "*" . 
		url_encode($visitor_nickname)   . "*" . 
		"f1" . '*';
	}elsif($visitor_type eq "f2"){
	    $plain_msg = get_timestamp()    . "*" . 
		get_expire_stamp(1,0,0)     . "*" . 
		$q->remote_addr             . "*" . 
		url_encode($visitor_afid)       . "*" . 
		url_encode($visitor_nickname)   . "*" . 
		"f2" . '*';
	}else{
	    $plain_msg = get_timestamp()    . "*" . 
		get_expire_stamp(1,0,0)     . "*" . 
		$q->remote_addr             . "*" . 
		url_encode($visitor_afid)         . "*" . 
		url_encode($visitor_nickname)     . "*" . 
		"pb" . '*';
	}
	debug_print("StandAlone::outgoing.cgi: plain_msg= $plain_msg\n");
	
#Encrypt
	my $cipher_msg = url_encode( msg_encrypt( $plain_msg, $passAB ) );
	debug_print("StandAlone::outgoing.cgi: cipher_msg= $cipher_msg\n");
	
#Build up URL
	my $forwarding_to = "$dest_URL/incoming.cgi?"
	    . "forward_id=$cipher_msg" 
	    . "&" 
	    . "referrer=$af->{site__user_afid}"
	    . "&dest_url=$dest_URL2";
	debug_print("StandAlone::outgoing.cgi: forwarding_to= $forwarding_to\n");
	
############################################################################
#Output
############################################################################
	if($user_addr_is_private){
	    #This access is from some private IP address.
	    #It means the user may have some problem in 
	    #session forwarding when the user is forwarded
	    #to the destination Affelio. So warn the user.
	    
	    my $TMPL_FILE = "$af->{site__tmpl_dir}/owner_side/outgoing_warn.tmpl";
	    
	    require HTML::Template;
	    my $tmpl = new HTML::Template( filename => $TMPL_FILE,
					   die_on_bad_params => 0);    
	    
	    my $warning_message = "<AF_M text='_SYS_WARN_OUTGOING_PRIV_IP' param='$user_addr'><P><A HREF=\"$forwarding_to\">Destination Affelio</A>: <AF_M text='_SYS_WARN_OUTGOING_PRIV_IP2'>";
	    $tmpl->param(message => $warning_message);
	    $tmpl->param(forwarding_to => $forwarding_to);
	    $tmpl->param(tmpl_path => "$af->{site__tmpl_web_path}/owner_side/");
	    print "Content-type: text/html; charset=UTF-8\n";
	    print "Pragma: no-cache", "\n\n"; 
	    print $af->translate_templateL10N($tmpl->output);
	    
	}else{
	    if($forwarding_to eq ""){
		$forwarding_to = $af->{site__user_afid};
	    }
	    print $q->redirect($forwarding_to);
	}
	
    }
}
1;
