#!/usr/bin/perl

# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: SimpleFileConnecter.pm,v 1.3 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::Backplane::FarmConnecter::SimpleFileConnecter;
{
    use strict;
    use lib("../../../../extlib");
    use Error qw(:try);
    use lib("../../../../lib");
    use Affelio::misc::Debug;
    use Affelio::exception::IOException;

    use vars qw(@ISA);
    @ISA = qw(Affelio::Backplane::FarmConnecter);

    sub new{
	debug_print("SimpleFileConn: start.");

	my $class = shift;
	my %param = @_;
    
	my $file_path = $param{path};
	debug_print("SimpleFileConn: path = [$file_path]");
	my %config = ();

	my $self = {file_path => $file_path,
		config => \%config};
	bless $self, $class;

	my $line="";
	try{
	    open(IN, $file_path);
	    while($line = <IN>){
		chop($line);
		if($line =~ /^AF_CTRL_([A-Za-z0-9\-\_]*)\s*\=\s*(.*)/){
		    $config{$1} =$2;
		    debug_print("SimpleFileConn: [$1] = [$2]");	    
		}
	    }
	    close(IN);
	}catch  Error with{
	    my $e=shift;
	    debug_print("SimpleFileConn: $e");
	};

	return($self);
    }

    sub get_val{
	my $self =shift;
	my $arg = shift;

	debug_print("SimpleFileConn::get_val $arg = $self->{config}->{$arg}");
	return($self->{config}->{$arg});
    }

}
1;
