# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: MyNewsManager.pm,v 1.7 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::Managing::MyNewsManager;
{
    use strict;
    use lib("../../../extlib");    
    use Error qw(:try);
    use DBI;
    use Jcode;
    use lib("../../");
    use Affelio::misc::CGIError;
    use Affelio::misc::Time qw(get_timestamp);
    use Affelio::misc::Encoding qw(db_encode db_decode);
    use Affelio::misc::Debug qw(debug_print);

    #######################################################################
    #Constructor
    #######################################################################
    sub new{
	my $class = shift;
	my $af = shift;

	debug_print("MyNewsManager::new: start.");

	my $self = {af => $af
		    };

	bless $self, $class;

	debug_print("MyNewsManager::new: end.");
	return $self;
    }

    #MyNewsManager looks up each application directory
    #to get the whole list of message types.

    ########################################################################
    #retrieve_news
    ########################################################################
    sub retrieve_news{
	my $self = shift;
	my %arg = @_;
	my $laterthan= $arg{laterthan};
	if(!defined($laterthan)){ $laterthan = 0; }

	my $af = $self->{af};
	debug_print("MyNews::retrieve: start [$laterthan]");

	##############################
	#application list
	my $app_list =join("' or app_install_name='", @{$arg{app_list}});
	$app_list ="app_install_name='" . $app_list . "'";
	debug_print("MyNews::retrieve: apps [$app_list]");

	my $query= "SELECT nid, datetime, app_install_name, title, description, creator, URL FROM $af->{site__dbtbl_prefix}_CORE_my_news WHERE datetime > $laterthan and ($app_list) order by datetime desc";
	debug_print("MyNews::retrieve: query [$query]");

	##############################
	#retrieve all friend records from DB
	my $sth;
	try{
	    $sth = $af->getDB()->prepare($query) or die $af->getDB->errstr;
	    $sth->execute;
	}catch Error with{
	    my $e = shift;
	    debug_print($e);
	    throw($e);
	};

	debug_print("MyNews::retrieve: end");
	return($sth);
    }

    #######################################################################
    #post_news
    #  arg1 app_install_title (UTF-8)
    #  arg2 title (UTF-8)
    #  arg3 desc (UTF-8)
    #  arg4 creator (UTF-8)
    #  arg5 URL (UTF-8)
    #######################################################################
    sub post_news{
	my $self = shift;
	my %arg = @_;
	my $datetime = Affelio::misc::Time::get_timestamp();
	my $app_install_name = $arg{app};
	my $title = $arg{title};
	my $description = $arg{desc};
	my $creator = $arg{creator};
	my $URL = $arg{URL};

	my $af = $self->{af};

	debug_print("MyNews:post_message: start.");

	##############################
	#Insert a new record
	my $sth = "insert into $af->{site__dbtbl_prefix}_CORE_my_news(datetime, app_install_name, title, description, creator, URL) values ($datetime, '$app_install_name', '$title', '$description', '$creator', '$URL')";
	$sth = $af->getDB->prepare($sth) or die $af->getDB->errstr;
	$sth->execute or  die $af->getDB->errstr;

	Affelio::misc::Debug::debug_print("MyNews::post_message: end.");

	return("");
    }

}#package
1;
