# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# $Id: ProfileManager.pm,v 1.7 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::Managing::ProfileManager;
{
    use strict;
    use lib("../../../extlib");    
    use DBI;
    use Jcode;
    use Error qw(:try);
    use lib("../../");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::exception::DBException;
    
    #######################################################################
    #Constructor
    #######################################################################
    sub new{
	my $class = shift;
	my $af = shift;
	my $mode = shift;

	debug_print("ProfileManager::new: start.");

	my $self = {af => $af,
		    mode => $mode
		    };

	bless $self, $class;

	#Load profile
	if($mode ne "init"){
	    $self->load_profile();
	}

	debug_print("ProfileManager::new: end.");
	return $self;
    }

    
    #######################################################################
    #save_profile
    #######################################################################
    sub save_profile{
	my $self = shift;
	my $af = $self->{af};

	#Write down user__* variables
	foreach my $key (sort keys %$af){
	    if($key =~ /user__/){
		my $key2 = $key;
		$key2 =~ s/user__//g;
		debug_print("ProfileManager::save_profile: $key2 = $af->{$key}");
		if($af->{$key} ne ""){
		    try{
			save_profile_value($self, $key2, $af->{$key});
		    }catch Affelio::exception::DBException with {
			my $e = shift; 
			throw $e;
		    };
		}
	    }
	} 

	return("");
    }

    sub save_profile_value{
	my $self = shift;
	my $af = $self->{af};
	my $attribute = shift;
	my $value = shift;

	my $db = $af->getDB();

	debug_print("ProfileManager::save_profile_value: ($attribute) = ($value)");
	my $query = "SELECT * FROM $af->{site__dbtbl_prefix}_CORE_prof where attribute = '$attribute'";
	my $sth1;
	eval{
	    $sth1 = $db->prepare($query);
	    $sth1->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($db->errstr);
	}
	my @result= $sth1->fetchrow_array();
	undef($sth1);

	if(@result==()){

	    my $query2 = "insert into $af->{site__dbtbl_prefix}_CORE_prof(attribute, value) values (?,?)";
	    my $sth2="";
	    eval{
		$sth2 = $db->prepare($query2);
		$sth2->execute($attribute, $value);
	    };
	    if($@){
		throw Affelio::exception::DBException($db->errstr);
	    }
	    undef($sth2);

	}else{
	    my $query3 = "update $af->{site__dbtbl_prefix}_CORE_prof set value = '$value' where attribute = '$attribute'";

	    my $sth3;
	    eval{
		$sth3 = $db->prepare($query3);
		$sth3->execute;
	    };
	    if($@){
		throw Affelio::exception::DBException($db->errstr);
	    }
	    undef($sth3);
	}
    }


    #######################################################################
    #load_profile
    #######################################################################    
    sub load_profile{
	my $self = shift;
	my $af = $self->{af};
	
	debug_print("ProfileManager::load_profile: start.");
	
	my $SQL_profattr;

	try{
	    $SQL_profattr = load_profile_table($self);
	}catch Affelio::exception::DBException with {
	    my $e = shift; 
	    throw $e;
	};
	
	my $attribute=""; my $value="";
	while( ($attribute, $value) = $SQL_profattr->fetchrow_array){
	    $af->{"user__$attribute"} = $value;
	    debug_print("ProfileManager::load_profile: user__$attribute = " 
			. $af->{"user__$attribute"});
	}
	
	debug_print("ProfileManager::load_profile: end.");
	return("");
    }

    ########################################################################
    #load_profile_table
    #   returns SQL_result (attribute, value)  x records
    ########################################################################
    sub load_profile_table{
	my $self = shift;
	my $af = $self->{af};

	my $sth;
	my $query = "SELECT * FROM $af->{site__dbtbl_prefix}_CORE_prof";

	eval{
	    $sth = $af->getDB->prepare($query);
	    $sth->execute(); 
	};
	if($@){
	    throw Affelio::exception::DBException($af->getDB->errstr);
	};

	return($sth);
    }

    ########################################################################
    #get_attribute_table
    #   returns SQL_result   (aid, name, type)  x records
    ########################################################################
    sub get_attribute_table{
	my $self = shift;
	my $af = $self->{af};

	##############################
	#retrieve all friend records from DB
	my $query = "SELECT * FROM $af->{site__dbtbl_prefix}_CORE_prof_attr";
	my $sth;

	eval{
	    $sth = $af->getDB->prepare($query);
	    $sth->execute;
	};
	if($@){
	    throw Affelio::exception::DBException($af->getDB->errstr);
	};

	return($sth);
    }



}#package
1;
