# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: SessionManager.pm,v 1.6 2006/03/07 14:39:10 slash5234 Exp $

package Affelio::Managing::SessionManager;
{
    use strict;
    use lib("../../../extlib");    
    use Error qw(:try);
    use CGI::Session;
    use DBI;
    use Jcode;
    use lib("../../");
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug qw(debug_print);
    use Affelio::misc::NetMisc;

    #######################################################################
    #Constructor
    #######################################################################
    sub new{
	my $class = shift;

	debug_print("SessionManager::new: start.");

	my $af="";
	my $session="";

	my $self = {af => $af,
		    ss => $session
		    };

	bless $self, $class;

	debug_print("SessionManager::new: end.");
	return $self;
    }

    #######################################################################
    #init
    #######################################################################
    sub init{
	my $self = shift;
	my $af = shift;


	debug_print("SessionManager::init: start.");

	$self->{af} = $af;
        my $cgi = $af->{cgi};
        my $given_sid = $cgi->cookie("affelio-$af->{user__nickname}");
	debug_print("SessionManager::init: sid from cookie: [" . $given_sid . "]");
        if($given_sid){
            $self->{ss} = new CGI::Session(undef,
                                        $given_sid,
					{Directory=> $af->{site__session_dir}});
            debug_print("SessionManager::init: sid after load: [" . $self->{ss}->id . "]");
        }
	debug_print("SessionManager::init:   $self->{ss}");

	if($self->{ss}){
	    if( $given_sid ne $self->{ss}->id ){
		debug_print("SessionManager::init:   SID in user's cookie already expired.");
		debug_print("SessionManager::init:   session deleted.");
		$self->{ss}->delete();
		$self->{ss}->flush();
		undef($self->{ss});
	    }
	}

	debug_print("SessionManager::init: end.");
    }

    ######################################################################
    #get_userclass
    ######################################################################
    sub get_userclass{
	my $self = shift;
	my $af = $self->{af};
	
	if(!$self->{ss}) {return undef;}
	
	return ($self->{ss}->param("type"));
    }

    ######################################################################
    #get_session
    ######################################################################
    sub get_session{
	my $self = shift;
	return($self->{ss});
    }

    ######################################################################
    #startup_session
    ######################################################################
    sub startup_session{
	my $self = shift;
	my $af = $self->{af};
	#
	my %param = @_;

	if($self->{ss}){
	    debug_print("SessionManager::startup: found existing [" 
			. $self->{ss}->id . "]");
	    $self->{ss}->delete();
	    undef($self->{ss});	    
	    debug_print("SessionManager::startup: deleted.");
	}

	$self->{ss} = new CGI::Session("driver:File",
				       undef,
				  {Directory=> $af->{site__session_dir}});

	#Set values into session
	$self->{ss}->param("user_afid", $param{user_afid});
	$self->{ss}->param("user_nickname", $param{user_nickname});
	$self->{ss}->param("type", $param{type});

	debug_print("SessionManager::startup: created [".$self->{ss}->id."]");
	debug_print("SessionManager::startup: user_afid = $param{user_afid}");
	debug_print("SessionManager::startup: user_nickname = $param{user_nickname}");
	debug_print("SessionManager::startup: type = $param{type}");
    }

    ######################################################################
    #issue_cookie
    ######################################################################
    sub issue_cookie{
	my $self = shift;
	my $af = $self->{af};

	my $cookie = $af->{cgi}->cookie(
                    -name => "affelio-$af->{user__nickname}",
		    -value => $self->{ss}->id(),
		    -path => URL2path($af->{site__user_afid}));

	debug_print("SessionManager::issue_cookie: created [".$self->{ss}->id."]");
	debug_print("SessionManager::startup: name = affelio-$af->{user__nickname}");
	debug_print("SessionManager::startup: path = " . URL2path($af->{site__user_afid}));

	return($cookie);
    }
}
1;
