# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Handshaker_tmpDB.pm,v 1.6 2006/03/07 14:39:11 slash5234 Exp $

use strict;
use lib("../../../extlib/");
use DBI;
use lib("../../");
use Affelio;
use Affelio::misc::Debug;
use Affelio::misc::CGIError;

########################################################################
package Affelio::SNS::Handshaker_tmpDB;
{
    ####################################################################
    #Constructor
    ####################################################################
    sub new{
	my $class = shift;
	my $af = shift;

	Affelio::misc::Debug::debug_print("Handshaker_tmpDB::new: start.");

	my $self = {af => $af
		    };

	bless $self, $class;

	Affelio::misc::Debug::debug_print("Handshaker_tmpDB::new: end.");
	return $self;
    }

    ####################################################################
    #add_received_Handshake
    ####################################################################
    sub add_received_Handshake{
	Affelio::misc::Debug::debug_print("add_received_Handshake: start.");
	return adddb(@_, "AFuser_SNS_tmp_recvd_hs");
    }

    ####################################################################
    #remove_received_Handshake
    ####################################################################
    sub remove_received_Handshake{
	Affelio::misc::Debug::debug_print("remove_received_Handshake: start.");
	return removedb(@_, "AFuser_SNS_tmp_recvd_hs");
    }

    ####################################################################
    #add_sent_Handshake
    ####################################################################
    sub add_sent_Handshake{
	Affelio::misc::Debug::debug_print("add_sent_Handshake: start.");
	return adddb(@_, "AFuser_SNS_tmp_sent_hs");
    }

    ####################################################################
    #remove_sent_Handshake
    ####################################################################
    sub remove_sent_Handshake{
	Affelio::misc::Debug::debug_print("remove_sent_Handshake: start.");
	return removedb(@_, "AFuser_SNS_tmp_sent_hs");
    }

    ####################################################################
    #adddb
    ####################################################################
    sub adddb{
	my $self = shift;
	my $sessionid = shift;       #arg(1) session no. (string)
	my $af_id = shift;           #arg(2) af_id     (string)
	my $nickname = shift;        #arg(3) nickname  (string)
	my $timestamp = shift;       #arg(4) timestamp (string) 
	my $DH_key_str = shift;      #arg(5) DH key (string)
	my $dbname = shift;          #arg(6) DBname (string)

	my $af = $self->{af};
	$dbname =~ s/AFuser/$af->{site__dbtbl_prefix}/;

	Affelio::misc::Debug::debug_print("add: $af_id $nickname $timestamp $DH_key_str $dbname");
	
	my $str = "insert into $dbname (sessionid, timestamp, af_id, nickname, DH_key_str) values ('$sessionid', '$timestamp', '$af_id', '$nickname', '$DH_key_str')";
	my $sth = $af->getDB->prepare($str);
	$sth->execute() or die $af->getDB->errstr;

	Affelio::misc::Debug::debug_print("add: end.");
	return;
    }

    ####################################################################
    #removedb
    ####################################################################
    sub removedb{
	my $self = shift;
	my $sessionid = shift;       #arg(1) session no. (string)
	my $dbname = shift;

	my $af = $self->{af};
	$dbname =~ s/AFuser/$af->{site__dbtbl_prefix}/;

	Affelio::misc::Debug::debug_print("removedb: $sessionid");

	my $str = "SELECT sessionid, timestamp, af_id, nickname, DH_key_str FROM $dbname WHERE sessionid= '$sessionid'";
	my $sth = $af->getDB->prepare($str) or die $af->getDB->errstr;
	$sth->execute() or die $af->getDB->errstr;
        my @row = $sth->fetchrow_array;

        if(!defined(@row)){
            Affelio::misc::Debug::debug_print("removedb: No such session.");
            return;
        }

	my $str = "DELETE FROM $dbname WHERE sessionid=?";
	my $sth = $af->getDB->prepare($str) or die $af->getDB->errstr;
	$sth->execute($sessionid);

	Affelio::misc::Debug::debug_print("removedb: end.");
	return @row;
    }


}


########################################################################
1;
