# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ImageEditor.pm,v 1.2 2006/03/07 14:39:11 slash5234 Exp $

package Affelio::misc::ImageEditor;
{
    use lib "../../../extlib";
    use Image::Magick;

    use Exporter;
    @Affelio::misc::ImageEditor::ISA = "Exporter";
    @Affelio::misc::ImageEditor::EXPORT = qw (resize_image);

    sub resize_image{
	my $orig_file = shift;
	my $out_file = shift;
	my $rect_size = shift;

	my $image = Image::Magick->new;
	$image->Read($orig_file);
	my ($width, $height) = $image->Get('width', 'height');
	
	if($width >= $height){
	    my $scale = $rect_size / $width;
	    $height = $height * $scale;
	    $width=$rect_size;
	}else{
	    my $scale = $rect_size / $height;
	    $width = $width * $scale;
	    $height=$rect_size;
	}
	$image->Resize(width=>$width, height=>$height, blur=>0.7);
	$image->Write($out_file);
    }

}
1;
