# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: InitAffelio.pm,v 1.19 2006/03/07 14:39:11 slash5234 Exp $

package Affelio::misc::InitAffelio;
{
    use strict;
    use Exporter;
    @Affelio::misc::InitAffelio::ISA = "Exporter";
    @Affelio::misc::InitAffelio::EXPORT = qw (create_userdir create_af_cfg create_db_cfg create_login_cfg copy_def_files init_db set_datadir_perm setup_affelio setup_affelio_AFE2 copy_def_aftemplate_files create_resized_images);

    use lib("../../../extlib/");
    use Cwd;
    use DBI;
    use Error qw(:try);
    use lib(".");
    use lib("../../../lib/");
    use Affelio;
    use Affelio::misc::CGIError;
    use Affelio::misc::Debug;
    use Affelio::misc::MyCrypt;
    use Affelio::misc::Util qw(get_userdir);
    use Affelio::App::Standalone::Admin::EditTemplates;
    use Affelio::exception::Exception;
    use Affelio::exception::DBException;
    use Affelio::exception::IOException;

    #####################################################################
    sub create_userdir{
	my $topdir = shift;

	srand(time ^ ($$ + ($$ << 15)));
	#userdata
	my $dir1 = Affelio::misc::MyCrypt::generate_password();
	mkdir("$topdir/userdata/$dir1", 0777);
	my $dir2 = Affelio::misc::MyCrypt::generate_password();
	mkdir("$topdir/session/$dir2", 0777);
    }

    #####################################################################
    sub create_af_cfg{
	my $affelio_cfg_path = shift;
	my $fs_root = shift;
	my $web_root = shift;
	my $char_set = shift;
	my $template = shift;
	my $sendmail_path = shift;
	my $additional_cfg = shift;

	eval{
	    open(OUT, "> $affelio_cfg_path");
	    print OUT "[site_config]\n";
	    print OUT "fs_root=$fs_root\n";
	    print OUT "web_root=$web_root\n";
	    print OUT "char_set =$char_set\n";
	    print OUT "template =$template\n";
	    print OUT "\n";
	    print OUT "[command]\n";
	    print OUT "sendmail=$sendmail_path\n";

	    if($additional_cfg){
		print OUT "[affelio_farm]\n";
		print OUT "$additional_cfg\n";
	    }

	    close OUT;

	    chmod 0444, "$affelio_cfg_path";
	};


    }

    #####################################################################
    sub create_db_cfg{
	my $db_cfg_path = shift;
	my $db_type = shift;
	my $db_dbname=shift;
	my $db_username = shift;
	my $db_password = shift;
	my $db_hostname = shift;
	my $db_port = shift;

	eval{
	    open(OUT, "> $db_cfg_path");
	    print OUT "[db]\n";
	    print OUT "type=$db_type\n";
	    print OUT "dbname=$db_dbname\n";
	    print OUT "username=$db_username\n";
	    print OUT "password=$db_password\n";
	    print OUT "hostname=$db_hostname\n";
	    print OUT "port=$db_port\n";
	    print OUT "[appdb]\n";
	    print OUT "type=$db_type\n";
	    print OUT "dbname=$db_dbname\n";
	    print OUT "username=$db_username\n";
	    print OUT "password=$db_password\n";
	    print OUT "hostname=$db_hostname\n";
	    print OUT "port=$db_port\n";
	    close OUT;
	};
    }

    #####################################################################
    sub create_login_cfg{
	my $login_cfg_path = shift;
	my $username = shift;
	my $crypted_password = shift;

	eval{
	    open(OUT, "> $login_cfg_path");
	    print OUT "[auth]\n";
	    print OUT "username=$username\n";
	    print OUT "password=$crypted_password\n";
	    close OUT;
	};
    }

    #####################################################################
    sub copy_def_files{
	my $top_dir=shift;
	my $user_dir=shift;
	my $locale = shift;
	my $password_remoteop = shift;

	#Copy default face JPEG file 
	system("cp -f $top_dir/defaults/profile_face.jpg $user_dir/profile_face.jpg");
	system("chmod 666 $user_dir/profile_face.jpg");

	#Copy default preference file
	system("cp -f $top_dir/defaults/preference.cfg $user_dir/preference.cfg");
	open(OUT, ">> $user_dir/preference.cfg");
	print OUT "password_remoteop= $password_remoteop\n";
	close(OUT);

	system("cp -fr $top_dir/defaults/af_templates/$locale $user_dir/af_templates");
      }

    #####################################################################
    sub copy_def_aftemplate_files{
	my $top_dir=shift;
	my $user_dir=shift;
	my $locale = shift;

	system("cp -fr $top_dir/defaults/af_templates/$locale/*.aftmpl $user_dir/af_templates/");
    }

    #####################################################################
    sub create_resized_images{
	my $root_dir=shift;
	my $user_dir=shift;
	
	require Affelio::misc::ImageEditor;
	Affelio::misc::ImageEditor::resize_image("$user_dir/profile_face.jpg", "$user_dir/profile_face_100x100.jpg", 100);
	Affelio::misc::ImageEditor::resize_image("$user_dir/profile_face.jpg", "$user_dir/profile_face_150x150.jpg", 150);
    }


    #####################################################################
    sub init_db{
	my $top_dir = shift;
	my $g_nickname = shift;
	my $g_email =shift;
	my $g_lh=shift;

	debug_print("init_db: [$top_dir] [$g_nickname] [$g_email]");

	################################################################
	#Stage 0: load Affelio (init mode)
	################################################################
	my $cfg_dir = "$top_dir/config/";
	my $af;
	my $dbh;
	try{
	    $af = new Affelio(ConfigDir => $cfg_dir,
			      Mode => "init");
	    $dbh = $af->getDB;
	}catch Error with{
	    my $e = shift;
	    throw Affelio::exception::Exception("Could not load Affelio (init): $e");
	};

	################################################################
	#Stage 1: DB creation
	################################################################

	################################
	#profile DB
	################################
	my $create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_prof(attribute TEXT, value TEXT) 
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating prof: $@");
	}

	$af->{user__nickname} = $g_nickname;
	$af->{user__email1} = $g_email;
	try{
	    $af->getPM->save_profile();
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("Cannot save_profile: $e");
	};
	debug_print("saved profile");

	################################
	#profile attribute DB
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_prof_attr(aid INTEGER, name TEXT, type INTEGER)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating attr: $@");
	}
	
	my $sth = "";
	eval{
	    $sth = $dbh->prepare("insert into $af->{site__dbtbl_prefix}_CORE_prof_attr(aid, name, type) values (?,?,?)");
	};
	if($@){
	    throw  Affelio::exception::DBException("SQL prepare: $@");
	}

	try{
	    open(FIN, "$top_dir/defaults/AFuser_CORE_prof_attr.csv");
	    
	    while(my $line=<FIN>){
		chomp($line);
		my ($aid, $name, $type) = split(',', $line);
		#print "$aid - $name - $type\n";
		
		$sth->execute($aid, $name, $type);
	    }
	    close(FIN);
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::IOException("prof_attr: $@");
	};

	################################
	#friends DB
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_friends(uid INTEGER PRIMARY KEY, af_id CHAR(255), nickname TEXT, timestamp TEXT, password TEXT, intro TEXT, option_pid INTEGER, lastupdated TEXT, f2list TEXT, last_news_in INTEGER DEFAULT 0, last_news_out INTEGER DEFAULT 0,last_access INTEGER DEFAULT 0, count_access INTEGER DEFAULT 0, last_incoming INTEGER DEFAULT 0, count_incoming INTEGER DEFAULT 0, last_outgoing INTEGER DEFAULT 0, count_outgoing INTEGER DEFAULT 0, apps TEXT)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating friends tbl: $@");
	}
	
	################################
	#erasedfriends DB
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_erasedfriends(uid INTEGER PRIMARY KEY, af_id CHAR(255), timestamp TEXT)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating erased friends tbl: $@");
	}

	################################
	#friendsfriends DB
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_friendsfriends(uid INTEGER PRIMARY KEY, af_id CHAR(255), nickname TEXT, timestamp TEXT, f1list TEXT)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating F2 tbl: $@");
	}

	################################
	#group DB
	################################
	$create_tbl_cmd = "CREATE TABLE $af->{site__dbtbl_prefix}_CORE_group(gid INTEGER, group_name TEXT, members TEXT, option_pid INTEGER)";
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating grp tbl: $@");
	}

	################################
	#Permission DB
	################################
	$create_tbl_cmd = "CREATE TABLE $af->{site__dbtbl_prefix}_CORE_permission(pid INTEGER, type TEXT, target_id  TEXT, ";

        for(my $i=0; $i<=63; $i++){
	    $create_tbl_cmd .= " attr$i INT,";
	}
        chop($create_tbl_cmd);
        $create_tbl_cmd .= ")";
        debug_print("setup: create [$create_tbl_cmd]");
	if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating perm tbl: $@");
	}

	################################
	#tmp_recvd_hs
        ################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_SNS_tmp_recvd_hs(sessionid TEXT, timestamp TEXT, af_id CHAR(255), nickname TEXT, DH_key_str TEXT)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating tmp_recved tbl: $@");
	}

	################################
	#tmp_sent_hs
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_SNS_tmp_sent_hs(sessionid TEXT, timestamp TEXT, af_id CHAR(255), nickname TEXT, DH_key_str TEXT)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating tmp_send tbl: $@");
	}
				
	################################
	#message
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_message(mid INTEGER PRIMARY KEY, timestamp TEXT, msgtitle TEXT, msgtype TEXT, msgfrom TEXT, msgbody TEXT, readflag INTEGER)
EOT
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating msg tbl: $@");
	} 

	################################
	#apps
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_apps(appid INTEGER PRIMARY KEY AUTOINCREMENT, 
			      install_name TEXT, 
			      install_title TEXT,
			      app_URI TEXT,
			      app_name TEXT,
			      app_version TEXT,
			      app_desc TEXT,
			      app_author TEXT,
			      guest_index TEXT,
			      owner_index TEXT,
			      action_types TEXT,
			      action_types_desc TEXT)
EOT
        if($af->{site__db_type} eq "mysql"){
	    $create_tbl_cmd =~ s/AUTOINCREMENT/AUTO\_INCREMENT/g;
	}

        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating apps tbl: $@");
	} 

	################################
	#my_news
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_my_news(nid INTEGER PRIMARY KEY AUTOINCREMENT, 
				   datetime INTEGER,
				   app_install_name TEXT,
				   title TEXT,
				   description TEXT,
				   creator TEXT,
				   URL TEXT)
EOT
        if($af->{site__db_type} eq "mysql"){
	    $create_tbl_cmd =~ s/AUTOINCREMENT/AUTO\_INCREMENT/g;
	}
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating mynews tbl: $@");
	} 


	################################
	#nghr_news
	################################
	$create_tbl_cmd = <<EOT;
CREATE TABLE $af->{site__dbtbl_prefix}_CORE_nghr_news(nid INTEGER PRIMARY KEY AUTOINCREMENT, 
				   datetime INTEGER,
				   af_id TEXT,
				   nickname TEXT,
				   app_install_name TEXT,
				   title TEXT,
				   description TEXT,
				   creator TEXT,
				   URL TEXT)
EOT
        if($af->{site__db_type} eq "mysql"){
	    $create_tbl_cmd =~ s/AUTOINCREMENT/AUTO\_INCREMENT/g;
	}
        if(!$dbh->do($create_tbl_cmd)){
	    throw  Affelio::exception::DBException("creating nghr_news tbl: $@");
	} 

	################################
	#disconnect DB
	################################
	try{				    
	    $dbh->disconnect;
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::DBException("DB disconnecting: $@");


	};  




	################################################################
	#Stage 2: Reload Affelio
	################################################################
	try{				    
	    undef($af);
	    $af = new Affelio(ConfigDir => $cfg_dir);
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("Couldnot load Affelio: $e");
	};

	################################
	#Set permission to F1
	################################
	#                 n names  b i  intro   email     url     im
	my @flag_array = (1,1,1,1, 1,1, 1,1,    0,0,0,0, 1,1,1,1, 0,0,0,0,0,0, 1);
	try{				    
	    $af->getPERM->add_permission("f", "f1", \@flag_array); 
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("adding F1 perm: $@");
	};
	
	################################
	#Set permission to F2
	################################
	#                 n names  b i  intro   email     url     im
	my @flag_array = (1,0,0,0, 0,1, 1,1,    0,0,0,0, 1,1,1,1, 0,0,0,0,0,0, 1);
	try{				    
	    $af->getPERM->add_permission("f", "f2", \@flag_array); 
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("adding F2 perm: $@");
	};
	
	################################
	#Set permission to PB
	################################
	#                 n names  b i  intro   email     url     im
	my @flag_array = (1,0,0,0, 0,0, 1,0,    0,0,0,0, 0,0,0,0, 0,0,0,0,0,0, 0);
	try{				    
	    $af->getPERM->add_permission("f", "pb", \@flag_array); 
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("adding PB perm: $@");
	};
	
	################################
	#Make a new group "dear_friend"
	################################
	my $gid;
	try{				    
	    $gid = $af->getGM->add_group($af->{lh}->maketext("_SETUP_group_dear_friend"));
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("adding dear Grp: $@");
	};
	
	#####################################
	#Set permission to group "dear_friend"
	#####################################
	#                 n names  b i  intro   email     url     im
	my @flag_array = (1,1,1,1, 1,1, 1,1,    1,1,1,1, 1,1,1,1, 1,1,1,1,1,1, 1);
	try{				    
	    $af->getPERM->add_permission("g", $gid, \@flag_array); 
	}catch Error with{
	    my $e = shift;
	    throw  Affelio::exception::Exception("adding perm to Grp: $@");
	};
    }

    #####################################################################
    sub set_datadir_perm{
	my $top_dir = shift;
	my $userdir = get_userdir("$top_dir/userdata");

	#hmmmmmm....
	system("chmod -R 777 $userdir");
    }


    #####################################################################
    #setup_affelio
    #  all-in-one function to setup affelio
    #####################################################################
    sub setup_affelio{
	my $root_dir = shift;
	my $root_url = shift;
	my $locale = shift;
	my $lh = shift;
	my $template = shift;
	my $additional_cfg = shift;
	my $sendmail_path = shift;
	#
	my $db_type = shift;
	my $db_dbname = shift;
	my $db_username = shift;
	my $db_password = shift;
	my $db_hostname = shift;
	my $db_port = shift;
	#
	my $username = shift;
	my $password = shift;
	my $nickname =shift;
	my $email =shift;

	debug_print("InitAffelio:setup start.");
	debug_print("\t$root_dir ");
	debug_print("\t$root_url ");
	debug_print("\t$locale ");
	debug_print("\t$lh ");
	debug_print("\t$template ");
	debug_print("\t$additional_cfg");
	debug_print("\t$sendmail_path ");
	debug_print("\t$db_type ");
	debug_print("\t$db_dbname ");
	debug_print("\t$db_username ");
	debug_print("\t$db_password ");
	debug_print("\t$db_hostname ");
	debug_print("\t$db_port ");
	debug_print("\t$username ");
	debug_print("\t$password "); 
	debug_print("\t$nickname ");
	debug_print("\t$email ");

	################################
	#(1)Create user dir
	create_userdir($root_dir);
	debug_print("InitAffelio:setup (1) create dir done.");

	################################
	#(2)Create af_cfg
	create_af_cfg("$root_dir/config/affelio.cfg",
		      $root_dir,
		      $root_url,
		      $locale,
		      $template,
		      $sendmail_path,
		      $additional_cfg);
	chmod 0700, "$root_dir/config";
	debug_print("InitAffelio:setup (2) create affelio.cfg done.");

	################################
	#(3)Get userdata dir
	my $user_dir = "";
	$user_dir = get_userdir("$root_dir/userdata");
	debug_print("InitAffelio:setup (3) user dir = [$user_dir]");

	################################
	#(4)create db.cfg
	create_db_cfg("$user_dir/db.cfg",
		      $db_type,
		      $db_dbname,
		      $db_username,
		      $db_password,
		      $db_hostname,
		      $db_port);
	debug_print("InitAffelio:setup (4) create db.cfg done");

	################################
	#(5)create login.cfg
	my @salts = ( "A".."Z", "a".."z", "0".."9", ".", "/" );
	my $salt = $salts[int(rand(64))] . $salts[int(rand(64))];
	my $crypted_password = crypt($password, $salt);
	create_login_cfg("$user_dir/login.cfg",
			 $username,
			 $crypted_password);
	debug_print("InitAffelio:setup (5) create login.cfg [$crypted_password] done.");

	################################
	#(6)Copy default files
	copy_def_files($root_dir , $user_dir, $locale, "");
	debug_print("InitAffelio:setup (6) copy default files. done.");

	################################
	#(7)create resized images
	create_resized_images($root_dir, $user_dir);

	################################
	#(8)initialize DB
	init_db($root_dir , $nickname, $email, $lh);
	debug_print("InitAffelio:setup (7) Init DB done.");

	################################
	#(9)Rebuild template
	my $af;
	$af = new Affelio(ConfigDir => "$root_dir/config/");
	Affelio::App::Standalone::Admin::EditTemplates::rebuild($af);
	debug_print("InitAffelio:setup (8) Rebuild template done.");

	################################
	#(10)Set permission
	set_datadir_perm($root_dir );
	debug_print("InitAffelio:setup (9) Set permission done.");

	debug_print("InitAffelio:setup  ****ALL DONE****");
    }


    #####################################################################
    #setup_affelio_AFE2
    #  all-in-one function to setup affelio
    #####################################################################
    sub setup_affelio_AFE2{
	debug_print("InitAffelio:setup_affelio_AFE2 start.");

	my %param = @_;
	
	#fs_userdata_dir: where .db or .cfg will be saved.
	my $fs_userdata_dir = $param{fs_userdata_dir};

	#fs_tmpldyn_dir: where dynamic template will be saved.
	my $fs_tmpldyn_dir = $param{fs_tmpldyn_dir};

	#fs_affelio_dir: path to affelio_core package
	my $fs_affelio_dir = $param{fs_affelio_dir};

	#fs_farm_dir: path to ***Farm dir
	my $fs_farm_dir = $param{fs_farm_dir};

	#user_afid: New user's afid (Affelio URL)
	my $user_afid = $param{user_afid};

	#locale: Locale
	my $locale = $param{locale};

	#lh: locale handler
	my $lh = $param{lh};

	#db_type: 
	my $db_type = $param{db_type};
	my $db_dbname = $param{db_dbname};
	my $db_username = $param{db_username};
	my $db_password = $param{db_password};
	my $db_hostname = $param{db_hostname};
	my $db_port = $param{db_port};

	#account info...
	my $username = $param{username};
	my $password = $param{password};
	my $password_remoteop = $param{password_remoteop};
	my $nickname =$param{nickname};
	my $email =$param{email};

	#############################################################
	debug_print("\t$fs_userdata_dir ");
	debug_print("\t$fs_tmpldyn_dir "); 
	debug_print("\t$fs_affelio_dir"); 
	debug_print("\t$fs_farm_dir"); 
	debug_print("\t$user_afid");  
	debug_print("\t$locale");
	debug_print("\t$lh ");
	debug_print("\t$db_type ");
	debug_print("\t$db_dbname ");
	debug_print("\t$db_username ");
	debug_print("\t$db_password ");
	debug_print("\t$db_hostname ");
	debug_print("\t$db_port ");
	debug_print("\t$username ");
	debug_print("\t$password "); 
	debug_print("\t$nickname ");
	debug_print("\t$email ");

	#############################################################
	$ENV{'REDIRECT_AF_USERNAME'} = $username;

	################################
	#(1)create db.cfg
	create_db_cfg("$fs_userdata_dir/db.cfg",
		      $db_type,
		      $db_dbname,
		      $db_username,
		      $db_password,
		      $db_hostname,
		      $db_port);
	debug_print("InitAffelio:setup_AFE2 (1) create db.cfg done");

	################################
	#(2)create login.cfg
	my @salts = ( "A".."Z", "a".."z", "0".."9", ".", "/" );
	my $salt = $salts[int(rand(64))] . $salts[int(rand(64))];
	my $crypted_password = crypt($password, $salt);
	create_login_cfg("$fs_userdata_dir/login.cfg",
			 $username,
			 $crypted_password);
	debug_print("InitAffelio:setup_AFE2 (2) create login.cfg [$crypted_password] done.");

	################################
	#(3)Copy default files
	copy_def_files($fs_farm_dir , $fs_userdata_dir, 
		       $locale, $password_remoteop);
	debug_print("InitAffelio:setup_AFE2 (3) copy default files. done.");

	################################
	#(4)create resized images
	create_resized_images($fs_affelio_dir, $fs_userdata_dir);

	################################
	#(5)initialize DB
	init_db($fs_affelio_dir , $nickname, $email, $lh);
	debug_print("InitAffelio:setup_AFE2 (5) Init DB done.");

	################################
	#(6)Rebuild template
	my $af;
	$af = new Affelio(ConfigDir => "$fs_affelio_dir/config/");
	Affelio::App::Standalone::Admin::EditTemplates::rebuild($af);
	debug_print("InitAffelio:setup_AFE2 (6) Rebuild template done.");

	debug_print("InitAffelio:setup_AFE2  ****ALL DONE****");
    }

}
1;
