# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: ja.pm,v 1.40 2006/03/07 14:39:11 slash5234 Exp $

package Affelio::misc::L10N::ja;
{
    use strict;
    use lib("../../../../extlib");
    use lib("../../../../lib");
    use Affelio::misc::L10N;
    use Affelio::misc::L10N::en_us;
    #
    use vars qw(@ISA %Lexicon);

    sub encoding { "UTF-8" }

    @ISA = qw(Affelio::misc::L10N::en_us);

    %Lexicon = (
		##########################################################
		#System
		##########################################################
		'_SYS_ENCODING_DUMMY' =>'あうほげほげ',
		'_SYS_attr_opened' =>'０',
		'_SYS_attr_closed' =>'Ｘ',
		'Yes' => 'はい',
		'No' => 'いいえ',

		##########################################################
		#Setup wizard
		##########################################################
		'Affelio Setup Wizard' => 'Affelio セットアップウィザード',
		'Next' => 'すすむ',
		#
		'_SETUP_title_10' => 'Affelioのセットアップへようこそ!',
		'_SETUP_msg_10' => 'Affelioのセットアップへようこそ! Affelioのセットアップは、ウィザード形式で画面の指示にしたがって進むだけで、簡単にできるようになっています。<P><B>このセットアップウィザードは<FONT COLOR="red">Affelioの新規インストール専用です</FONT>。この場所にすでにAffelioがインストールされている場合、このセットアップウィザードを使ってセットアップすると、<FONT COLOR="red"><B>以前のユーザデータは引き継がれません。</B></FONT>以前のバージョンからのアップグレードには、このウィザードを使わないでください。別途、このバージョンのリリースノートなどを参照してください。</B><P>"すすむ"ボタンを押して、次へ進んでください。',
		#
		'_SETUP_title_30' => 'GPLバージョンのご利用について',
		'_SETUP_msg_30' => '<B><FONT COLOR="red">ご注意!!</FONT></B>&nbsp;&nbsp;このAffelioは、<B>GNU <A HREF="http://www.opensource.jp/gpl/gpl.ja.html" target="_blank">General Public License (GPL)</A> 2.0</B> でライセンスされるバージョンです。お客様が、セットアップウィザードをこれより先に進んでこのAffelioをインストールされる場合、このライセンスに同意されたものとします。<B>同意される場合のみ、ボタンを押して次へ進んでください。</B><P><HR><P>無保証について (<A HREF="http://www.opensource.jp/gpl/gpl.ja.html">GPL2.0日本語訳</A>より)<BR>『プログラム』は代価無しに利用が許可されるので、適切な法が認める限りにおいて、『プログラム』に関するいかなる保証も存在しない。書面で別に述べる場合を除いて、著作権者、またはその他の団体は、『プログラム』を、表明されたか言外にかは問わず、商業的適性を保証するほのめかしやある特定の目的への適合性(に限られない)を含む一切の保証無しに「あるがまま」で提供する。『プログラム』の質と性能に関するリスクのすべてはあなたに帰属する。『プログラム』に欠陥があると判明した場合、あなたは必要な保守点検や補修、修正に要するコストのすべてを引き受けることになる。<P>免責について (<A HREF="http://www.opensource.jp/gpl/gpl.ja.html">GPL2.0日本語訳</A>より)<BR>適切な法か書面での同意によって命ぜられない限り、著作権者、または上記で許可されている通りに『プログラム』を改変または再頒布したその他の団体は、あなたに対して『プログラム』の利用ないし利用不能で生じた通常損害や特別損害、偶発損害、間接損害(データの消失や不正確な処理、あなたか第三者が被った損失、あるいは『プログラム』が他のソフトウェアと一緒に動作しないという不具合などを含むがそれらに限らない)に一切の責任を負わない。そのような損害が生ずる可能性について彼らが忠告されていたとしても同様である。 <P><HR><P>Affelioは、GPLとAffelioコマーシャルライセンスのデュアルライセンスとなっております。派生物のソースコードを公開されたくない場合 (商用サービスへの利用など) は、GPLバージョンでなくコマーシャルライセンスバージョンをご利用頂くのが有効です。詳しくは<A HREF="http://affelio.jp/modules/tinyd5/" target="_blank">【Affelioのライセンス】</A> (http://affelio.jp) をご覧下さい。ライセンスや価格に関して、詳しくは <A HREF="mailto:license@affelio.jp">license@affelio.jp</A> までお問い合わせ下さい',
		'Accept' => '承諾',

		#
		'_SETUP_title_50' => '必要なPerlモジュールのチェック',
		'_SETUP_msg_50_1' => '以下は、Affelioのインストールに必要なPerlモジュールのリストです。何か<FONT COLOR="red">インストールされていない</FONT>モジュールがある場合は、次に進む前にインストールしてください。<P>',
		'_SETUP_msg_50_2' => 'すべてインストールされていたら、次へ進んでください。',
		'_SETUP_msg_50_3' => '</blockquote>また、データベース用モジュールとして<B>以下のどちらか1つのモジュール</B>が必要です。使用したいデータベース用のモジュールが<FONT COLOR="red">インストールされていない</FONT>場合は、次に進む前にインストールしてください。<blockquote>',
		'_SETUP_check_50_err1' => 'インストールされていないモジュールがあります',
		#

		'_SETUP_title_100' => '設定ファイルの作成',
		'_SETUP_msg_100' => '以下のそれぞれディレクトリに関して、パーミッションを 777 や 700 など、CGIが書き込める</B> に設定してください。<UL><LI>config/<LI>userdata/<LI>session/<LI>skins/<LI>templates_dyn/</UL>',
		'_SETUP_check_100_err1' => '<LI>affelio.cfgがありません。<BR>setup.cgiと同じディレクトリ内に、affelio.cfgという名前の空ファイルを、読み書き可能なpermissionで作成してください。',
		'_SETUP_check_100_err2' => '<LI>CGIからaffelio.cfgの内容を読み込めません。<BR>読み書き可能なパーミッションに設定してください。',
		'_SETUP_check_100_err3' => '<LI>CGIからaffelio.cfgへ書き込めません。<BR>読み書き可能なパーミッションに設定してください。',
		'_SETUP_check_100_err4' => '<LI>[_1] が書き込み可能になっていません。パーミッション設定を行ってください。',
		'_SETUP_check_100_err5' => '<LI>[_1] が読み込み可能になっていません。パーミッション設定を行ってください。',

		#
		'_SETUP_title_200' => '外部プログラムの検出',
		'_SETUP_msg_200' => '<P>sendmailコマンドの場所(PATH)を、ウィザードは以下のように検出しました。（検出できなかった場合は空欄になっています。）これで良い場合はそのまま「すすむ」ボタンを押してください。</P><P>空欄の場合は、各コマンドの場所を自分で入力してください。場所が分からない場合は、Webサーバーの管理者に問い合わせて下さい。</P>',
		'_SETUP_check_200_err1' => '[_1] にsendmailが検出できません!',
		#
		'_SETUP_title_350' => 'データベースの選択',
		'_SETUP_msg_350' => 
		'<P>使用するデータベースを選んでください。(使用するにはそれぞれのDBDモジュールがインストールされている必要があります)</p>'
		. '<P><INPUT TYPE="radio" NAME="dbtype" VALUE="mysql">MySQL'
		. '<UL><TABLE BORDER=0>'
		. '<TR><TD>DB名: </TD><TD><INPUT TYPE="text" NAME="mysql_dbname"></TD></TR>'
		. '<TR><TD>DBユーザ名: </TD><TD><INPUT TYPE="text" NAME="mysql_username"></TD></TR>'
		. '<TR><TD>パスワード: </TD><TD><INPUT TYPE="text" NAME="mysql_password"></TD></TR>'
		. '<TR><TD>DBホスト名: </TD><TD><INPUT TYPE="text" NAME="mysql_hostname">(オプション)</TD></TR>'
		. '<TR><TD>ポート番号: </TD><TD><INPUT TYPE="text" NAME="mysql_port">(オプション)</TD></TR>'
		. '</TABLE></UL>'
		. '<P><INPUT TYPE="radio" NAME="dbtype" VALUE="sqlite" checked>SQLite',
		#
		'_SETUP_title_400' => 'サイトオーナーとしてのログイン情報',
		'_SETUP_msg_400' => 
		'<P>このAffelioサイトのオーナーとしてログインするために必要なユーザー名とパスワードを決めて、入力して下さい。また連絡用のメールアドレスを入力して下さい。</P><P>また、Affelioネットワーク上で公開されるあなたのニックネームを決めて、入力して下さい。</p>'
		. '<P><TABLE BORDR="0"><TR><TD VALIGN="top">ログインユーザ名：</TD>'
		. '<TD><INPUT TYPE="text" NAME="username" SIZE="30" VALUE=""><BR><font size="-2">(英数字)</font></TD></TR>'
		. '<TR><TD VALIGN="top">パスワード：</TD>'
		. '<TD><INPUT TYPE="text" NAME="password" SIZE="30" VALUE=""><BR><font size="-2">(英数字)</font></TD></TR>'
		. '<BR><TR><TD>連絡用メールアドレス：</TD>'
		. '<TD><INPUT TYPE="text" NAME="email" SIZE="30" VALUE=""><BR><font size="-2">(英数字)</font></TD></TR>'
		. '<TR><TD HIGHT="20">　</TD><TD> </TD></TR>'
		. '<TR><TD VALIGN="top">公開ニックネーム：</TD>'
		. '<TD><INPUT TYPE="text" NAME="nickname" SIZE="30" VALUE=""  onBlur="checkNickname2(this)"><BR><font size="-2">(英数字)</font></TD></TR>'
		. '</TABLE>', 
		#
		'_SETUP_title_500' => 'Congrat! セットアップ完了です！',
		'_SETUP_msg_500' => '<P>Congratulations! セットアップを完了しました。</P><P><FONT COLOR="red"><B>このsetup.cgiと、upgrade-*.cgiはもう不要であり、セキュリティ上の問題にもなりますので、Webサーバー上から削除してください。</B></FONT> </P><P>次に、<A HREF="[_1]">[_1]</A>からご自分のAffelioサイトにログインし、プロファイルを設定して下さい。</P>',
		#
		'_SETUP_group_dear_friend' => 'グループA',
		#
		'_SETUP_err_module_notfound' => '[_1]　　<FONT COLOR="red"><B>インストールされていない!</B></FONT><BR>',
		'_SETUP_module_found' => '[_1]　　OK. インストールされています. ([_2])<BR>',

		##########################################################
		#Friend class
		##########################################################
		'_VISITOR_TYPE_PB' => '一般ゲスト',
		'_VISITOR_TYPE_F2' => 'Affelioリンクのリンク',
		'_VISITOR_TYPE_F1' => 'Affelioリンク',
		'_VISITOR_TYPE_SELF' => 'サイトオーナー',
		'anonymous' => '名無し',

		##########################################################
		#Access_log
		##########################################################
		'Date/Time' => 'アクセス時刻',
		'User Type' => 'ユーザタイプ',

		##########################################################
		#Profile
		##########################################################
		'Nickname' => 'ニックネーム',
		'Last' => '名字',
		'Given' => '名前',
		'Middle' => 'ミドル',
		'Birthday' => '誕生日',
		'Picture' => '写真',
		'Introduction 1' => 'パブリック自己紹介',
		'Introduction 2' => '詳しい自己紹介',
		'Greeting' => '一言ステータス',
		'URL 1' => 'Webページ(1)',
		'URL 2' => 'Webページ(2)',
		'URL 3' => 'Webページ(3)',
		'IM 1' => 'IMアドレス(1)',
		'IM 2' => 'IMアドレス(2)',
		'IM 3' => 'IMアドレス(3)',

		'New Group' => '新規作成',
		'Name here!' => 'グループ名入力',
		'Save changes' => '変更を保存する',
		'Save' => '保存',

		##########################################################
		#System information
		##########################################################
		"Please login." => 'ログインしてください。',
		"reason" => '理由',
		"login" => 'ログイン',
		'Login failed.' => 'ログインに失敗しました。',
		"We'll be back to the front page after 1 sec." => "1秒後にフロントページに戻ります。",
		"You can use only alphabets, numbers, and _ for your nickname." => "ニックネームに使えるのは、半角英数字と _ のみです。",
		'http://www.affelio.info' => 'http://www.affelio.jp',

		###########################################################
		#Login_s1 dialog
		###########################################################
		'_LOGIN_S1_MESG1' => '[_1]さんお帰りなさい!! この画面は、あなた自身のAffelioが表示しているものです。',
		'_LOGIN_S1_MESG2' => 'Affelioリンクのページにログインするために、一度あなた自身のAffelioサイトへと戻ってきています。',
		'_LOGIN_S1_MESG3' => '自分のAffelioサイトへログインするためのパスワードを入力してください。認証が終わると、その後Affelioリンクへの自動的にログインが完了します!',
		'_LOGIN_S1_MESG4' => '[_1]さんお帰りなさい!!<P>オーナーとしてログインしますので、パスワードを入力してください。',

		###########################################################
		#ask_makefriend dialog
		###########################################################
		'_ASK_MAKEFRIEND_MESG1', => '[_1]さんお帰りなさい!! ログイン完了です。',
		'_ASK_MAKEFRIEND_MESG2', => 'しかし、あなたが今訪れていたAffelioサイト<BR>[_1]<BR>は、あなたのAffelioからリンクが貼られていません。従ってAffelioリンクとしてログインすることもできません。今からリンクの申請を送りますか？',

		'_ASK_MAKEFRIEND_MESG3', => '今からリンク申請を送ります。(リンク申請画面に移動します',
		'_ASK_MAKEFRIEND_MESG4', => '今訪れていたAffelioにすぐ戻ります。(Affelioリンクとしてログインはされません)',

		###########################################################
		#Handshake
		###########################################################
		'Link request has been sent out!' => 'リンクの依頼を先方に送りました！',
		'Destination' => '宛先',

		'Go back to the owner page' => 'オーナーページへもどる', 

		'Link acceptance has been sent back to the requester.' => 'リンクの承諾を、先方へ送り返しました!',

		'Requester' => 'Affelioリンクの申請を送ってきた人',
		'detail' => "詳しい説明",

		'_HandshakeReply_SentBack_MESG1' => '続けて、[_1]さんにご挨拶のメールを書きましょう。' ,
		'_HandshakeReply_SentBack_MESG2' => '<A HREF="[_1]">ここ</A>を押すか、5秒すると自動的にメッセージ作成の画面に移動します。',
		'_HandshakeReply_SentBack_message_title' => 'リンクありがとうございます。',

		##########################################################
		#owner pages
		##########################################################
		#Top
		'WelcomeToOwnerTop' => '[_1]さんのマイページ',
		'_ADMIN_TOP_EXP' => 'このページはAffelioの「マイページ」のトップです。このAffelioのオーナーであるあなただけがアクセスできるページです。<P>画面左側に表示されているメニューから、このAffelioサイトやあなたのプロフィールの各種編集ができます。',
		'_ADMIN_TOP_MYSTATUS' => '今日のひとことステータス',
		'_ADMIN_TOP_MYSTATUS_EXP' => 'ひとこと、最近の自分についてのコメントを書いておきましょう。Affelioリンクで繋がっているサイトはあなたの写真の上にステータスを見ることができます。',
		'_ADMIN_TOP_SEND_LINK_EXP' => '他のAffelioサイトへ【Affelioリンク】を申請する',
		'_ADMIN_TOP_SEND_LINK_EXP2' => 'リンクを申請する相手のAffelio URL',
		'_ADMIN_TOP_SEND_LINK_EXP3' => 'リンク申請を送る',
		'_ADMIN_TOP_SEND_LINK_EXP4' => '相手へのメッセージ：&nbsp;あいさつや自己紹介など。失礼のないようにしましょう。',
		'_ADMIN_TOP_SEND_INVITATION_EXP'  => '友達に招待メールを送る',
		'_ADMIN_TOP_SEND_INVITATION_EXP2' => 'メールを送る相手のメールアドレス',
		'_ADMIN_TOP_SEND_INVITATION_EXP3' => 'メールをおくる',
		'_ADMIN_MAKE_FRIEND_EXP' => '他のAffelioサイトへAffelioリンクを申請しましょう。申請先の承認があり次第、Affelioリンクが繋がります。',
		'News from My Friends' => 'Affelioリンクからのニュース',
		'News from Affelio' => 'Affelioプロジェクトからのお知らせ',


		########################
		#Menu
		'Go to Guest Pages' => 'ゲストページへ',
		'Owner Page: Top' => 'マイページトップ',

		'Make a friend' => 'Affelioリンクを作る',
		'Affelio Options' => 'Affelioの設定',
		'Application Options' => 'アプリの設定',
		'Logout' => 'ログアウト',
		'Password' => 'パスワード',

		########################
		"Access Control (core)" => "アクセス制御 (コア)",

		"_ADMIN_ACCESS_CONTROL_EXP" => "ここでは、あなたの「Affelioリンク」、「Affelioリンクのリンク」、「それ以外のサイト」が、あなたのAffelioサイトのどの情報にアクセスできるのかを設定できます。",
		"_ADMIN_ACCESS_CONTROL_DETAIL_EXP" => '<div class="afPubContentBlock"><div class="afPubContentBlockTitle">"Affelioリンク"、"Affelioリンクのリンク"、"それ以外の人"とは？</div><UL><LI><b>Affelioリンク</b><BR>あなたのAffelioサイトとAffelioリンクが張られたことを言います。<P><img src="./images/friends.png"><LI><b>Affelioリンクのリンク</b><BR>Affelioリンクで繋がったサイトからさらにAffelioリンクを張ったサイトです。<P><img src="./images/friendsoffriends.png"><LI><b>それ以外のサイト</b><BR>上の2つのどちらにも当てはまらないサイトです。</UL></div><div class="afPubContentBlock"><div class="afPubContentBlockTitle">"「グループの設定」とは？</div><UL>あなたが直接Affelioリンクを張った「Affelioサイト」を、さらにグループを使って細かくアクセス制御できます。例えばある<strong>Affelioリンク</strong>を<strong>グループA</strong>に入れた場合、Affelioリンク先には「Affleioリンク」、「グループA」<strong>どちらか1つ以上において</strong>公開設定された情報が、<strong>すべて<strong>公開されます。</UL></div>',
		########################
		'Edit Skins' => 'デザインスキンの編集',
		'Skin Configuration for guest pages' => 'Guestページ用デザインスキンの編集',
		'Select skin' => 'スキンの選択',
		'Choose' => '選択する',
		'Customize the currently selected skin' => '現在選択中のスキンのCSSをカスタマイズ',
		'File name' => 'ファイル名',
		'Browse files of the currently-selected skin' => '現在選択中のスキンの関連ファイルをブラウズ',
		'Back up skin' => 'スキンのバックアップ',
		'Which skin' => 'スキンを選択',
		'with what skin name' => 'バックアップ時の別名 (例: MySkin)',
		'optional' => 'オプション',
		'Download' => 'ダウンロード',
		'Upload skin' => 'スキンのアップロード',
		'Upload' => 'アップロード',
		'Which file' => 'ファイルを選択',
'You can edit the CSS in the following text area, only if permission of the skin file above is writable.' => 'Webサーバ上で上記CSSファイルが「書き込み可能」にパーミッション設定されている場合に限り、下のテキストエリアで直接編集、保存できます。',
		"Style-sheet Template" => '【スタイルシート・テンプレート】',
		"_ADMIN_EDIT_SKINS_EXP" => 'ここでは、Publicページ用のデザインスキンに関する設定ができます。<P><UL><LI>インストールされているスキンを選択できます。<LI>現在選択中のスキンをカスタマイズできます。<LI>スキンをZIPファイルとしてバックアップできます。<LI>スキンのZIPファイルをアップロードして、インストールできます。</UL>',
		"_ADMIN_EDIT_SKINS_BACKUP_EXP" => 'ここでは、サーバー上のスキンをZIP形式のスキンパッケージとしてバックアップ (ダウンロード) できます。<OL><LI>まず、バックアップするスキンを選んでください。<LI>もし名前をつけて(違う名前のスキンとして)バックアップしたい場合は、名前を入力してください。<LI>ダウンロードボタンを押してください。</OL>',
		"_ADMIN_EDIT_SKINS_UPLOAD_EXP" => 'ここでは、ZIP形式のスキンパッケージをサーバーへアップロードできます。アップロードされたスキンは以降選択できるようになります。<OL><LI>まず、アップロードするスキンを選んでください。<LI>アップロードボタンを押してください。</OL>.zipファイルをアップロードするとスキンパッケージとして認識されます。.gif, .jpg, .jpeg, .pngファイルをアップロードすると、現在選択しているスキンのディレクトリにアップロードされます。',

		########################
		'Application Configuration' => 'アプリの設定',
		'_ADMIN_APPS_CONFIG_EXP1' =>'AffelioにインストールするAffelioアプリについて設定を行います。上段には現在インストールされ利用可能なアプリケーション一覧が表示されます。下段には、これからインストール可能なアプリケーション一覧が表示され、インストール作業を行えます。',
		'_ADMIN_APPS_CONFIG_EXP2' =>'apps/ ディレクトリ以下にファイルは設置されているものの、あなたのAffelioサイトへのインストール操作が終了していないアプリケーションです。ボタンを押してインストールをすることで利用できるようになります。',
		'_ADMIN_APPS_CONFIG_EXP3' =>'現在Affelioにインストールされているアプリケーションです。',
		'_ADMIN_APPS_CONFIG_EXP4' =>'exp1',
		'_ADMIN_APPS_CONFIG_APPDIR' =>'ディレクトリ',
		'_ADMIN_APPS_CONFIG_APPNAME' =>'アプリ名',
		'_ADMIN_APPS_CONFIG_APPVER' =>'バージョン',
		'_ADMIN_APPS_CONFIG_OP' =>'操作',
		'_ADMIN_APPS_CONFIG_INSTALLNAME' =>'ディレクトリ',
		'_ADMIN_APPS_CONFIG_INSTALLTITLE' =>'インストール名',

		'Applications to be registered' => 'インストール可能なアプリケーション',
		'Applications currently registered' => '現在インストールされているアプリケーション',

		'install' => 'インストール',
		'change' => '変更',
		'uninstall' => '削除',

		########################
		'Affelio Configuration' => 'Affelioの設定',
		'Change login password' => 'ログインパスワードの変更',
		'Public top page' => 'ゲストページのトップを変更',
		'_ADMIN_SYSCONFIG_PASSWORD' => 'ログインするためのパスワードを変更します。',
		'Current password' => '現在のパスワード',
		'New password' => '新しいパスワード',
		'again' => 'もう一度',

		'Email Notification' => 'メールでの通知',

		'_ADMIN_AFFELIO_CONFIG_EXP' =>'このページでは、Affelioの動作に関するさまざまな設定をすることができます。',

		'_ADMIN_SYSCONFIG_TOPPAGE_EXP' => '<A HREF="[_1]" target="_blank">[_1]</A>にアクセスされた時に表示するページを設定します。',

		'_ADMIN_SYSCONFIG_NOTIFICATION_EXP' => 'メッセージが届いたらオーナーにEメールで通知するかどうかを設定します。',

		'_ADMIN_SYSCONFIG_HOSTING_EXP' => 'Affelioを新しく他の人に紹介する場合、あなたが推薦するAffelioホスティングサービスのURLを設定します。<BR>(Coming Soon!)',
		'Password for Affelio remote operation' => 'Affelioリモートオペレーションのためのパスワード',
		'_ADMIN_SYSCONFIG_REMOTE_OP_PASS' => 'Affelioを他のAffelioやAffelioファームからリモート操作する場合に必要なパスワードを設定します。このパスワードはWSSE認証に使われます。',

		########################
		'Edit Templates' => 'テンプレートの編集',
		'Template Configuration for guest pages' => 'Guestページ用テンプレートの編集',
		"_ADMIN_EDIT_TEMPLATES_EXP" => 'ここでは、Publicページ用の各種テンプレートを編集します。<P>テンプレートは大きく以下の2種類に分かれます。<UL><LI>Header・Footer・Right・Leftテンプレート<UL>下の図の様に、Affelio画面の上下左右の「枠」部分です。この枠はAffelioコアだけでなく、Affelioアプリにおいても表示されます。例えば画面一番上のバナー画像を変えたいときは、Headerテンプレートを編集し、保存してください。</UL><LI>ボディ・テンプレート<UL>ボディ・テンプレートは、Affelioコアのページの中身です。現在、index、flist、profileの3つがあります。Affelioコアのパブリックモードの画面を改造したい場合は、各テンプレートを編集して保存してください。</UL></UL>',

		"Rebuild all templates" => 'すべてのテンプレートを再構築する',
		"Save and rebuild" => '保存し再構築する',

		"Header Template" => '【header テンプレート】',
		"Left Template" => '【Left テンプレート】',
		"Right Template" => '【Right テンプレート】',
		"Footer Template" => '【Footer テンプレート】',
		"Body Template: 1.Index page" => '【Body テンプレート (1)インデックス】',
		"Body Template: 2.Friend list" => '【Body テンプレート (2)Affelioリンク一覧】',
		"Body Template: 3.Profile page" => '【Body テンプレート (3)プロフィール】',

		########################
		"Edit Profile" => "プロフィールの編集",
		"_ADMIN_EDIT_PROFILE_EXP" => 'Affelioネットワーク上でのプロフィールを編集できます。名前や生年月日を入力したり、あなたの写真をアップロードしましょう。<P><B><font color="red">ここで入力したプロフィールは、公に公開される訳ではありません。アクセスコントロール機能を使って、あなたが設定した人だけに公開できます。</font></B>',
		'Name on the Affelio network' => '【Affelioネット上の名前】',
		'Your basic information' => '基本情報',
		'Your contact on the net' => 'ネット連絡先',
		"_ADMIN_EDIT_PROFILE_EXP2" => '「説明」の項目には、「プライベートアドレス」「仕事」「ブログ」「MSN」・・・といった説明を書くと便利でしょう。:)',
		"Description" => '説明',

		"_ADMIN_EDIT_PROFILE_EXP3" => '<B><FONT color="red">注意!!</font>: これはだれもが見ることができる自己紹介文です。</B>アクセス制御はできません。<BR>誰からでも見られてよい内容だけを載せましょう。',
		"_ADMIN_EDIT_PROFILE_EXP4" => '<B>必要に応じてアクセス制限がかけられる自己紹介文です。</B><BR>たとえば「直接の直接のAffelioリンクだけに見せたい自己紹介メッセージ」は、ここに書きましょう。',

		########################
		"Friend Graph" => '友達関係図',
		'_ADMIN_FRIEND_GRAPH_EXP' => 'あなたの友人関係をグラフで表示します。Javaを使ったテストバージョンです。<P>注意：このグラフは必ずしも最新の友達状態を表すものではありません。ページ下の「リスト更新」ボタンを押すと、最新情報へアップデートする通信を友達と行います。',
		'Retrieve the latest information' => '最新の友だち関係図に更新する',

		########################
		"Group Friends" => 'Affelioリンクのグルーピング',
		'_ADMIN_GROUP_FRIENDS_EXP' => '<BR>ここでは、どのAffelioリンクをどのグループに入れるか設定できます。',

		########################
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP' => '紹介するコメントを以下のテキストボックスに書きましょう。 書いたコメントは、あなたのAffelioトップページのAffelioリンク一覧に表示されます。',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP1' => '[_1]さんに対して公開されている情報',
		'Summary' => 'サマリー',
		'As a friend' => 'Affelioリンクとして',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP2' => '[_1]メンバーとして',
		'Unregister' => 'はずす',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP3' => 'このグループからはずします',
		'_ADMIN_MANAGE_FRIEND_SHOW_MEMBER_EXP4' => '【他のグループのメンバーにする】',
		'Add' => '追加',

		########################
		'Upload Pictures' => '写真のアップロード',
		'_ADMIN_UPLOAD_PICTURES_EXP' => 'Affelioサイトに公開する写真のアップロードができます。<BR><BR>拡張子が .jpg か .jpeg のJPEGファイルをアップロードしてください。現在最適サイズは150x150ドットです。<BR><BR><strong>アップロードボタンを押してから次のページに切り替わるまでに時間がかかる場合があります。</strong>',

		'Your current picture' => '現在設定されている写真',
		'Choose a picture to upload' => 'アップロードするファイルを指定してください。',
		'Upload' => 'アップロード',

		########################
		'Access Log' => '足あと',
		'_ADMIN_ACCESS_LOG_EXP' => 'ここでは、誰があなたのAffelioを訪れたかの記録（足あと）をチェックすることができます。<P>"Global"番号は、Affelioユーザや全く一般のゲストも全部含んだアクセス番号です。<BR>"Affelio"番号は、全体アクセスのうち、Affelioユーザからのアクセスのみをカウントしたものです。<P>足あとを残したAffelioユーザのニックネームをクリックすると、その人のAffelioに飛びます。またAffelioユーザでないアクセスでは、アクセス元ホスト名が表示されます。',
		'Friends' => '1ホップ',
		'Friends of friends' => '2ホップ',
		'Public' => '非Affelioアクセス',
		'All' => 'すべて',

		########################		
		'Referrer Log' => 'アクセスもと',

		########################
		'Affelio Messaging' => 'Affelioメッセージング',
		'Messages' => 'メッセージ',
		'_ADM_MSG_FROM' => '発信者',
		'_ADM_MSG_TO' => '宛先',
		'_ADM_MSG_TITLE' => 'タイトル',
		'_ADM_MSG_DATE' => '日時',
		'_ADM_MSG_BODY' => '本文',

		'Config' => '設定', 
		'Compose' => '新規作成', 
		'Go back to the list' => '一覧へもどる',

		'_ADM_MSG_EXP' => 'ここには、Affelioを通してあなたに届いたメッセージが表示されます。<P>Affelioリンクで繋がったサイトは、Affelioメッセージングの仕組みを使ってメッセージをやり取りできます。<P>また、あなたのAffelioサイト（システム）からのお知らせやシステム状態の通知のメッセージも、すべてここに届きます。',

		########################
		'Manage Friends' => 'Affelioリンクの編集',
		'_ADMIN_MANAGE_FRIEND_TOP_EXP1' => 'ここでは、AffelioリンクでつながったAffelioサイトを編集できます。<BR><BR>・Affelioリンクを紹介するコメントを書きましょう。<BR>・各Affelioリンクへ公開されているオーナーの情報をチェックしてください。<BR>・Affelioリンクをグループに追加するかグループから削除して、公開する情報を調節できます。',
		'_ADMIN_MANAGE_FRIEND_TOP_EXP2' => '【[_1]のAffelioリンク一覧】',

		########################
		"Access Control (apps)" => "アクセス制御 (アプリ)",
		'Manage Applications' => 'アプリケーションの設定',
		'_ADMIN_MANAGE_APP_TOP_EXP' => '',
		'_ADMIN_MANAGE_APP_TOP_EXP1' => 'ここでは、各アプリに対するアクセスコントロールを設定できます。<P>各アプリケーションの「タイトル」をクリックしてください。別ウィンドウが表示され、そのアプリケーションへの設定ができます。',
		'_ADMIN_MANAGE_APP_TOP_EXP2' => '現在インストールされているアプリケーション一覧',
		'DF_visibility' => 'アプリケーション・ドックへの表示',
		'DF_access' => 'アプリへの基本アクセス',

		########################
		'Manage Groups' => 'グループの編集',
		'_ADMIN_MANAGE_GROUP_TOP_EXP1' => '【グループ一覧】',
		'Rename' => 'リネーム',
		'Edit members' => 'メンバー編集',
		'Edit access control' => 'アクセス制御の編集',
		'Delete' => '削除',
		'_ADMIN_MANAGE_GROUP_TOP_EXP2' => '新しく追加するグループ名を入力して、ボタンを押してください。',
		'_ADMIN_MANAGE_GROUP_TOP_EXP3' => 'グループ名を入力',

		##########################################################
		'Link request has been sent out!' => 'リンク申請を送りました!',
		'Destination' => '宛先Affelio: ',
		'Go back to the owner page' => 'オーナページへ戻る',

		##########################################################
		'_SYS_WARN_OUTGOING_PRIV_IP' => 'ご注意:<BR>現在、あなたはプライベートIPである[_1]からアクセスしています。この場合、宛先Affelioへのセッション転送がうまくできない場合がありますので、ご了承ください。',
		'_SYS_WARN_OUTGOING_PRIV_IP2' => 'をクリックすると、宛先Affelioへ向かいます。:)',

		##########################################################
		#Handshaker mail 
		##########################################################
		'_HANDSHAKE_REQUEST_MAIL_MESG1' => '<FONT SIZE="+1"><B>[_1]さんからAffelioリンクの申請が届きました！</B></FONT><BR><BR>',
		'_HANDSHAKE_REQUEST_MAIL_MESG2' => '<B>申請を送ってきた人：</B><BR>',
		'_HANDSHAKE_REQUEST_MAIL_MESG3' => '　　名前：[_1]さん<BR>',
		'_HANDSHAKE_REQUEST_MAIL_MESG4' => '　　Affelio：<A HREF="[_1]" target="_blank">[_1]</A><BR><BR>',
		'_HANDSHAKE_REQUEST_MAIL_MESG5' => '<B>メッセージ：</B><BR>[_1]<BR><BR>',
		'_HANDSHAKE_REQUEST_MAIL_MESG6' => '<B>Affelioリンクをつなげるには、あなたの承諾が必要です。<BR>承諾する場合は、<A HREF="[_1]">ここをクリックしてください!</A></B>',
		##########################################################
		'_AUTO' => 1,
		);
}
1;

