# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

# $Id: NetMisc.pm,v 1.5 2006/03/07 14:39:11 slash5234 Exp $

package Affelio::misc::NetMisc;
{
    use strict;
    use Exporter;
    @Affelio::misc::NetMisc::ISA = "Exporter";
    @Affelio::misc::NetMisc::EXPORT = qw (get_remote_domain get_remote_host URL2domain URL2path hostname2domain check_private_IP_addr);
    
    ########################################################################
    sub check_private_IP_addr{
	my $addr = shift;

	if($addr =~ /^192\.168\.([0-9]+)\.([0-9]+)/){
	    return(1);
	}
	if($addr =~ /^192\.0\.2\.([0-9]+)/){
	    return(1);
	}
	if($addr =~ /^10\.([0-9]+)\.([0-9]+)\.([0-9]+)/){
	    return(1);
	}
	if($addr =~ /^172\.16\.([0-9]+)\.([0-9]+)/){
	    return(1);
	}
	return(0);
    }

    ########################################################################
    sub get_remote_domain{
	my %env = shift;
	my $DomainName = !$ENV{'REMOTE_HOST'}||$ENV{'REMOTE_HOST'}eq$ENV{'REMOTE_ADDR'}?gethostbyaddr(pack('C4',split(/\./,$ENV{'REMOTE_ADDR'})),2)||$ENV{'REMOTE_ADDR'}:$ENV{'REMOTE_HOST'};
	$DomainName =~ s/^[\-+_0-9A-Za-z]+\.//;
	
	return $DomainName;
    }
    
    ########################################################################
    sub get_remote_host{
	my %env = shift;
	my $hostname = !$ENV{'REMOTE_HOST'}||$ENV{'REMOTE_HOST'}eq$ENV{'REMOTE_ADDR'}?gethostbyaddr(pack('C4',split(/\./,$ENV{'REMOTE_ADDR'})),2)||$ENV{'REMOTE_ADDR'}:$ENV{'REMOTE_HOST'};
	
	return $hostname;
    }
    
    ########################################################################
    sub hostname2domain{
	my $hostname = shift;
	my $domain="";
	my $host="";

	($host, $domain) = split(/\./, $hostname);
	print "$domain\n";

	
	if($ENV{'REMOTE_HOST'} eq ""){
	    $host = gethostbyaddr(pack("C4",split(/\./,$ENV{'REMOTE_ADDR'})),2);
	}else{
	    $host = $ENV{'REMOTE_HOST'};
	}
	
    }

    ########################################################################
    sub URL2domain{
	my $url = shift;
	
	#   $url="http://a.b.c.www-2.yahoo.com/cgi-bin/~a.cgi";
	#    $url="http://1.2.3.4/cgi-bin/~a.cgi";
	
	my $ret=$url;
	if($url =~ /http\:\/\/([0-9.]*)\//){
	    #IP address
	    $ret =~ s|http://([0-9.]+)/.*|$1|;
	}else{
	    #DNS hostname
	    $ret =~ s|http://([A-Za-z0-9.-]+)/.*|$1|;
	}
	
	return($ret);
    }

    
    ########################################################################
    sub URL2path{
	my $url = shift;
	$url =~ s|[a-zA-Z]+://[^/]*||;
	return($url);
    }
    
    
}#package
1;

sub a{
print URL2domain("http://www.a.com/"); print "\n";
print URL2domain("http://www.a.com/hogehoge"); print "\n";
print URL2domain("http://www.a.com/hogehoge/"); print "\n";
print URL2domain("http://www.a.com/hogehoge/aaa"); print "\n";
print URL2domain("http://www.a.com/hogehoge/aaa/"); print "\n";

print URL2path("http://www.a.com/"); print "\n";
print URL2path("http://www.a.com:8000/a/b/"); print "\n";
print URL2path("http://localhost:8000/a/b/"); print "\n";
print URL2path("http://www.a.com/hogehoge"); print "\n";
print URL2path("http://www.a.com/hogehoge/"); print "\n";
print URL2path("http://www.a.com/hogehoge/aaa"); print "\n";
print URL2path("http://www.a.com/hogehoge/aaa/"); print "\n";
}
