# Copyright (C) 2005 FishGrove Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# $Id: Util.pm,v 1.2 2006/03/07 14:39:11 slash5234 Exp $

package Affelio::misc::Util;
{
    use strict;
    use Exporter;
    @Affelio::misc::Util::ISA = "Exporter";
    @Affelio::misc::Util::EXPORT = qw (get_userdir);

    use lib("../../../extlib/");
    use Cwd;
    use Error qw(:try);
    use lib(".");
    use lib("../../../lib/");
    use Affelio::exception::SystemException;

    #####################################################################
    sub get_userdir{
	my $userdata_dir = shift;

	my $dir;
	my $ret="";
	try{
	    opendir(DIR, $userdata_dir);

	    while (defined($dir = readdir(DIR))) {
		if( ($dir ne '.') 
		    && ($dir ne '..') 
		    && ($dir ne 'default') 
		    && ($dir ne 'CVS')
		    && ($dir ne 'index.html')
		    && ($dir ne '.htaccess')   
		    ){
		    $ret = "$userdata_dir/$dir";
		}
	    }
	}catch Error with{
	    my $e=shift;
	    throw($e);
	};

	if($ret eq ""){
	    throw Affelio::exception::SystemException("userdata/* directory not found!");
	}else{
	    return($ret);
	}

    }

}
1;
