﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

using nispi.controlclass;
using nispi;

namespace nispi.Analysis
{
    class AnalysisMagicControls
    {
        public FormParts amFormParts;

        public CheckBoxParts oneLineCutCBoxParts;
        public CheckBoxParts twoLineCutCBoxParts;
        public CheckBoxParts threeLineCutCBoxParts;
        public CheckBoxParts fourLineCutCBoxParts;

        public CheckBoxParts kusaCutCBoxParts;
        public CheckBoxParts noAnchorCutCBoxParts;

        public ButtonParts updateButttonParts;
        public ButtonParts closeButtonParts;

        public AnalysisMagic analysisMagicView;


        AnalysisMagicControlsEvent analysisMagicControlsEvent;

        public AnalysisMagicControls(AnalysisMagic analysisMagicView)
        {
            this.analysisMagicView = analysisMagicView;

            amFormParts = FormPartsManager.Pop();
            amFormParts.Text = "カット機能";
            amFormParts.Name = "isPopUp";
            //amFormParts.Show();

            amFormParts.Size = new Size(300, 300);//Const.form.boardListTabControlParts.Size;

            //amFormParts.Location = new Point(System.Windows.Forms.Cursor.Position.X - (amFormParts.Size.Width),
            //    System.Windows.Forms.Cursor.Position.Y + 5);
            amFormParts.FormBorderStyle = FormBorderStyle.FixedToolWindow;
            amFormParts.Owner = Const.form.mainForm.GetControl();


            oneLineCutCBoxParts = CheckBoxPartsManager.Pop();
            twoLineCutCBoxParts = CheckBoxPartsManager.Pop();
            threeLineCutCBoxParts = CheckBoxPartsManager.Pop();
            fourLineCutCBoxParts = CheckBoxPartsManager.Pop();
            kusaCutCBoxParts = CheckBoxPartsManager.Pop();
            noAnchorCutCBoxParts = CheckBoxPartsManager.Pop();

            updateButttonParts = ButtonPartsManager.Pop();
            closeButtonParts = ButtonPartsManager.Pop();

            oneLineCutCBoxParts.Location = new Point(10, 10);
            oneLineCutCBoxParts.Size = new Size(250, 25);
            oneLineCutCBoxParts.Text = "１行以下のレスをカット";

            twoLineCutCBoxParts.Location = new Point(10, 40);
            twoLineCutCBoxParts.Size = new Size(250, 25);
            twoLineCutCBoxParts.Text = "２行以下のレスをカット";

            threeLineCutCBoxParts.Location = new Point(10, 70);
            threeLineCutCBoxParts.Size = new Size(250, 25);
            threeLineCutCBoxParts.Text = "３行以下のレスをカット";

            fourLineCutCBoxParts.Location = new Point(10, 100);
            fourLineCutCBoxParts.Size = new Size(250, 25);
            fourLineCutCBoxParts.Text = "４行以下のレスをカット";

            kusaCutCBoxParts.Location = new Point(10, 130);
            kusaCutCBoxParts.Size = new Size(250, 25);
            kusaCutCBoxParts.Text = "草(www)のあるレスをカット";

            noAnchorCutCBoxParts.Location = new Point(10, 160);
            noAnchorCutCBoxParts.Size = new Size(250, 25);
            noAnchorCutCBoxParts.Text = "アンカーの無いレスをカット";

            updateButttonParts.Location = new Point(10, amFormParts.Size.Height - 80);
            updateButttonParts.Size = new Size(80, 30);
            updateButttonParts.Text = "適用する";

            closeButtonParts.Location = new Point(100, amFormParts.Size.Height - 80);
            closeButtonParts.Size = new Size(80, 30);
            closeButtonParts.Text = "閉じる";

            amFormParts.AddControl(oneLineCutCBoxParts);
            amFormParts.AddControl(twoLineCutCBoxParts);
            amFormParts.AddControl(threeLineCutCBoxParts);
            amFormParts.AddControl(fourLineCutCBoxParts);
            amFormParts.AddControl(kusaCutCBoxParts);
            amFormParts.AddControl(noAnchorCutCBoxParts);
            amFormParts.AddControl(updateButttonParts);
            amFormParts.AddControl(closeButtonParts);

            analysisMagicControlsEvent = new AnalysisMagicControlsEvent(this.analysisMagicView, this);
        }

        public void RemoveControls()
        {
            //タブに登録されているコントロールを全削除            
            analysisMagicControlsEvent.RemoveEvent();

            amFormParts.RemoveAllCtrl();

            amFormParts.Name = "";

            amFormParts.Hide();

            //チェックをオフにする
            oneLineCutCBoxParts.Checked = false;;
            twoLineCutCBoxParts.Checked = false;;
            threeLineCutCBoxParts.Checked = false;;
            fourLineCutCBoxParts.Checked = false;;

            kusaCutCBoxParts.Checked = false;;
            noAnchorCutCBoxParts.Checked = false;;

            //コントロールを元に戻す
            FormPartsManager.Push(amFormParts);

            CheckBoxPartsManager.Push(oneLineCutCBoxParts);
            CheckBoxPartsManager.Push(twoLineCutCBoxParts);
            CheckBoxPartsManager.Push(threeLineCutCBoxParts);
            CheckBoxPartsManager.Push(fourLineCutCBoxParts);
            
            CheckBoxPartsManager.Push(kusaCutCBoxParts);
            CheckBoxPartsManager.Push(noAnchorCutCBoxParts);

            ButtonPartsManager.Push(updateButttonParts);
            ButtonPartsManager.Push(closeButtonParts);

            amFormParts = null;

            oneLineCutCBoxParts = null;
            twoLineCutCBoxParts = null;
            threeLineCutCBoxParts = null;
            fourLineCutCBoxParts = null;

            kusaCutCBoxParts = null;
            noAnchorCutCBoxParts = null;

            updateButttonParts = null;
            closeButtonParts = null;

            analysisMagicView = null;
        }
    }
}