﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Drawing;
using System.Diagnostics;

namespace nispi
{
    class FormShowStyle
    {
        public string NOW_TYPE;
        public string TYPE1 = "TYPE1";
        public string TYPE2 = "TYPE2";

        public FormShowStyle()
        {
            NOW_TYPE = "TYPE1";
        }

        public void ChangeToType1()
        {
            //設定をオフ
            if (NOW_TYPE.Equals(TYPE2) == true)
                OffType2();
            else
                return;

            ReSizeType1();

            Const.form.mainSplitContainerParts.AddToPanel1(Const.form.boardIndexTabControlParts);
            Const.form.subMainSplitContainerParts.AddToPanel1(Const.form.boardListTabControlParts);
            Const.form.subMainSplitContainerParts.AddToPanel2(Const.form.threadListTabControlParts);
            Const.form.mainSplitContainerParts.AddToPanel2(Const.form.subMainSplitContainerParts);

            Const.form.mainForm.AddControl(Const.form.mainSplitContainerParts);

            Const.form.mainSplitContainerParts.Show();
            Const.form.subMainSplitContainerParts.Show();

            Const.form.mainForm.Update();

            NOW_TYPE = TYPE1;
        }

        public void ChangeToType2()
        {
            //設定をオフ
            if (NOW_TYPE.Equals(TYPE1) == true)
                OffType1();
            else
                return;

            ReSizeType2();

            Const.form.subMainSplitContainerType2Parts.AddToPanel1(Const.form.boardIndexTabControlParts);
            Const.form.subMainSplitContainerType2Parts.AddToPanel2(Const.form.boardListTabControlParts);
            Const.form.mainSplitContainerType2Parts.AddToPanel2(Const.form.threadListTabControlParts);
            Const.form.mainSplitContainerType2Parts.AddToPanel1(Const.form.subMainSplitContainerType2Parts);

            Const.form.mainForm.AddControl(Const.form.mainSplitContainerType2Parts);

            Const.form.mainSplitContainerType2Parts.Show();
            Const.form.subMainSplitContainerType2Parts.Show();

            Const.form.mainForm.Update();

            NOW_TYPE = TYPE2;
        }

        //TYPE1の設定をオフ
        public void OffType1()
        {
            try
            {
                Const.form.mainForm.ControlsRemove(Const.form.mainSplitContainerParts);
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("Other", ex);
            }

            try
            {
                Const.form.mainSplitContainerParts.Panel2ControlsRemove(Const.form.subMainSplitContainerParts);
                Const.form.mainSplitContainerParts.Panel1ControlsRemove(Const.form.boardIndexTabControlParts);
                Const.form.subMainSplitContainerParts.Panel1ControlsRemove(Const.form.boardListTabControlParts);
                Const.form.subMainSplitContainerParts.Panel2ControlsRemove(Const.form.threadListTabControlParts);

                Const.form.mainSplitContainerParts.Hide();
                Const.form.subMainSplitContainerParts.Hide();
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("Other", ex);
                return;
            }
        }

        //TYPE2の設定をオフ
        public void OffType2()
        {
            try
            {
                Const.form.mainForm.ControlsRemove(Const.form.mainSplitContainerType2Parts);
            }
            catch { ;}

            try
            {
                Const.form.mainSplitContainerType2Parts.Panel1ControlsRemove(Const.form.subMainSplitContainerType2Parts);
                Const.form.subMainSplitContainerType2Parts.Panel1ControlsRemove(Const.form.boardIndexTabControlParts);
                Const.form.subMainSplitContainerType2Parts.Panel2ControlsRemove(Const.form.boardListTabControlParts);
                Const.form.mainSplitContainerType2Parts.Panel2ControlsRemove(Const.form.threadListTabControlParts);

                Const.form.mainSplitContainerType2Parts.Hide();
                Const.form.subMainSplitContainerType2Parts.Hide();
            }
            catch (System.Exception ex)
            {
                Const.debugForm.OutPutDebug("Other", ex);
            }
        }

        public void ReSizeType1()
        {
            Const.form.boardIndexTabControlParts.Size =
                new Size(Const.form.mainSplitContainerParts.SplitterDistance - 2,
                    Const.form.mainSplitContainerParts.Size.Height);

            Const.form.boardListTabControlParts.Size =
                new Size(Const.form.mainSplitContainerParts.Size.Width - Const.form.mainSplitContainerParts.SplitterDistance - 4,
                    Const.form.subMainSplitContainerParts.SplitterDistance);

            Const.form.threadListTabControlParts.Size =
                new Size(Const.form.mainSplitContainerParts.Size.Width - Const.form.mainSplitContainerParts.SplitterDistance - 4,
                    Const.form.mainSplitContainerParts.Size.Height - Const.form.subMainSplitContainerParts.SplitterDistance - 4);

            //タブコントロールのタブのサイズ変更を促す
            Const.form.threadListTabControlParts.ItemSize = new Size(0, 0);

            MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);


            MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);


            MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);


            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            /*MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].boardListControls.listViewParts.Size =
                new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);

            MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.Size =
                new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);*/

            foreach (BoardViewCommon boardView in MainFormConst.boardListTabMain.view_list)
            {
                boardView.boardListControls.listViewParts.Size =
                    new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);
            }

            foreach (ThreadViewCommon threadView in MainFormConst.threadListTabMain.viewList)
            {
                threadView.threadViewControls.browserParts.Size =
                    new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);
            }
            
            /*if (MainFormConst.threadListTabMain.viewList != null)
            {
                //MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.SuspendLayout();
                MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.Size =
                    new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);
                //MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.ResumeLayout();
            }*/
        }
        public void ReSizeType2()
        {
            Const.form.boardIndexTabControlParts.Size =
                 new Size(Const.form.mainSplitContainerType2Parts.SplitterDistance - 4,
                     Const.form.subMainSplitContainerType2Parts.SplitterDistance - 1);

            Const.form.boardListTabControlParts.Size =
                 new Size(Const.form.mainSplitContainerType2Parts.SplitterDistance - 4,
                     Const.form.mainSplitContainerType2Parts.Size.Height - Const.form.subMainSplitContainerType2Parts.SplitterDistance - 4);

            Const.form.threadListTabControlParts.Size =
                 new Size(Const.form.mainSplitContainerType2Parts.Size.Width - Const.form.mainSplitContainerType2Parts.SplitterDistance - 4,
                     Const.form.mainSplitContainerType2Parts.Size.Height);

            //タブコントロールのタブのサイズ変更を促す
            Const.form.threadListTabControlParts.ItemSize = new Size(0, 0);

            MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);
            
            MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            
            MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);
            MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);
            MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);

            MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);
            MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);


            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.Size =
                new Size(Const.form.boardIndexTabControlParts.Size.Width - 4, Const.form.boardIndexTabControlParts.Size.Height - 84);


            /*MainFormConst.boardListTabMain.view_list[Const.form.boardListTabControlParts.SelectedIndex].boardListControls.listViewParts.Size =
                new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);

            MainFormConst.threadListTabMain.viewList[Const.form.threadListTabControlParts.SelectedIndex].threadViewControls.browserParts.Size =
                new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);*/


            foreach (BoardViewCommon boardView in MainFormConst.boardListTabMain.view_list)
            {
                boardView.boardListControls.listViewParts.Size =
                    new Size(Const.form.boardListTabControlParts.Size.Width - 6, Const.form.boardListTabControlParts.Size.Height - 63);
            }

            foreach (ThreadViewCommon threadView in MainFormConst.threadListTabMain.viewList)
            {
                threadView.threadViewControls.browserParts.Size =
                    new Size(Const.form.threadListTabControlParts.Size.Width - 6, Const.form.threadListTabControlParts.Size.Height - 84);
            }
        }
    }
}