﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi
{
    class CountryIndexControls
    {
        public TabPageExParts tabPageExParts;
        public TextBoxParts searchTextBoxParts;
        public ButtonParts searchButtonParts;
        public ButtonParts reloadButtonParts;
        public TreeViewParts treeViewParts;

        public CountryIndexControlEvent countryIndexControlEvent;

        public CountryIndexControls(BoardIndexViewCommon boardIndexViewCommon)
        {
            tabPageExParts = TabPageExPartsManager.Pop();

            searchTextBoxParts = TextBoxPartsManager.Pop();
            searchTextBoxParts.Location = new Point(2, 2);
            searchTextBoxParts.Name = "button";
            searchTextBoxParts.Size = new Size(90, -1);

            searchButtonParts = ButtonPartsManager.Pop();
            searchButtonParts.Location = new Point(100, 1);
            searchButtonParts.Name = "control";
            searchButtonParts.Size = new Size(26, 26);
            searchButtonParts.SetToolTip("検索");
            searchButtonParts.Image = Resources.search;

            reloadButtonParts = ButtonPartsManager.Pop();
            reloadButtonParts.Location = new Point(130, 1);
            reloadButtonParts.Name = "control";
            reloadButtonParts.Size = new Size(26, 26);
            reloadButtonParts.SetToolTip("再読み込み");
            reloadButtonParts.Image = Resources.reload;

            treeViewParts = TreeViewPartsManager.Pop(boardIndexViewCommon);
            treeViewParts.Name = "kokka";
            //treeViewParts.Size = new Size(Const.form.boardIndexTabControlParts.Size.Width,
            //    Const.form.boardIndexTabControlParts.Size.Height - 28);

            countryIndexControlEvent = new CountryIndexControlEvent(this);
        }

        public void AddControls()
        {
            tabPageExParts.AddControl(searchTextBoxParts);
            tabPageExParts.AddControl(searchButtonParts);
            tabPageExParts.AddControl(reloadButtonParts);
            tabPageExParts.AddControl(treeViewParts);
        }
        public void RemoveControls()
        {
            //タブページの中身を削除
            tabPageExParts.RemoveAllCtrl();

            //イベントを削除
            countryIndexControlEvent.RemoveEvent();

            //タブからタブページを削除
            Const.form.boardIndexTabControlParts.ControlsRemove(tabPageExParts);

            TabPageExPartsManager.Push(tabPageExParts);
            TextBoxPartsManager.Push(searchTextBoxParts);
            ButtonPartsManager.Push(searchButtonParts);
            ButtonPartsManager.Push(reloadButtonParts);
            TreeViewPartsManager.Push(treeViewParts);

            tabPageExParts = null;
            searchTextBoxParts = null;
            searchButtonParts = null;
            reloadButtonParts = null;
            treeViewParts = null;
        }
    }
}
