﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;


using System.Windows.Forms;
using mshtml;

using nispi.Menu;
namespace nispi.controlclass
{
    class CountryIndexTabEvent
    {
        public CountryIndexTabMenu boardIndexTabMenu;

        public CountryIndexTabEvent(CountryIndexTabMenu boardIndexTabMenu)
        {
            this.boardIndexTabMenu = boardIndexTabMenu;

            this.boardIndexTabMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            this.boardIndexTabMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            this.boardIndexTabMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            this.boardIndexTabMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            this.boardIndexTabMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            this.boardIndexTabMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            this.boardIndexTabMenu.menuItemReloadParts.Image = Resources.reload;
            this.boardIndexTabMenu.menuItemReloadParts.ImageTransparentColor = Color.White;

            Const.mapForm.CountryIndexTabControlParts.MouseUp += new MouseEventHandler(boardIndex_tabControl_MouseUp);
            Const.mapForm.CountryIndexTabControlParts.MouseDown += new MouseEventHandler(boardIndex_tabControl_MouseDown);
        }

        private void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            string url;
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                url = Const.BOARD_INDEX_ADDRESS;
                Process.Start(url);
            }
            else
            {
                //title = ViewMediator.boardIndexTabWidget.favoriteBoardIndexView.tabPage.Text;
            }
        }

        private void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            string url;
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                url = Const.BOARD_INDEX_ADDRESS;
                Clipboard.SetDataObject(url, true);
            }
            else
            {
                //title = ViewMediator.boardIndexTabWidget.favoriteBoardIndexView.tabPage.Text;
            }
        }

        private void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            string title;
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                title = MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            else
            {
                title = MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.tabPageExParts.Text;
            }
            Clipboard.SetDataObject(title, true);
        }

        //+++++//
        private void menuItemReload_Click(object sender, EventArgs e)
        {
            //お気に入りか、２ｃｈのインデックスか
            if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.boardIndexView.LoadBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
            else
            {
                Thread t2 =
                    new Thread(new ThreadStart(MainFormConst.boardIndexTabMain.favoriteBoardIndexView.LoadFavoriteBoardListThread));
                t2.IsBackground = true;
                t2.Start();
            }
        }

        private void menuItemAddSearch_Click(object sender, EventArgs e)
        {
            ;
        }

        private void boardIndex_tabControl_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                this.boardIndexTabMenu.contextMenuStripParts.Show(Const.mapForm.CountryIndexTabControlParts, e.Location);
            }
        }

        private void boardIndex_tabControl_MouseDown(object sender, MouseEventArgs e)
        {
            int selectNum = 0;

            if (e.Button == MouseButtons.Right)
            {
                for (int i = 0; i < Const.form.boardIndexTabControlParts.Count; i++)
                {
                    if (Const.form.boardIndexTabControlParts.GetTabRect(i).Contains(e.X, e.Y))
                    {
                        Const.form.boardIndexTabControlParts.SelectedIndex = i;
                        selectNum = i;
                    }
                }
            }
            else
            {
                return;
            }

            if (selectNum == 0)
            {
                this.boardIndexTabMenu.menuItemOpenBrowserParts.Enabled = true;
                this.boardIndexTabMenu.menuItemCopyURLParts.Enabled = true;
                this.boardIndexTabMenu.menuItemCopyTitleParts.Enabled = true;
                this.boardIndexTabMenu.menuItemReloadParts.Enabled = true;

            }
            else if (selectNum == 1)
            {
                this.boardIndexTabMenu.menuItemOpenBrowserParts.Enabled = false;
                this.boardIndexTabMenu.menuItemCopyURLParts.Enabled = false;
                this.boardIndexTabMenu.menuItemCopyTitleParts.Enabled = true;
                this.boardIndexTabMenu.menuItemReloadParts.Enabled = true;
            }
        }
    }
}
