﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.IO;
using nispi.Menu;
using nispi.controlclass;

namespace nispi
{
    partial class AbonListViewParts : ControlBase
    {
        void SetColorTable()
        {
            //外観の初期化
            columnForeBrush = new SolidBrush(Color.Black);

            columnBackBrush = new SolidBrush(Color.LightGray);

            lVForeColorBrush = new SolidBrush(Color.Black);

            lVBackColorBrush = new SolidBrush(Color.White);

            lVBackColor2Brush = new SolidBrush(Color.AliceBlue);

            lVSelectForeColorBrush = new SolidBrush(Color.White);
            lVSelectBackColorBrush = new SolidBrush(SystemColors.MenuHighlight);
        }
        void control_DrawColumnHeader(object sender, DrawListViewColumnHeaderEventArgs e)
        {
            e.Graphics.FillRectangle(columnBackBrush, e.Bounds);
            e.Graphics.DrawString(e.Header.Text,
                control.Font,
                columnForeBrush, new PointF(e.Bounds.Left, e.Bounds.Top));
        }

        //通常のやり方
        void control_DrawSubItem(object sender, DrawListViewSubItemEventArgs e)
        {
            string text = e.SubItem.Text;

            if (((e.ItemState & (ListViewItemStates.Selected)) == (ListViewItemStates.Selected)))
            {
                e.Graphics.DrawString(text, control.Font, lVSelectForeColorBrush, e.Bounds);
            }
            else
            {
                e.Graphics.DrawString(text, control.Font, lVForeColorBrush, e.Bounds);
            }


            if (this.control.Focused == false)
            {
                if (oldItemNumList.Length > 0)
                {
                    if (oldItemNumList.Contains(e.ItemIndex) == true)
                    {
                        e.Graphics.FillRectangle(lVSelectBackColorBrush,
                            e.Bounds.Left, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height);
                        e.Graphics.DrawString(text, control.Font, lVSelectForeColorBrush, e.Bounds);
                    }
                }
            }
        }

        void control_DrawItem(object sender, DrawListViewItemEventArgs e)
        {
            if (((e.State & (ListViewItemStates.Selected)) == (ListViewItemStates.Selected)))
            {
                e.Graphics.FillRectangle(lVSelectBackColorBrush,
                    e.Bounds.Left, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height);
            }
            else
            {
                /*if ((e.ItemIndex % 2) == 0)
                    ;//e.Graphics.FillRectangle(lVBackColorBrush,
                        //e.Bounds.Left, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height);
                else
                    ;//e.Graphics.FillRectangle(lVBackColor2Brush,
                        //e.Bounds.Left, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height);

                if (this.control.Focused == false)
                {
                    if (oldItemNumList.Length > 0)
                    {
                        if (oldItemNumList.Contains(e.ItemIndex) == true)
                            e.Graphics.FillRectangle(lVSelectBackColorBrush,
                                e.Bounds.Left, e.Bounds.Top, e.Bounds.Width, e.Bounds.Height);
                    }
                }*/
            }
        }
    }
}
