﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using System.Threading;
using System.Runtime.InteropServices;
using System.Drawing;

using nispi.Menu;
using nispi.controlclass;

namespace nispi
{
    class AbonListViewEx : ListView
    {
        public FormParts ownerForm;

        protected override void WndProc(ref Message m)
        {
            const int WM_VSCROLL = 0x115;

            switch (m.Msg)
            {
                case WM_VSCROLL:
                    ownerForm.Focus();
                    break;
            }
            base.WndProc(ref m);
        }

        protected override bool DoubleBuffered { get { return true; } set { } }
    }

    partial class AbonListViewParts:ControlBase
    {
        private AbonListViewEx control;

        ColumnHeader columnText = new ColumnHeader();
        ColumnHeader columnType = new ColumnHeader();
        ColumnHeader columnOn = new ColumnHeader();
        ColumnHeader columnReg = new ColumnHeader();

        public SolidBrush columnForeBrush;
        public SolidBrush columnBackBrush;

        public SolidBrush lVForeColorBrush;

        public SolidBrush lVBackColorBrush;
        public SolidBrush lVBackColor2Brush;

        public SolidBrush lVSelectForeColorBrush;
        public SolidBrush lVSelectBackColorBrush;

        public int[] oldItemNumList;

        public AbonListViewParts()
        {
            oldItemNumList = new int[0];
            //listView
            control = new AbonListViewEx();

            ImageList list = new ImageList();
            list.ImageSize = new Size(1, 18);
            control.SmallImageList = list;
            control.Font =
                new Font("Meiryo UI", 10.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(128)));
            control.Location = new Point(1, 27);
            control.Name = "listView1";
            control.TabIndex = 0;
            control.UseCompatibleStateImageBehavior = false;
            control.View = View.Details;
            control.FullRowSelect = true;
            control.MultiSelect = false;
            this.SetColorTable();
            //オーナードローの設定
            control.OwnerDraw = true;
            control.DrawColumnHeader += new DrawListViewColumnHeaderEventHandler(control_DrawColumnHeader);
            control.DrawItem += new DrawListViewItemEventHandler(control_DrawItem);
            control.DrawSubItem += new DrawListViewSubItemEventHandler(control_DrawSubItem);


            control.MouseMove += new MouseEventHandler(listViewPart_MouseMove);
            control.ColumnClick += new ColumnClickEventHandler(listView_ColumnClick);
            control.SelectedIndexChanged += new EventHandler(listViewPart_SelectedIndexChanged);

            //オーナードロー用の色を設定する



            this.controlBase = (Control)control;

            columnText.Text = "あぼん文字";
            columnText.Width = 280;
            columnType.Text = "タイプ";
            columnType.Width = 70;
            columnReg.Text = "正規表現";
            columnReg.Width = 80;
            columnOn.Text = "ON/OFF";
            columnOn.Width = 85;

            ColumnHeader[] colHeaderRegValue = {
				columnText, columnReg, columnType, columnOn};

            control.Columns.AddRange(colHeaderRegValue);
        }
        public void ResetControl()
        {
            this.control.ownerForm = null;
        }

        public void AddItem(ListViewItemParts itemParts)
        {
            this.control.Items.Add(itemParts.control);
        }

        public void ItemsRemoveAt(int num)
        {
            this.control.Items.RemoveAt(num);
        }

        public void SelectItem(int num)
        {
            this.control.Items[num].Selected = true;
        }

        public int GetSelectedItemNum()
        {
            return this.control.SelectedItems[0].Index;
        }

        public void Items_Clear()
        {
            this.control.Items.Clear();
        }

        public bool VirtualMode
        {
            set
            {
                this.control.VirtualMode = value;
            }
        }

        //マウスが動いた時に、フォーカスが無いのならば与える（スクロールバークリック時に対応）
        public void listViewPart_MouseMove(object sender, MouseEventArgs e)
        {
            /*AbonListViewEx listViewEx = (AbonListViewEx)sender;

            GetFocus(listViewEx);*/
        }

        //ソート関連
        public void listView_ColumnClick(object sender, ColumnClickEventArgs e)
        {
            try
            {
                //２ｃｈでのレスの順番
                /*if (e.Column == 1)
                {
                    if (boardView.beforeNum == e.Column)
                        threadList.Sort(BoadListSort.CompareOrderNumRev);
                    else
                        threadList.Sort(BoadListSort.CompareOrderNum);
                }*/
            }
            catch { ;}
        }
        public void listViewPart_SelectedIndexChanged(object sender, EventArgs e)
        {
            oldItemNumList = null;
            oldItemNumList = new int[control.SelectedIndices.Count];
            control.SelectedIndices.CopyTo(oldItemNumList, 0);

            if (control.SelectedIndices.Count == 0)
                return;
        }
        public void GetFocus(AbonListViewEx listViewEx)
        {
            if ((control.ownerForm != null) && (control.ownerForm.ContainsFocus == true))
            {
                listViewEx.Focus();
            }
        }
        public int Count
        {
            get
            {
                return this.control.Items.Count;
            }
        }
    }

    class AbonListViewPartsManager
    {
        public static Stack<AbonListViewParts> buttonStack = new Stack<AbonListViewParts>();
        public static Mutex mutex = new Mutex(false, "AbonListViewPartManager");

        public static AbonListViewParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new AbonListViewParts());

            AbonListViewParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(AbonListViewParts buttonParts)
        {
            mutex.WaitOne();

            buttonParts.ResetControl();
            buttonParts.Update();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}
