﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace nispi.controlclass
{
    class ControlBase
    {
        public Control controlBase;
        public ToolTip toolTip;

        public ControlBase()
        {
        }
        public Point PointToScreen()
        {
            return this.controlBase.PointToScreen(this.controlBase.Location);
        }
        public void AddControl(ControlBase targetControlBase)
        {
            this.controlBase.Controls.Add(targetControlBase.controlBase);
        }
        
        public void AddControl(Control targetControl)
        {
            this.controlBase.Controls.Add(targetControl as Control);
        }

        public void ControlsRemove(ControlBase targetControlBase)
        {
            this.controlBase.Controls.Remove(targetControlBase.controlBase);
        }

        public void RemoveAllCtrl()
        {
            this.controlBase.Controls.Clear();
        }

        public void SuspendLayout()
        {
            controlBase.SuspendLayout();
        }

        public void ResumeLayout()
        {
            controlBase.ResumeLayout();
        }

        public string Text
        {
            set
            {
                this.controlBase.Text = value;
            }
            get
            {
                return this.controlBase.Text;
            }
        }
        public string Name
        {
            set
            {
                this.controlBase.Name = value;
            }
            get
            {
                return this.controlBase.Name;
            }
        }
        public Size Size
        {
            set
            {
                this.controlBase.Size = value;
            }
            get
            {
                return this.controlBase.Size;
            }
        }
        public Point Location
        {
            set
            {
                this.controlBase.Location = value;
            }
            get
            {
                return this.controlBase.Location;
            }
        }
        public Font Font
        {
            set
            {
                this.controlBase.Font = value;
            }
            get
            {
                return this.controlBase.Font;
            }
        }
        public event KeyPressEventHandler KeyPress
        {
            add
            {
                this.controlBase.KeyPress += value;
            }
            remove
            {
                this.controlBase.KeyPress -= value;
            }
        }
        public event EventHandler Click
        {
            add
            {
                this.controlBase.Click += value;
            }
            remove
            {
                this.controlBase.Click -= value;
            }
        }
        public event MouseEventHandler MouseClick
        {
            add
            {
                this.controlBase.MouseClick += value;
            }
            remove
            {
                this.controlBase.MouseClick -= value;
            }
        }
        public event MouseEventHandler MouseDoubleClick
        {
            add
            {
                this.controlBase.MouseDoubleClick += value;
            }
            remove
            {
                this.controlBase.MouseDoubleClick -= value;
            }
        }
        public event EventHandler MouseHover
        {
            add
            {
                this.controlBase.MouseHover += value;
            }
            remove
            {
                this.controlBase.MouseHover -= value;
            }
        }
        public event MouseEventHandler MouseMove
        {
            add
            {
                this.controlBase.MouseMove += value;
            }
            remove
            {
                this.controlBase.MouseMove -= value;
            }
        }
        public event MouseEventHandler MouseDown
        {
            add
            {
                this.controlBase.MouseDown += value;
            }
            remove
            {
                this.controlBase.MouseDown -= value;
            }
        }
        public event MouseEventHandler MouseUp
        {
            add
            {
                this.controlBase.MouseUp += value;
            }
            remove
            {
                this.controlBase.MouseUp -= value;
            }
        }
        public void SetFont(string fontName, float fontSize)
        {
            this.controlBase.Font = new Font(fontName, fontSize, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
        }
        public string GetFontName()
        {
            return this.controlBase.Font.Name;
        }
        public float GetFontSize()
        {
            return this.controlBase.Font.Size;
        }
        public void SetWaitCursor()
        {
            this.controlBase.Cursor = Cursors.WaitCursor;
        }
        public void ReSetWaitCursor()
        {
            this.controlBase.Cursor = Cursors.Default;
        }
        public void Show()
        {
            this.controlBase.Show();
        }
        public void Hide()
        {
            this.controlBase.Hide();
        }
        public void Focus()
        {
            this.controlBase.Focus();
        }
        public void Update()
        {
            this.controlBase.Update();
        }
        public void Refresh()
        {
            this.controlBase.Refresh();
        }
        public void Invalidate()
        {
            this.controlBase.Invalidate();
        }

        public void Invoke(Delegate method, params object[] data)
        {
            this.controlBase.Invoke(method, data);
        }

        public void BeginInvoke(Delegate method, params object[] data)
        {
            this.controlBase.BeginInvoke(method, data);
        }


        public bool ContainsFocus
        {
            get
            {
                return this.controlBase.ContainsFocus;
            }
        }
        public bool Visible
        {
            set
            {
                this.controlBase.Visible = value;
            }
            get
            {
                return this.controlBase.Visible;
            }
        }
        public bool Enabled
        {
            set
            {
                this.controlBase.Enabled = value;
            }
            get
            {
                return this.controlBase.Enabled;
            }
        }
        public Size ClientSize
        {
            set
            {
                this.controlBase.ClientSize = value;
            }
            get
            {
                return this.controlBase.ClientSize;
            }
        }
        public Size MinimumSize
        {
            set
            {
                this.controlBase.MinimumSize = value;
            }
            get
            {
                return this.controlBase.MinimumSize;
            }
        }
        public Color BackColor
        {
            set
            {
                this.controlBase.BackColor = value;
            }
            get
            {
                return this.controlBase.BackColor;
            }
        }
        public Color ForeColor
        {
            set
            {
                this.controlBase.ForeColor = value;
            }
            get
            {
                return this.controlBase.ForeColor;
            }
        }
        
        public void SetToolTip(string text)
        {
            toolTip = new ToolTip();
            toolTip.SetToolTip(controlBase, text);
        }

        public void SetPadding(int left, int top, int right, int bottom)
        {
            this.controlBase.Padding = new Padding(left, top, right, bottom);
        }

        public void ResetControlBase()
        {
            if (this.controlBase != null)
            {
                this.controlBase.Text = "";
                this.controlBase.Name = "";
            }
            //try
            if (toolTip != null)
            {
                this.toolTip.Dispose();
                this.toolTip = null;
            }
        }
    }
}
