﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class GroupBoxParts : ControlBase
    {
        private GroupBox control;

        public GroupBoxParts()
        {
            control = new GroupBox();
            controlBase = (Control)control;
        }
    }

    class GroupBoxPartsManager
    {
        public static Stack<GroupBoxParts> buttonStack = new Stack<GroupBoxParts>();
        public static Mutex mutex = new Mutex(false, "GroupBoxPartsManager");

        public static GroupBoxParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new GroupBoxParts());

            GroupBoxParts buttonParts = buttonStack.Pop();

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(GroupBoxParts buttonParts)
        {
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }
    }
}