﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

namespace nispi.controlclass
{
    /// <summary>
    /// ボタンのパーツ。ラッピング。
    /// </summary>
    class LabelParts:ControlBase
    {
        private Label control;

        public LabelParts()
        {
            control = new Label();
            this.controlBase = (Control)control;
        }

        public void Set_BorderStyle_FixedSingle()
        {
            control.BorderStyle = BorderStyle.FixedSingle;
        }
        /*public void SetDockFill()
        {
            this.control.Dock = DockStyle.Fill;
        }
        public void SetAnchorNonBottom()
        {
            this.control.Dock = DockStyle.None;

            this.control.Anchor = (AnchorStyles)
                ((AnchorStyles.Top) |
                (AnchorStyles.Left) | (AnchorStyles.Right));
        }

        public void SetAnchor4()
        {
            this.control.Dock = DockStyle.None;

            this.control.Anchor = (AnchorStyles)
                ((AnchorStyles.Top) | (AnchorStyles.Bottom) |
                (AnchorStyles.Left) | (AnchorStyles.Right));
        }*/

        public void ResetControl()
        {
            this.control.BorderStyle = BorderStyle.None;
        }
    }

    class LabelPartsManager
    {
        public static LinkedList<LabelParts> allFormList = new LinkedList<LabelParts>();
        public static Stack<LabelParts> buttonStack = new Stack<LabelParts>();
        public static Mutex mutex = new Mutex(false, "LabelPartsManager");

        public static LabelParts Pop()
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new LabelParts());

            LabelParts buttonParts = buttonStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allFormList.AddLast(buttonParts);
            }

            mutex.ReleaseMutex();

            return buttonParts;
        }

        public static void Push(LabelParts buttonParts)
        {
            buttonParts.ResetControlBase();
            buttonParts.ResetControl();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (LabelParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(LabelParts parts)
        {
            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);
        }
    }
}