﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;
using nispi;

namespace nispi.controlclass
{
    class HtmlPopUpFormParts:ControlBase
    {
        public Form control;

        public HtmlPopUpFormParts()
        {
            control = new Form();
            control.AutoScaleDimensions = new SizeF(9F, 19F);
            control.AutoScaleMode = AutoScaleMode.Font;
            control.Font = new Font("MＭＳ Ｐゴシック", 12.0F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));

            control.ShowInTaskbar = false;
            control.ShowIcon = false;
            control.FormBorderStyle = FormBorderStyle.None;
            control.StartPosition = FormStartPosition.Manual;
            control.Padding = new Padding(0, 0, 0, 0);

            control.FormClosing += new FormClosingEventHandler(Form_FormClosing);

            this.controlBase = (Control)control;
        }

        public Size GetDisplaySize()
        {
            //ディスプレイの高さ
            int DisplayY = System.Windows.Forms.Screen.GetWorkingArea(this.control).Height;
            //ディスプレイの幅
            int DisplayX = System.Windows.Forms.Screen.GetWorkingArea(this.control).Width;

            return new Size(DisplayX, DisplayY);
        }

        void Form_FormClosing(object sender, FormClosingEventArgs e)
        {
            //終了させるために、タブの再構築を止める。
            MainFormConst.threadListTabMain.mutex.WaitOne();
            MainFormConst.boardListTabMain.mutex.WaitOne();

            MainFormConst.boardListTabMain.exit_app = true;
            MainFormConst.threadListTabMain.exit_app = true;

            MainFormConst.boardListTabMain.mutex.ReleaseMutex();
            MainFormConst.threadListTabMain.mutex.ReleaseMutex();
        }
        public void ResetControl()
        {
            this.control.FormBorderStyle = FormBorderStyle.None;
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class HtmlPopUpFormPartsManager
    {
        public static Stack<HtmlPopUpFormParts> tabPageStack = new Stack<HtmlPopUpFormParts>();
        public static Mutex mutex = new Mutex(false, "HtmlPopUpFormPartsManager");

        public static HtmlPopUpFormParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new HtmlPopUpFormParts());

            HtmlPopUpFormParts tabPage = tabPageStack.Pop();
            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(HtmlPopUpFormParts tabPage)
        {
            tabPage.ResetControlBase();
            tabPage.ResetControl();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }
    }
}
