﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Xml.Linq;

using nispi;

namespace nispi.OptionControl
{
    partial class OutWardListData : CommonInEvent
    {
        //リストビューのフォント
        private string lVFontName;
        private float lVFontSize;
        //リストビューのオリジナルフォント
        private string lVOriginalFontPath;
        private float lVOriginalFontSize; 
        public string tempLVoriginalFontPath;
        public float tempLVoriginalFontSize;
        public System.Drawing.Text.PrivateFontCollection pfc;
        private Font lVOriginalFont;
        
        //インストール済みフォントか、オリジナルフォントか
        private string lVFontType;
        
        //リストの文字色
        private byte lVForeColorRed;
        private byte lVForeColorGreen;
        private byte lVForeColorBlue;
        //リストの背景色の一つおき
        private byte lVBackColorRed;
        private byte lVBackColorGreen;
        private byte lVBackColorBlue;
        //リストの背景色の一つおき
        private byte lVBackColor2Red;
        private byte lVBackColor2Green;
        private byte lVBackColor2Blue;
        //選択されたリストの前景色
        private byte lVSelectForeColorRed;
        private byte lVSelectForeColorGreen;
        private byte lVSelectForeColorBlue;
        //選択されたリストの背景色
        private byte lVSelectBackColorRed;
        private byte lVSelectBackColorGreen;
        private byte lVSelectBackColorBlue;
        //カラムの文字色
        private byte lVColmunForeColorRed;
        private byte lVColmunForeColorGreen;
        private byte lVColmunForeColorBlue;
        //カラムの背景色
        private byte lVColmunBackColorRed;
        private byte lVColmunBackColorGreen;
        private byte lVColmunBackColorBlue;

        private Mutex mutex = new Mutex(false, "OutWardListData");

        public OutWardListData()
        {
            GetXMLData();
        }

        public string ResetXML()
        {
            XNamespace ns = "OutWard_List";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "LVFontName", "ＭＳ Ｐゴシック"),
                new XElement(ns + "LVFontSize", "12.0"),

                new XElement(ns + "LVOriginalFontPath", "None"),
                new XElement(ns + "LVOriginalFontSize", "12.0"),
                new XElement(ns + "LVFontType", "installed"),

                new XElement(ns + "LVForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "LVForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "LVForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "LVBackColorRed", Color.White.R.ToString()),
                new XElement(ns + "LVBackColorGreen", Color.White.G.ToString()),
                new XElement(ns + "LVBackColorBlue", Color.White.B.ToString()),

                new XElement(ns + "LVBackColor2Red", Color.AliceBlue.R.ToString()),
                new XElement(ns + "LVBackColor2Green", Color.AliceBlue.G.ToString()),
                new XElement(ns + "LVBackColor2Blue", Color.AliceBlue.B.ToString()),

                new XElement(ns + "LVSelectForeColorRed", SystemColors.HighlightText.R.ToString()),
                new XElement(ns + "LVSelectForeColorGreen", SystemColors.HighlightText.G.ToString()),
                new XElement(ns + "LVSelectForeColorBlue", SystemColors.HighlightText.B.ToString()),

                new XElement(ns + "LVSelectBackColorRed", SystemColors.Highlight.R.ToString()),
                new XElement(ns + "LVSelectBackColorGreen", SystemColors.Highlight.G.ToString()),
                new XElement(ns + "LVSelectBackColorBlue", SystemColors.Highlight.B.ToString()),

                new XElement(ns + "LVColmunForeColorRed", SystemColors.WindowText.R.ToString()),
                new XElement(ns + "LVColmunForeColorGreen", SystemColors.WindowText.G.ToString()),
                new XElement(ns + "LVColmunForeColorBlue", SystemColors.WindowText.B.ToString()),

                new XElement(ns + "LVColmunBackColorRed", SystemColors.Window.R.ToString()),
                new XElement(ns + "LVColmunBackColorGreen", SystemColors.Window.G.ToString()),
                new XElement(ns + "LVColmunBackColorBlue", SystemColors.Window.B.ToString()));

            mutex.WaitOne();

            FileIO.SaveShiftJis("setting", "outward_list.xml", doc.ToString());

            mutex.ReleaseMutex();

            return doc.ToString();
        }
        private void GetXMLData()
        {
            mutex.WaitOne();

            string str = FileIO.ReadShiftJis("setting", "outward_list.xml");

            if ((str == null) || (str.Length == 0))
                str = ResetXML();

            try
            {
                XNamespace ns = "OutWard_List";
                XDocument doc = XDocument.Parse(str);
                XElement doc2 = doc.Element(ns + "Option");

                LVFontName = doc2.Element(ns + "LVFontName").Value;
                LVFontSize = float.Parse(doc2.Element(ns + "LVFontSize").Value);

                //以前のバージョン設定を使っている人向け
                try
                {
                    LVOriginalFontPath = doc2.Element(ns + "LVOriginalFontPath").Value;
                    LVOriginalFontSize = float.Parse(doc2.Element(ns + "LVOriginalFontSize").Value);
                    LVFontType = doc2.Element(ns + "LVFontType").Value;
                    if (LVFontType.Equals("original") == true)
                    {
                        this.pfc = new System.Drawing.Text.PrivateFontCollection();
                        //オリジナルフォントを設定
                        this.pfc.AddFontFile(LVOriginalFontPath);
                        this.LVOriginalFont = new Font(this.pfc.Families[0], this.LVOriginalFontSize);
                    }
                }
                catch
                {
                    LVOriginalFontPath = "None";
                    LVOriginalFontSize = 12.0f;
                    LVFontType = "installed";
                }

                LVForeColorRed = Byte.Parse(doc2.Element(ns + "LVForeColorRed").Value);
                LVForeColorGreen = Byte.Parse(doc2.Element(ns + "LVForeColorGreen").Value);
                LVForeColorBlue = Byte.Parse(doc2.Element(ns + "LVForeColorBlue").Value);

                LVBackColorRed = Byte.Parse(doc2.Element(ns + "LVBackColorRed").Value);
                LVBackColorGreen = Byte.Parse(doc2.Element(ns + "LVBackColorGreen").Value);
                LVBackColorBlue = Byte.Parse(doc2.Element(ns + "LVBackColorBlue").Value);

                LVBackColor2Red = Byte.Parse(doc2.Element(ns + "LVBackColor2Red").Value);
                LVBackColor2Green = Byte.Parse(doc2.Element(ns + "LVBackColor2Green").Value);
                LVBackColor2Blue = Byte.Parse(doc2.Element(ns + "LVBackColor2Blue").Value);

                LVSelectForeColorRed = Byte.Parse(doc2.Element(ns + "LVSelectForeColorRed").Value);
                LVSelectForeColorGreen = Byte.Parse(doc2.Element(ns + "LVSelectForeColorGreen").Value);
                LVSelectForeColorBlue = Byte.Parse(doc2.Element(ns + "LVSelectForeColorBlue").Value);

                LVSelectBackColorRed = Byte.Parse(doc2.Element(ns + "LVSelectBackColorRed").Value);
                LVSelectBackColorGreen = Byte.Parse(doc2.Element(ns + "LVSelectBackColorGreen").Value);
                LVSelectBackColorBlue = Byte.Parse(doc2.Element(ns + "LVSelectBackColorBlue").Value);

                LVColmunForeColorRed = Byte.Parse(doc2.Element(ns + "LVColmunForeColorRed").Value);
                LVColmunForeColorGreen = Byte.Parse(doc2.Element(ns + "LVColmunForeColorGreen").Value);
                LVColmunForeColorBlue = Byte.Parse(doc2.Element(ns + "LVColmunForeColorBlue").Value);

                LVColmunBackColorRed = Byte.Parse(doc2.Element(ns + "LVColmunBackColorRed").Value);
                LVColmunBackColorGreen = Byte.Parse(doc2.Element(ns + "LVColmunBackColorGreen").Value);
                LVColmunBackColorBlue = Byte.Parse(doc2.Element(ns + "LVColmunBackColorBlue").Value);
            }
            catch { ;}
            mutex.ReleaseMutex();
        }

        public void SaveListViewToFile()
        {
            mutex.WaitOne();

            XNamespace ns = "OutWard_List";
            XElement doc = new XElement(ns + "Option",
                new XElement(ns + "LVFontName", LVFontName),
                new XElement(ns + "LVFontSize", LVFontSize.ToString()),

                new XElement(ns + "LVOriginalFontPath", LVOriginalFontPath),
                new XElement(ns + "LVOriginalFontSize", LVOriginalFontSize.ToString()),
                new XElement(ns + "LVFontType", LVFontType),

                new XElement(ns + "LVForeColorRed", LVForeColorRed.ToString()),
                new XElement(ns + "LVForeColorGreen", LVForeColorGreen.ToString()),
                new XElement(ns + "LVForeColorBlue", LVForeColorBlue.ToString()),

                new XElement(ns + "LVBackColorRed", LVBackColorRed.ToString()),
                new XElement(ns + "LVBackColorGreen", LVBackColorGreen.ToString()),
                new XElement(ns + "LVBackColorBlue", LVBackColorBlue.ToString()),

                new XElement(ns + "LVBackColor2Red", LVBackColor2Red.ToString()),
                new XElement(ns + "LVBackColor2Green", LVBackColor2Green.ToString()),
                new XElement(ns + "LVBackColor2Blue", LVBackColor2Blue.ToString()),

                new XElement(ns + "LVSelectForeColorRed", LVSelectForeColorRed.ToString()),
                new XElement(ns + "LVSelectForeColorGreen", LVSelectForeColorGreen.ToString()),
                new XElement(ns + "LVSelectForeColorBlue", LVSelectForeColorBlue.ToString()),

                new XElement(ns + "LVSelectBackColorRed", LVSelectBackColorRed.ToString()),
                new XElement(ns + "LVSelectBackColorGreen", LVSelectBackColorGreen.ToString()),
                new XElement(ns + "LVSelectBackColorBlue", LVSelectBackColorBlue.ToString()),

                new XElement(ns + "LVColmunForeColorRed", LVColmunForeColorRed.ToString()),
                new XElement(ns + "LVColmunForeColorGreen", LVColmunForeColorGreen.ToString()),
                new XElement(ns + "LVColmunForeColorBlue", LVColmunForeColorBlue.ToString()),

                new XElement(ns + "LVColmunBackColorRed", LVColmunBackColorRed.ToString()),
                new XElement(ns + "LVColmunBackColorGreen", LVColmunBackColorGreen.ToString()),
                new XElement(ns + "LVColmunBackColorBlue", LVColmunBackColorBlue.ToString()));

            FileIO.SaveShiftJis("setting", "outward_list.xml", doc.ToString());

            mutex.ReleaseMutex();
        }
        public Font LVFont
        {
            get
            {
                if (LVFontType.Equals("installed") == true)
                    return new Font(this.LVFontName, Scale.GetScaledFloat(this.LVFontSize));
                //オリジナルフォントで、ファイルが存在する場合
                else if ((LVFontType.Equals("original") == true) && (CheckFile(this.LVOriginalFontPath) == true))
                {
                    return LVOriginalFont;
                    /*this.pfc = new System.Drawing.Text.PrivateFontCollection();
                    //オリジナルフォントを設定
                    this.pfc.AddFontFile(this.LVOriginalFontPath);
                    //this.pfc.AddMemoryFont(
                    return new Font(this.pfc.Families[0], Scale.GetScaledFloat(this.lVOriginalFontSize));*/
                }
                else
                    return new Font(this.LVFontName, Scale.GetScaledFloat(this.LVFontSize));
            }
        }

        public String LVFontName
        {
            set
            {
                mutex.WaitOne();
                this.lVFontName = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.lVFontName);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public float LVFontSize
        {
            set
            {
                mutex.WaitOne();
                this.lVFontSize = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                float data = this.lVFontSize;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public String LVOriginalFontPath
        {
            set
            {
                mutex.WaitOne();
                this.lVOriginalFontPath = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = StrUtil.GetStrCopy(this.lVOriginalFontPath);
                mutex.ReleaseMutex();
                return data;
            }
        }

        public float LVOriginalFontSize
        {
            set
            {
                mutex.WaitOne();
                this.lVOriginalFontSize = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                float data = this.lVOriginalFontSize;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public Font LVOriginalFont
        {
            set
            {
                mutex.WaitOne();
                this.lVOriginalFont = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                Font data = this.lVOriginalFont;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public string LVFontType
        {
            set
            {
                mutex.WaitOne();
                this.lVFontType = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                string data = this.lVFontType.ToString();
                mutex.ReleaseMutex();
                return data;
            }
        }

        public byte LVForeColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVForeColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVForeColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVForeColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVForeColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVForeColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVForeColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVForeColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVForeColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVBackColorRed
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVBackColorRed = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVBackColorRed;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVBackColorGreen
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVBackColorGreen = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVBackColorGreen;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVBackColorBlue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVBackColorBlue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVBackColorBlue;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVBackColor2Red
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVBackColor2Red = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVBackColor2Red;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVBackColor2Green
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVBackColor2Green = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVBackColor2Green;
                mutex.ReleaseMutex();
                return data;
            }
        }
        public byte LVBackColor2Blue
        {
            set
            {
                //if (CheckBool(value) == false) return;
                mutex.WaitOne();
                this.lVBackColor2Blue = value;
                mutex.ReleaseMutex();
            }
            get
            {
                mutex.WaitOne();
                byte data = this.lVBackColor2Blue;
                mutex.ReleaseMutex();
                return data;
            }
        }

    }
}
