﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;
namespace nispi.OptionControl
{
    partial class OutWardMenu
    {
        GroupBoxParts menuGBoxParts;

        public LabelParts menuSample1LabelParts;
        public LabelParts menuSample2LabelParts;
        //public LabelParts menuSample3LabelParts;

        public ButtonParts sample1ForeColorButtonParts;
        public ButtonParts sample1BackColorButtonParts;

        //public ButtonParts sample2ForeColorButtonParts;
        public ButtonParts sample2BackColorButtonParts;

        //public ButtonParts sample3ForeColorButtonParts;
        //public ButtonParts sample3BackColorButtonParts;

        public ButtonParts resetButtonParts;

        public OptionMainForm optionTabMain;

        public OutWardMenu(OptionMainForm optionTabMain)
        {
            this.optionTabMain = optionTabMain;
            float scaledFloat = Scale.GetScaledFloat(optionTabMain.fontSize);

            menuGBoxParts = new GroupBoxParts();

            //背景色、文字色、選択色、無効のメニューの色
            //
            menuSample1LabelParts = new LabelParts();
            menuSample2LabelParts = new LabelParts();
            //menuSample3LabelParts = new LabelParts();

            sample1ForeColorButtonParts = new ButtonParts();
            sample1BackColorButtonParts = new ButtonParts();
            //sample2ForeColorButtonParts = new ButtonParts();
            sample2BackColorButtonParts = new ButtonParts();
            //sample3ForeColorButtonParts = new ButtonParts();
            //sample3BackColorButtonParts = new ButtonParts();

            resetButtonParts = new ButtonParts();


            menuGBoxParts.Location = new Point(10, 10);
            menuGBoxParts.Size = new Size(optionTabMain.optionFormParts.ClientSize.Width - 24, 105);
            menuGBoxParts.SetFont(optionTabMain.fontName, scaledFloat);
            menuGBoxParts.Text = "メニュー";

            menuSample1LabelParts.Location = new Point(20, 30);
            menuSample1LabelParts.Size = new Size(200, 30);
            menuSample1LabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            menuSample1LabelParts.Text = "通常の背景色と文字色";
            menuSample1LabelParts.BackColor = SystemColors.Control;
            menuSample1LabelParts.ForeColor = SystemColors.WindowText;
            menuSample1LabelParts.Set_BorderStyle_FixedSingle();

            menuSample2LabelParts.Location = new Point(20, 60);
            menuSample2LabelParts.Size = new Size(200, 30);
            menuSample2LabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            //menuSample2LabelParts.Text = "選択時の背景色";
            menuSample2LabelParts.BackColor = SystemColors.Control;
            menuSample2LabelParts.ForeColor = SystemColors.WindowText;
            menuSample2LabelParts.Set_BorderStyle_FixedSingle();

            ////menuSample3LabelParts.Location = new Point(20, 90);
            //menuSample3LabelParts.Size = new Size(200, 30);
            //menuSample3LabelParts.SetFont(optionTabMain.fontName, scaledFloat);
            //menuSample3LabelParts.Text = "使用不可のメニューの文字色";
            //menuSample3LabelParts.BackColor = SystemColors.Control;
            //menuSample3LabelParts.ForeColor = SystemColors.WindowText;
            //menuSample3LabelParts.Set_BorderStyle_FixedSingle();

            sample1ForeColorButtonParts.Location = new Point(230, 30);
            sample1ForeColorButtonParts.Size = new Size(60, 25);
            sample1ForeColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            sample1ForeColorButtonParts.Text = "文字色";

            sample1BackColorButtonParts.Location = new Point(300, 30);
            sample1BackColorButtonParts.Size = new Size(60, 25);
            sample1BackColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            sample1BackColorButtonParts.Text = "背景色";

            //sample2ForeColorButtonParts.Location = new Point(230, 60);
            //sample2ForeColorButtonParts.Size = new Size(60, 25);
            //sample2ForeColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            //sample2ForeColorButtonParts.Text = "文字色";

            sample2BackColorButtonParts.Location = new Point(230, 60);
            sample2BackColorButtonParts.Size = new Size(110, 25);
            sample2BackColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            sample2BackColorButtonParts.Text = "選択時の背景色";

            //sample3ForeColorButtonParts.Location = new Point(230, 90);
            //sample3ForeColorButtonParts.Size = new Size(60, 25);
            //sample3ForeColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            //sample3ForeColorButtonParts.Text = "文字色";

            //sample3BackColorButtonParts.Location = new Point(300, 90);
            //sample3BackColorButtonParts.Size = new Size(60, 25);
            //sample3BackColorButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            //sample3BackColorButtonParts.Text = "背景色";

            resetButtonParts.Location = new Point(optionTabMain.optionFormParts.ClientSize.Width - 130, 30);
            resetButtonParts.Size = new Size(100, 25);
            resetButtonParts.SetFont(optionTabMain.fontName, scaledFloat);
            resetButtonParts.Text = "元に戻す";

            this.optionTabMain.outWardMap.tabPageParts.AddControl(menuGBoxParts);
            menuGBoxParts.AddControl(menuSample1LabelParts);
            menuGBoxParts.AddControl(menuSample2LabelParts);
            //menuGBoxParts.AddControl(menuSample3LabelParts);

            menuGBoxParts.AddControl(sample1ForeColorButtonParts);
            menuGBoxParts.AddControl(sample1BackColorButtonParts);
            //menuGBoxParts.AddControl(sample2ForeColorButtonParts);
            menuGBoxParts.AddControl(sample2BackColorButtonParts);
            //menuGBoxParts.AddControl(sample3ForeColorButtonParts);

            menuGBoxParts.AddControl(resetButtonParts);
            //menuGBoxParts.AddControl(sample3BackColorButtonParts);
            
            this.GetXMLData();
            this.SetEvent();
        }

        public void SetDataToGUI()
        {
            this.ResetEvent();

            this.menuSample1LabelParts.ForeColor = Color.FromArgb(
                this.menuSample1ForeColorRed,
                this.menuSample1ForeColorGreen,
                this.menuSample1ForeColorBlue);

            this.menuSample1LabelParts.BackColor = Color.FromArgb(
                this.menuSample1BackColorRed,
                this.menuSample1BackColorGreen,
                this.menuSample1BackColorBlue);

            this.menuSample2LabelParts.ForeColor = Color.FromArgb(
                this.menuSample2ForeColorRed,
                this.menuSample2ForeColorGreen,
                this.menuSample2ForeColorBlue);

            this.menuSample2LabelParts.BackColor = Color.FromArgb(
                this.menuSample2BackColorRed,
                this.menuSample2BackColorGreen,
                this.menuSample2BackColorBlue);

            /*this.menuSample3LabelParts.ForeColor = Color.FromArgb(
                this.menuSample3ForeColorRed,
                this.menuSample3ForeColorGreen,
                this.menuSample3ForeColorBlue);

            this.menuSample3LabelParts.BackColor = Color.FromArgb(
                this.menuSample3BackColorRed,
                this.menuSample3BackColorGreen,
                this.menuSample3BackColorBlue);*/

            this.SetEvent();

        }
    }
}