//CZXAgeOntH_LISENCEtH_QƂĂ
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text;
using System.Net;
using System.IO;
using System.Threading;
using System.IO.Compression;
namespace nispi
{
    partial class DownloadDatKako
    {
        public string httpResData;

        //public MemoryStream httpResRawData;
        public int httpResRawDataLength;

        private ManualResetEvent allDone;
        private int type;
        private string datUrl;

        public string command = "";

        //private string dir;
        //private string datFileName;

        const int BUFFER_SIZE = 4096;

        public DownloadDatKako()
        {
            httpResData = "";
        }

        public void DownloadDatData(ref string responseStatusCode, ref string command, string accessUrl)
        {
            this.type = Util.BoardType(accessUrl);
            this.datUrl = accessUrl;

            allDone = new ManualResetEvent(false);

            Uri u = new Uri(accessUrl);

            HttpWebRequest req = (HttpWebRequest)WebRequest.Create(u);
            req.KeepAlive = false;
            req.ProtocolVersion = HttpVersion.Version11;
            req.Method = "GET";

            //[U[G[WFg
            if (Const.opt.otherOption.UserAgent.Length > 0)
                req.UserAgent = Const.opt.otherOption.UserAgent;
            else
                req.UserAgent = Const.USER_AGENT;

            req.AutomaticDecompression = DecompressionMethods.GZip;
            req.Timeout = 10000;

            //vNV
            if ((Const.opt.otherOption.IsProxyUse.Equals("True") == true) &&
                (Const.opt.otherOption.ProxyAddress.Equals("none") == false) &&
                (Const.opt.otherOption.ProxyAddress.Length > 0))
            {
                WebProxy proxy = new WebProxy(
                    "http://" + Const.opt.otherOption.ProxyAddress + ":" +
                    Const.opt.otherOption.ProxyPort);
                req.Proxy = proxy;
            }
            else
                req.Proxy = null;

            RequestState myRequestState = new RequestState();
            myRequestState.request = req;


            // Start the asynchronous request.
            IAsyncResult result =
              (IAsyncResult)req.BeginGetResponse(new AsyncCallback(RespCallback), myRequestState);

            allDone.WaitOne();

            //̓擾
            command = myRequestState.command;
            //G[̐擾
            responseStatusCode = myRequestState.responseStatusCode;

            if (myRequestState.responseStatusCode.StartsWith("20") == true)
            {
                ;
            }
            else
            {
                try
                {
                    myRequestState.response.Close();
                }
                catch { ;}
                return;
            }

            //--Mf[^
            if ((httpResData == null) || (httpResData.Length < 1))
            {
                try
                {
                    myRequestState.response.Close();
                }
                catch { ;}
                return;
            }

            string dir = Util.DatUrlToDatDirPath(this.datUrl);
            string dat_file_name = Util.DatUrlToDatFileName(this.datUrl);

            Downloader.save(dir, dat_file_name, httpResData);

            myRequestState.response.Close();
            return;
        }


        private void RespCallback(IAsyncResult asynchronousResult)
        {
            try
            {
                RequestState myRequestState = (RequestState)asynchronousResult.AsyncState;
                HttpWebRequest myHttpWebRequest = myRequestState.request;
                //l吙̎̏
                if (true == myHttpWebRequest.Address.AbsoluteUri.Equals("http://www2.2ch.net/live.html"))
                {
                    myRequestState.responseStatusCode = "996";
                    myRequestState.command = "I";
                    allDone.Set();
                    return;
                }
                try
                {
                    myRequestState.response = (HttpWebResponse)myHttpWebRequest.EndGetResponse(asynchronousResult);

                    //G[łȂnjƂẴAhXɓ]BiqbgFߋOqɓ̂c`sɃANZXAj
                    if (myRequestState.response.ResponseUri.AbsoluteUri.Equals("http://www2.2ch.net/nogood.html") == true)
                    {
                        myRequestState.responseStatusCode = "996";
                        myRequestState.command = "I";
                        allDone.Set();
                        return;
                    }
                    //l吙̎̏
                    if (true == myHttpWebRequest.Address.AbsoluteUri.Equals("http://www2.2ch.net/live.html"))
                    {
                        myRequestState.responseStatusCode = "997";
                        myRequestState.command = "I";
                        allDone.Set();
                        return;
                    }

                    if (myRequestState.response.StatusCode == HttpStatusCode.OK)
                    {
                        myRequestState.responseStatusCode = "200";
                        myRequestState.command = "I";
                    }
                }
                catch (System.Net.WebException e)
                {
                    if (e.Response.ResponseUri.AbsoluteUri.Equals("http://www2.2ch.net/nogood.html") == true)
                    {
                        //̂G[ɔB̃AhXȂƂ肠I
                        myRequestState.responseStatusCode = "996";
                        myRequestState.command = "I";
                        allDone.Set();
                        return;
                    }

                    else if (e.Message.Contains("302") == true)
                    {
                        //Ȃ

                        //Locationă{{K`FbNB
                        /*
                         * Xe[^X302łĂAwb_Location
                         * http://*.2ch.net/_403/http://www2.2ch.net/403/
                         * o[{KE{{KƂďĉB
                         * http://www.monazilla.org/index.php?e=198
                         */
                        if (((e.Response.Headers[HttpResponseHeader.Location].Contains("2ch.net/_403/") == true) ||
                            (e.Response.Headers[HttpResponseHeader.Location].Contains("2ch.net/403/") == true)))
                        {
                            myRequestState.responseStatusCode = "403";
                            myRequestState.command = "I";
                        }
                        else
                        {
                            myRequestState.responseStatusCode = "302";
                            myRequestState.command = "ߋOA";
                        }
                        allDone.Set();
                        return;
                    }
                    else if (e.Message.Contains("403") == true)
                    {
                        //ڂڂK
                        myRequestState.responseStatusCode = "403";
                        myRequestState.command = "I";
                        allDone.Set();
                        return;
                    }
                    else if (e.Message.Contains("404") == true)
                    {
                        //Ȃ
                        myRequestState.responseStatusCode = "404";
                        myRequestState.command = "ߋOA";
                        allDone.Set();
                        return;
                    }
                    else
                    {
                        //ȊȌꍇ
                        myRequestState.responseStatusCode = "999";
                        myRequestState.command = "I";
                        Const.debugForm.OutPutDebug("Other", e);
                        return;
                    }
                }
                catch
                {
                    //VKf[^ɃG[A邱Ƃ
                    myRequestState.responseStatusCode = "998";
                    myRequestState.command = "I";
                    allDone.Set();
                    return;
                }
                Stream responseStream = myRequestState.response.GetResponseStream();
                myRequestState.streamResponse = responseStream;
                Stream st = myRequestState.streamResponse;
                try
                {
                    //ǂݍł܂{ǂݍ
                    //oCif[^
                    byte[] array = ReadBinaryData(st);
                    myRequestState.memoryStream.Write(array, myRequestState.offset, array.Length);
                    myRequestState.offset += array.Length;
                }
                catch { ;}

                IAsyncResult asynchronousInputRead = responseStream.BeginRead(myRequestState.BufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack), myRequestState);
                return;
            }
            catch
            { ;}
        }

        private void ReadCallBack(IAsyncResult asyncResult)
        {
            RequestState myRequestState = (RequestState)asyncResult.AsyncState;
            Stream st = myRequestState.streamResponse;

            byte[] array;
            try
            {
                //oCif[^
                array = ReadBinaryData(st);
                myRequestState.memoryStream.Write(array, myRequestState.offset, array.Length);
                myRequestState.offset += array.Length;

                if (array.Length > 0)
                {
                    try
                    {
                        IAsyncResult asynchronousResult = st.BeginRead(myRequestState.BufferRead, 0, BUFFER_SIZE, new AsyncCallback(ReadCallBack), myRequestState);
                        st.Close();
                        return;
                    }
                    catch { ;}
                }
            }
            catch { ;}

            if (myRequestState.offset > 1)
            {
                //oCif[^
                GZipStream gzip = new GZipStream(myRequestState.memoryStream, CompressionMode.Decompress);
                MemoryStream ms = new MemoryStream();
                //gzip.CopyTo(ms);

                var buffer = new byte[1024];

                for (;;)
                {
                    var len = gzip.Read(buffer, 0, buffer.Length);

                    if (len == 0)
                        break;

                    ms.Write(buffer, 0, len);
                }


                //f[^
                //this.httpResData = myRequestState.responseData.ToString();

                if (Util.TYPE_JBBS == type)
                {
                    this.httpResRawDataLength = (int)ms.Length;
                    this.httpResData = System.Text.Encoding.GetEncoding("EUC-JP").GetString(ms.ToArray());
                }
                /*else if (Util.TYPE_OPEN2CH == type)
                {
                    this.httpResRawDataLength = (int)ms.Length;
                    this.httpResData = System.Text.Encoding.UTF8.GetString(ms.ToArray());
                }*/
                else
                {
                    this.httpResRawDataLength = (int)ms.Length;
                    this.httpResData = System.Text.Encoding.GetEncoding(932).GetString(ms.ToArray());
                }

                ms.Dispose();
            }

            myRequestState.streamResponse.Close();
            //myRequestState.response.Close();
            st.Close();

            allDone.Set();
        }


        //Xg[f[^ǂݍ݁AoCgzɊi[
        //QlɂĂTCgFhttp://www.atmarkit.co.jp/fdotnet/dotnettips/985memstream/memstream.html
        static public byte[] ReadBinaryData(Stream st)
        {
            byte[] buf = new byte[32768]; // ꎞobt@

            using (MemoryStream ms = new MemoryStream())
            {

                while (true)
                {
                    // Xg[ꎞobt@ɓǂݍ
                    int read = st.Read(buf, 0, buf.Length);

                    if (read > 0)
                    {
                        // ꎞobt@̓eEXg[ɏ
                        ms.Write(buf, 0, read);
                    }
                    else
                    {
                        break;
                    }
                }
                // EXg[̓eoCgzɊi[
                return ms.ToArray();
            }
        }
    }
}