﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;
using System.IO;

using nispi.controlclass;
using nispi.OptionControl;

//参考にさせていただいたサイト
//http://dobon.net/vb/dotnet/form/openfiledialog.html
//http://dobon.net/vb/dotnet/form/colordialog.html
//

namespace nispi
{
    class FormGUI
    {
        //ディレクトリ選択用のダイアログを表示させる
        public static string GetTargetDirectory(FormParts parts, string currentDir)
        {
            using (FolderBrowserDialog fbd = new FolderBrowserDialog())
            {

                //上部に表示する説明テキストを指定する
                fbd.Description = "辞書のフォルダを指定してください";

                //fbd.RootFolder = FileIO.Get
                fbd.SelectedPath = currentDir;// +Path.DirectorySeparatorChar;
                fbd.ShowNewFolderButton = true;

                //ダイアログを表示する
                if (fbd.ShowDialog(parts.control) == DialogResult.OK)
                {
                    string path = fbd.SelectedPath;
                    return path;
                }
                return "";
            }
        }
        //ファイル用のダイアログを表示させる
        public static string GetTargetFile(FormParts parts)
        {
            using (OpenFileDialog ofd = new OpenFileDialog())
            {
                ofd.Multiselect = false;
                //ダイアログを表示する
                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    return ofd.FileName;
                }
                return "";
            }
        }
        //ファイル用のダイアログを表示させる
        public static string GetTargetFile()
        {
            using (OpenFileDialog ofd = new OpenFileDialog())
            {
                ofd.Multiselect = false;
                //ダイアログを表示する
                if (ofd.ShowDialog() == DialogResult.OK)
                {
                    return ofd.FileName;
                }
                return "";
            }
        }
        //エクスプローラでフォルダを開く
        public static void OpenTargetFolder(string folder)
        {
            string command = "/n, " + folder;
            System.Diagnostics.Process.Start(
                "EXPLORER.EXE", folder);
        }
        public static void OpenTargetFolder2(string folder)
        {
            System.Diagnostics.Process.Start(folder);
        }
        public static bool GetFontData(FormFontSet formFontSet,string fontName, float fontSize, Color color)
        {
            using (FontDialog fd = new FontDialog())
            {

                //初期のフォントを設定
                fd.Font = new Font(fontName, fontSize);
                //初期の色を設定
                fd.Color = color;
                //ユーザーが選択できるポイントサイズの最大値を設定する
                fd.MaxSize = 20;
                fd.MinSize = 8;
                //存在しないフォントやスタイルをユーザーが選択すると
                //エラーメッセージを表示する
                fd.FontMustExist = true;
                //横書きフォントだけを表示する
                fd.AllowVerticalFonts = false;
                //色を選択できるようにする
                fd.ShowColor = true;
                //取り消し線、下線、テキストの色などのオプションを指定可能にする
                //デフォルトがTrueのため必要はない
                fd.ShowEffects = true;
                //ベクタ フォント
                fd.AllowVectorFonts = false;

                //ダイアログを表示する
                if (fd.ShowDialog() != DialogResult.Cancel)
                {
                    formFontSet.formFontName = fd.Font.Name.ToString();
                    formFontSet.formFontSize = fd.Font.Size;

                    formFontSet.formForeColorRed = fd.Color.R;
                    formFontSet.formForeColorGreen = fd.Color.G;
                    formFontSet.formForeColorBlue = fd.Color.B;
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }
        public static bool GetColor(ColorSet colorSet)
        {
            //ColorDialogクラスのインスタンスを作成
            using (ColorDialog cd = new ColorDialog())
            {
                //はじめに選択されている色を設定
                cd.Color = Color.LightGray; ;
                //色の作成部分を表示可能にする
                //デフォルトがTrueのため必要はない
                cd.AllowFullOpen = true;
                //純色だけに制限しない
                //デフォルトがFalseのため必要はない
                cd.SolidColorOnly = false;

                //ダイアログを表示する
                if (cd.ShowDialog() == DialogResult.OK)
                {
                    colorSet.red = cd.Color.R;
                    colorSet.green = cd.Color.G;
                    colorSet.blue = cd.Color.B;

                    return true;
                }
                else
                    return false;
            }
        }
    }
}