//CZXAgeOntH_LISENCEtH_QƂĂ
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Drawing;
using System.Diagnostics;

using MecInfoDll;

namespace nispi.Analysis
{
    class AnalysisLink
    {
        public AnalysisLinkControls analysisLinkControls;

        public List<AnalysisLinkList> analysisLinkList;
        DatInfo dat;
        public static bool Visible = false;
        public AnalysisLink()
        {
            analysisLinkControls = new AnalysisLinkControls(this);
            Visible = true;
        }
        public void Open(DatInfo dat)
        {
            try
            {
                this.dat = dat;
                analysisLinkList = new List<AnalysisLinkList>();
                GetLinkHtmlListFromDat(dat);
                WriteLinkListFromDat("Link");
            }
            catch { ;}
        }

        public void WriteLinkListFromDat(string type)
        {
            System.Text.StringBuilder sb = new System.Text.StringBuilder();

            sb.Append("<html><head><style type=\"text/css\">");

            /*string cssHeader = string.Format(
                "body {{ font-size: {0}pt;color:#{1};background-color:#{2};font-family:'{3}';}}",
                Const.opt.outWardBrowser.BrowserFontSize,
                "black",
                Const.opt.outWardBrowser.BrowserBackColor,
                Const.opt.outWardBrowser.BrowserFontName);*/
            string cssHeader = "";
            if (Const.opt.outWardBrowser.BrowserFontType.Equals("installed") == true)
            {
                cssHeader = string.Format(
                    "body {{ font-size: {0}pt;color:#{1};background-color:#{2};font-family:'{3}';}}",
                    Const.opt.outWardBrowser.BrowserFontSize,
                    Const.opt.outWardBrowser.BrowserForeColor,
                    Const.opt.outWardBrowser.BrowserBackColor,
                    Const.opt.outWardBrowser.BrowserFontName);
            }
            else
            {
                cssHeader = string.Format(
                    "body {{ font-size: {0}pt;color:#{1};background-color:#{2};font-family:'{3}';src: url(\"file:///{4}\");}}",
                    Const.opt.outWardBrowser.BrowserOriginalFontSize,
                    Const.opt.outWardBrowser.BrowserForeColor,
                    Const.opt.outWardBrowser.BrowserBackColor,
                    Const.opt.outWardBrowser.BrowserOriginalFontName,
                    Const.opt.outWardBrowser.BrowserOriginalFontPath);
            }

            sb.Append(cssHeader);

            sb.Append(Const.Default_Style_Sheet);
            sb.Append("</style>");
            sb.Append("</head>");
            string htmlHeader = string.Format("<body link='#{0}' vlink='#{1}'>",
                Const.opt.outWardBrowser.BrowserLinkColor,
                Const.opt.outWardBrowser.BrowserLinkedColor);

            sb.Append(htmlHeader);

            sb.Append(string.Format("{0}: {1}<br><br>\r\n", analysisLinkList.Count, dat.thread_name));

            foreach (AnalysisLinkList ail in analysisLinkList)
            {
                sb.Append(string.Format(
                    "<div class='res_title'>[<a name='res{0}' href='javascript:void(0);#res{0}#{1}'>&gt;&gt;{0}</a>]@", ail.num,dat.dat_url));

                if (type.CompareTo("Link") == 0)
                    sb.Append(string.Format("<a href='javascript:void(0);h{0}' >h{0}</a><br>\r\n", ail.imageAddress));

                sb.Append("</div>");
            }
            sb.Append("</div><body></html>");

            analysisLinkControls.browserParts.BrowserClear();
            
            analysisLinkControls.browserParts.Write(sb.ToString());
            analysisLinkControls.browserParts.AllowNavigation = false;
        }

        public void GetLinkHtmlListFromDat(DatInfo dat)
        {
            Regex addressRegex = new Regex("t?tp://([-_.!~*\'()a-zA-Z0-9;/?:@&=+$$,%#]+)");

            foreach (Comment comment in dat.comments)
            {
                MatchCollection addressMC = addressRegex.Matches(comment.body);

                if (addressMC.Count > 0)
                {
                    for (int num = 0; addressMC.Count > num; num++)
                    {
                        if (addressMC[num].Success == true)
                        {
                            if (
                                ((addressMC[num].Groups[0].Value.LastIndexOf(".jpg", StringComparison.OrdinalIgnoreCase)) > 0) ||
                                ((addressMC[num].Groups[0].Value.LastIndexOf(".jpeg", StringComparison.OrdinalIgnoreCase)) > 0) ||
                                ((addressMC[num].Groups[0].Value.LastIndexOf(".png", StringComparison.OrdinalIgnoreCase)) > 0) ||
                                ((addressMC[num].Groups[0].Value.LastIndexOf(".gif", StringComparison.OrdinalIgnoreCase)) > 0) ||
                                ((addressMC[num].Groups[0].Value.LastIndexOf(".bmp", StringComparison.OrdinalIgnoreCase)) > 0))                                 continue;
                            analysisLinkList.Add(new AnalysisLinkList(addressMC[num].Groups[0].Value, comment.num));
                        }
                    }
                }
            }
        }
        public string CapText(Match m)
        {
            return m.Value.ToString();
        }
        public void Cloose()
        {
            try
            {
                this.analysisLinkList.Clear();
            }
            catch { ;}
            try
            {
                this.analysisLinkControls.RemoveControls();

                this.analysisLinkList = null;
            }
            catch { ;}

            Visible = false;
        }
    }

    class AnalysisLinkList
    {
        public string imageAddress;
        public string num;

        public AnalysisLinkList(string text, string num)
        {
            imageAddress = text;
            this.num = num;
        }
    }
}
