﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;

using nispi.controlclass;

namespace nispi.Analysis
{
    class AnalysisMecabControls
    {
        public FormParts amFormParts;
        public BrowserParts browserParts;

        public AnalysisMecab analysisMecabView;

        AnalysisMecabControlsEvent analysisMecabControlsEvent;

        public AnalysisMecabControls(AnalysisMecab analysisMecabView)
        {
            this.analysisMecabView = analysisMecabView;

            amFormParts = FormPartsManager.Pop();
            amFormParts.Text = "単語抽出...(解析中)";
            amFormParts.Name = "isPopUp";
            //aiFormParts.control.SuspendLayout();
            amFormParts.Show();

           //amFormParts.control.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
            //サイズを決定
            amFormParts.Size = new Size(Const.form.mainForm.Size.Width/2, Const.form.mainForm.Size.Height/2);//Const.form.boardListTabControlParts.Size;

            if (MainFormConst.formShowStyle.NOW_TYPE.Equals("TYPE1") == true)
            {
                /*amFormParts.Location = new Point(System.Windows.Forms.Cursor.Position.X - (amFormParts.Size.Width / 2),
                    System.Windows.Forms.Cursor.Position.Y - amFormParts.Size.Height - 5);*/
                amFormParts.Location = Const.form.boardListTabControlParts.PointToScreen();
            }
            else if (MainFormConst.formShowStyle.NOW_TYPE.Equals("TYPE2") == true)
            {
                /*amFormParts.Location = new Point(System.Windows.Forms.Cursor.Position.X - (amFormParts.Size.Width),
                    System.Windows.Forms.Cursor.Position.Y + 5);*/
                amFormParts.Location = Const.form.boardIndexTabControlParts.PointToScreen();
            }

            amFormParts.Owner = Const.form.mainForm.GetControl();

            browserParts = BrowserCtrlManager.Pop();
            browserParts.ownerForm = amFormParts;
            browserParts.nonTextMenuOn = false;
            browserParts.textMenuOn = false;
            browserParts.Location = new Point(1, 1);
            browserParts.Size = new Size(Const.form.mainForm.Size.Width / 2 - Scale.GetBrowserControlMinusSize().Width,
                Const.form.mainForm.Size.Height / 2 - Scale.GetBrowserControlMinusSize().Height);
            browserParts.Name = "AnalysisMecab";

            amFormParts.AddControl(browserParts);

            analysisMecabControlsEvent = new AnalysisMecabControlsEvent(this.analysisMecabView, this);
        }

        public void RemoveControls()
        {
            //タブに登録されているコントロールを全削除            
            analysisMecabControlsEvent.RemoveEvent();
            
            amFormParts.RemoveAllCtrl();

            amFormParts.Name = "";

            amFormParts.Hide();
            
            //コントロールを元に戻す
            FormPartsManager.Push(amFormParts);

            BrowserCtrlManager.Push(browserParts);
        }
    }
}
