﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading;
using System.Drawing;
using System.Diagnostics;
using System.IO;
using System.Linq;
//using System.Threading.Tasks;

using MecInfoDll;
using nispi.controlclass;

namespace nispi
{
   class Crawler
    {
        public static bool Visible;

        public bool stoppingBool;
        static Mutex mutex = new Mutex(true, "Crawler");

        public Crawler()
        {
            stoppingBool = false;
        }

        public void Open()
        {
            try
            {
                DownLoad();
            }
            catch (System.Exception ex)
            {
                //Const.debugForm.OutPutDebug("Analysis", ex);
            }
        }
        public void StopDownloading()
        {
            mutex.WaitOne();
            this.stoppingBool = true;
            mutex.ReleaseMutex();
        }
        public bool StoppingTest()
        {
            mutex.WaitOne();
            if (this.stoppingBool == true)
            {
                mutex.ReleaseMutex();
                return true;
            }
            else
            {
                mutex.ReleaseMutex();
                return false;
            }
        }
        public void DownLoad()
        {
            stoppingBool = false;
            List<ThreadData> threadDataList = MainFormConst.boardListTabMain.favoriteBoardView.threadInfo.threadDataList;

            if (threadDataList.Count > 0)
            {
                List<string> downloadedList = new List<string>();

                ProgressBarForm progressBarForm = new ProgressBarForm(new ProgressBarForm.SimpleMethod(StopDownloading));
                Thread t = new Thread(new ThreadStart(progressBarForm.SetUpTwo));
                t.IsBackground = true;
                t.Start();

                try
                {
                    int num = 0;


                    Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Maximum = threadDataList.Count));
                    string progressText = "";
                    int max = threadDataList.Count;


                    foreach (ThreadData threadData in threadDataList)
                    {
                        num += 1;

                        Debug.WriteLine(threadData.title + " ; " + threadData.datUrl);

                        DatInfo dat = new DatInfo(threadData.datUrl);

                        dat.Load();

                        if ((dat.thread_name == null) || (dat.thread_name.Length == 0))
                            continue;

                        threadData.resNum = dat.comments.Count.ToString();
                        threadData.noReadNum = (Int32.Parse(threadData.resNum) - Int32.Parse(threadData.readNum)).ToString();

                        progressText = string.Format("{0}/{1} 受信中です", num, max);
                        Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = progressText));
                        Const.form.mainForm.Invoke((Action)(() => progressBarForm.progressBar.Value = num));

                        if (StoppingTest() == true)
                            break;
                    }
                }
                catch
                { ;}

                Const.form.mainForm.Invoke((Action)(() => progressBarForm.textLabel.Text = "終了しました"));
                Thread.Sleep(750);
                //プログレスバーを閉じる         
                progressBarForm.popUp.Invoke((Action)(() => progressBarForm.Closing()));

                MainFormConst.boardListTabMain.favoriteBoardView.WriteLogFile(threadDataList);
                MainFormConst.boardListTabMain.favoriteBoardView.reload();
            }
        }
      
        public void Cloose()
        {
            Visible = false;
        }
    }
}