//CZXAgeOntH_LISENCEtH_QƂĂ

using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;

namespace nispi
{
    [Serializable]
    class ThreadData
    {
        //Qł̃X̏
        public string orderNum;
        //dat̃AhX
        public string datUrl;
        //Xbh̃^Cg
        public string title;
        //Xbh쐬ꂽtmhw
        public string openTime;
        //Xbh쐬ꂽ
        public string openTimeString;
        //VvȃXbh쐬ꂽ
        public string simpleOpenTimeString;
        //X̐
        public string resNum;
        //ǂ񂾃X̐
        public string readNum;
        //ǂ̃X̐
        public string noReadNum;
        //x
        public string speed;
        //ŏIXV
        public string nowUnixTime;
        //̃f[^Ăt@C
        public string fileName;
        //̓{ꖼ
        public string boardName;
        //VXbhۂ
        public bool newThread;

        public string OpenTimeString
        {
            set
            {
                this.openTimeString = value;
                string[] dateArray = this.openTimeString.Split(' ');

                this.simpleOpenTimeString = dateArray[0].Substring(2) + ' ' +  dateArray[1].Split(':')[0] + ':' + dateArray[1].Split(':')[1];
            }
        }
        public ThreadData()
        {
        }
    }
    [Serializable]
    class ThreadInfo
    {
        public List<ThreadData> threadDataList;

        public ThreadInfo()
        {
            threadDataList = new List<ThreadData>();
        }

        //N[쐻ŎQlɎgpTCgFhttp://smdn.jp/programming/netfx/cloning/
        public T CloneObject<T>(T source)
        {
            // oCiVACYɂsource̕쐬
            using (MemoryStream stream = new MemoryStream())
            {
                BinaryFormatter f = new BinaryFormatter();

                f.Serialize(stream, source);

                stream.Position = 0L;

                return (T)f.Deserialize(stream);
            }
        }

        public void AddList()
        {
            ThreadData threadData = new ThreadData();

            threadData.orderNum = "";
            threadData.datUrl = "";
            threadData.title = "";
            threadData.resNum = "";
            threadData.readNum = "";
            threadData.noReadNum = "";
            threadData.openTime = "";
            threadData.speed = "";
            threadData.fileName = "";
            threadData.boardName = "";

            threadDataList.Add(threadData);
        }

        public void AddList(List<ThreadData> threadData)
        {
            threadDataList = threadDataList.Concat(threadData).ToList();
        }
        //2ch̃Ot@C
        public void AddList(string orderNum, string datUrl, string title, string resNum, string openTime)
        {
            ThreadData threadData = new ThreadData();

            threadData.orderNum = orderNum;
            threadData.datUrl = datUrl;
            threadData.title = title;
            threadData.resNum = resNum;
            threadData.readNum = "0";
            threadData.noReadNum = "0";
            threadData.openTime = openTime;

            DateTime dtOpentime = UnixTime.GetDateTime(openTime);
            threadData.OpenTimeString = dtOpentime.ToString();

            DateTime dt = DateTime.UtcNow;
            double nowUnixTime = UnixTime.GetUnixTime(dt);
            threadData.nowUnixTime = nowUnixTime.ToString();

            double speed = (nowUnixTime - double.Parse(openTime)) / 86400.0;
            threadData.speed = Convert.ToString(Math.Truncate(speed * 100.0) / 100.0);

            string boardUrl = Util.DatUrlToBoardUrl(datUrl);
            threadData.boardName = BoardDataBase.GetName(boardUrl);
            
            threadDataList.Add(threadData);
        }
        //2ch̃Ot@C̏t@C
        /*public void AddList(string orderNum, string datUrl, string title, string resNum,
            string readNum, string openTime, string openTimeDateTime, string nowUnixTime, string speed, string fileName)
        {
            ThreadData threadData = new ThreadData();
            
            threadData.orderNum = orderNum;
            threadData.datUrl = datUrl;
            threadData.title = title;
            threadData.resNum = resNum;
            threadData.readNum = readNum;
            threadData.noReadNum = (Int32.Parse(resNum) - Int32.Parse(readNum)).ToString();
            threadData.openTime = openTime;
            threadData.nowUnixTime = nowUnixTime;
            threadData.OpenTimeString = openTimeDateTime;
            threadData.speed = speed;
            threadData.fileName = fileName;
            string boardUrl = Util.DatUrlToBoardUrl(datUrl);
            threadData.boardName = BoardDataBase.GetName(boardUrl);
            
            threadDataList.Add(threadData);
        }*/
        //2ch̃Ot@C̏t@C
        public void AddList(string orderNum, string datUrl, string title, string resNum,
            string readNum, string openTime, string openTimeDateTime, string nowUnixTime, string speed, string fileName,string boardName)
        {
            ThreadData threadData = new ThreadData();

            threadData.orderNum = orderNum;
            threadData.datUrl = datUrl;
            threadData.title = title;
            threadData.resNum = resNum;
            threadData.readNum = readNum;
            threadData.noReadNum = (Int32.Parse(resNum) - Int32.Parse(readNum)).ToString();
            threadData.openTime = openTime;
            threadData.nowUnixTime = nowUnixTime;
            threadData.OpenTimeString = openTimeDateTime;
            threadData.speed = speed;
            threadData.fileName = fileName;
            string boardUrl = Util.DatUrlToBoardUrl(datUrl);
            threadData.boardName = boardName;

            threadDataList.Add(threadData);
        }
        public void AddList(string datUrl, string title, string resNum)
        {
            ThreadData threadData = new ThreadData();

            threadData.orderNum = "0";
            threadData.datUrl = datUrl;
            threadData.title = title;
            threadData.resNum = resNum;
            threadData.readNum = "0";
            threadData.noReadNum = "0";

            try
            {
                string temp = datUrl.Substring(datUrl.LastIndexOf('/') + 1);
                threadData.openTime = temp.Substring(0, temp.LastIndexOf('.'));
            }
            catch
            {
                threadData.openTime = "0";
            }

            DateTime dtOpentime = UnixTime.GetDateTime(threadData.openTime);
            threadData.OpenTimeString = dtOpentime.ToString();

            DateTime dt = DateTime.UtcNow;
            double nowUnixTime = UnixTime.GetUnixTime(dt);

            double speed = (nowUnixTime - double.Parse(threadData.openTime)) / 86400.0;
            threadData.speed = Convert.ToString(Math.Truncate(speed * 100.0) / 100.0);

            string boardUrl = Util.DatUrlToBoardUrl(datUrl);
            threadData.boardName = BoardDataBase.GetName(boardUrl);

            threadDataList.Add(threadData);
        }
    }


    //Qltqk
    //http://www.atmarkit.co.jp/fdotnet/dotnettips/980unixtime/unixtime.html
    class UnixTime
    {
        // UNIXG|bN\DateTimeIuWFNg擾
        public static DateTime UNIX_EPOCH = new DateTime(1970, 1, 1, 0, 0, 0, 0);

        //݂UNIXԂ𓾂i{ԕϊAj
        public static double GetUnixTime(DateTime targetTime)
        {
            // UNIXG|bŇoߎԂ擾
            TimeSpan elapsedTime = targetTime - UNIX_EPOCH;
            TimeSpan jpTime = new TimeSpan(9, 0, 0);
            elapsedTime += jpTime;
            // oߕbɕϊ
            return (double)elapsedTime.TotalSeconds;
        }

        //݂DateTime`̎Ԃ𓾂i{ԕϊAj
        public static DateTime GetDateTime(string unixTime)
        {
            double longUnixTime = double.Parse(unixTime);
            TimeSpan jpTime = new TimeSpan(9, 0, 0);
            double tempTime = Math.Round((double)jpTime.TotalSeconds, MidpointRounding.AwayFromZero);
            return UNIX_EPOCH.AddSeconds(longUnixTime + tempTime);
        }

        //݂UNIXԂ𓾂i{ԕϊj
        public static double GetNowUnixTime(DateTime targetTime)
        {
            // UNIXG|bŇoߎԂ擾
            TimeSpan elapsedTime = targetTime - UNIX_EPOCH;
            // oߕbɕϊ
            return (double)elapsedTime.TotalSeconds;
        }

        //݂̎ԂXԉUNIXԂ𓾂i{ԕϊAj
        public static long GetUnixTimeByPlusTime(PlusTime plusTime)
        {
            // UNIXG|bŇoߎԂ擾
            TimeSpan elapsedTime = DateTime.Now - UNIX_EPOCH - new TimeSpan(9, 0, 0);
            TimeSpan plusSpan = new TimeSpan(plusTime.plusYear * 356 + plusTime.plusMonth * 31 + plusTime.plusDay, plusTime.plusHour, 0, 0);
            elapsedTime = elapsedTime - plusSpan;
            // oߕbɕϊ
            return (long)(Math.Round((double)elapsedTime.TotalSeconds, MidpointRounding.AwayFromZero));
        }

        public static string GetFileNameByPlusTime(PlusTime plusTime)
        {
            TimeSpan ts = new TimeSpan(plusTime.plusYear * 356 + plusTime.plusMonth * 31 + plusTime.plusDay, plusTime.plusHour, plusTime.plusMinute, 0);
            long longTime = ts.Ticks;
            
            DateTime dateTime = new DateTime(DateTime.Now.Ticks - longTime);

            string month = dateTime.Month.ToString();
            if (month.Length == 1) month = "0" + month;
            string day = dateTime.Day.ToString();
            if (day.Length == 1) day = "0" + day;

            return dateTime.Year.ToString() + "_" + month + "_" + day + ".txt";
        }
        public static string GetInfoFileNameByPlusTime(PlusTime plusTime)
        {
            TimeSpan ts = new TimeSpan(plusTime.plusYear * 356 + plusTime.plusMonth * 31 + plusTime.plusDay, plusTime.plusHour, plusTime.plusMinute, 0);
            long longTime = ts.Ticks;

            DateTime dateTime = new DateTime(DateTime.Now.Ticks - longTime);

            string month = dateTime.Month.ToString();
            if (month.Length == 1) month = "0" + month;
            string day = dateTime.Day.ToString();
            if (day.Length == 1) day = "0" + day;

            return dateTime.Year.ToString() + "_" + month + "_" + day + ".info.txt";
        }
        public static string GetResponseDateByPlusTime(PlusTime plusTime)
        {
            TimeSpan ts = new TimeSpan(plusTime.plusYear * 356 + plusTime.plusMonth * 31 + plusTime.plusDay, plusTime.plusHour, plusTime.plusMinute, 0);
            long longTime = ts.Ticks;

            DateTime dateTime = new DateTime(DateTime.Now.Ticks - longTime);

            string month = dateTime.Month.ToString();
            if (month.Length == 1) month = "0" + month;
            string day = dateTime.Day.ToString();
            if (day.Length == 1) day = "0" + day;
            string hour = dateTime.Hour.ToString();
            if (hour.Length == 1) hour = "0" + hour;
            string minute = dateTime.Minute.ToString();
            if (minute.Length == 1) minute = "0" + minute;
            string second = dateTime.Second.ToString();
            if (second.Length == 1) second = "0" + second;

            return dateTime.Year.ToString() + "/" + month + "/" + day + "/"
                + hour + ":" + minute + ":" + second;
        }

        public static void GetPinPointDate(string pinPointDate, ref string fromPoint, ref string toPoint)
        {
            //int pinPointYear = 0;
            //int pinPointMonth = 0;
            //int pinPointDay = 0;
            string[] data = pinPointDate.Split('_');

            // UNIXG|bŇoߎԂ擾
            DateTime dateTime = new DateTime(
                int.Parse(data[0]),
                int.Parse(data[1]),
                int.Parse(data[2]),
                0,
                0,
                0);

            TimeSpan fromTm = dateTime - UNIX_EPOCH - new TimeSpan(9, 0, 0);
            TimeSpan toTm = dateTime - UNIX_EPOCH - new TimeSpan(9, 0, 0) + new TimeSpan(24, 0, 0);

            fromPoint = ((long)(Math.Round((double)fromTm.TotalSeconds, MidpointRounding.AwayFromZero))).ToString();
            toPoint = ((long)(Math.Round((double)toTm.TotalSeconds, MidpointRounding.AwayFromZero))).ToString();
        }

        public static string ChangeDateFormat(string pinPointData)
        {
            string[] data = pinPointData.Split('_');

            if (data[1].Length == 1)
                data[1] = '0' + data[1];
            if (data[2].Length == 1)
                data[2] = '0' + data[2];

            return string.Join("_", data);
        }
    }
}