﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Diagnostics;
using System.Threading;
using System.Windows.Forms;


using nispi.controlclass;
using nispi.Menu;
using nispi.OptionControl;
using nispi.AgeOnDebuger;
using nispi.VersionCheck;

namespace nispi
{
    partial class MainForm//:Form
    {
        public FormParts mainForm;

        public StatusStripParts statusStripParts;

        public SplitContainerParts mainSplitContainerParts;
        public SplitContainerParts subMainSplitContainerParts;

        public SplitContainerParts mainSplitContainerType2Parts;
        public SplitContainerParts subMainSplitContainerType2Parts;

        public SplitContainerParts mainSplitContainerType3Parts;
        public SplitContainerParts subMainSplitContainerType3Parts;

        public TabControlParts boardIndexTabControlParts;
        public TabControlParts boardListTabControlParts;
        public TabControlParts threadListTabControlParts;

        public ToolStripParts toolStripParts;
        public ToolStripButtonParts Type1ButtonParts;
        public ToolStripButtonParts Type2ButtonParts;
        public ToolStripButtonParts Type3ButtonParts;
        public ToolStripButtonParts usefulBoardButtonParts;
        public ToolStripButtonParts usefulThreadButtonParts;
        public ToolStripButtonParts MapButtonParts;
        public ToolStripButtonParts AddressButtonParts;
        public ToolStripTextBoxParts toolStripTextBoxParts;

        public MapMainForm mapMainForm;

        public OptionMainForm optionMainForm;

        public MainFormConst mainFormConstituent;
        public MapMainFormConst mapMainFormConst;

        public static ContextMenuControls contextMenuControls;

        public FormGuiData formGuiData;

        public ImageList imageList;

        public ToolStripStatusLabel onLineToolStripStatusLabel;
        public ToolStripStatusLabel roninToolStripStatusLabel;
        public ToolStripStatusLabel be2chToolStripStatusLabel;
        public ToolStripStatusLabel beSCToolStripStatusLabel;

        public MainForm()
        {
            //IEのレジストリ設定
            WebBrowser w = new WebBrowser();
            int i = w.Version.Major;
            w.Dispose();
            try
            {
                if (System.Environment.OSVersion.Version.Major >= 10)
                {
                    Microsoft.Win32.Registry.CurrentUser.CreateSubKey(@"Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION").
                        SetValue("ageon.exe", 10001, Microsoft.Win32.RegistryValueKind.DWord);
                }
                else
                {
                    Microsoft.Win32.Registry.CurrentUser.CreateSubKey(@"Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION").
                        SetValue("ageon.exe", Convert.ToInt32(i) * 1000, Microsoft.Win32.RegistryValueKind.DWord);
                }
            }
            catch
            { ;}
            //ユーザーエージェントを変える


            //Const.debugForm = new DebugMainForm();

            Const.MainFormType1Size = new Size(1000, 800);
            Const.MainFormType2Size = new Size(1600, 800);
            Const.MainFormType3Size = new Size(1600, 800);
            Const.MapMainFormSize = new Size(1200, 800);

            //メインのディレクトリを取得
            Const.GetMainDir();

            //以前のバージョンとの整合性
            VersionCheck.VersionCheck versionCheck = new VersionCheck.VersionCheck();
            versionCheck.CopyOldDataToNewFolder();
            //アップデート
            GetUpdateFile getUpdateFile = new GetUpdateFile();
            getUpdateFile.BeginThread();
            //オプション
            optionMainForm = new OptionMainForm();
            Const.opt = optionMainForm;

            //ウィンドウの大きさを得る
            formGuiData = new FormGuiData();

            //ネットに接続されているか
            if (System.Net.NetworkInformation.NetworkInterface.GetIsNetworkAvailable() == false)
                Const.OnLine = false;

            ///メインフォーム
            mainForm = FormPartsManager.Pop();
            //mainForm.Size = new Size(Const.MainFormType1Size.Width, Const.MainFormType1Size.Height);
            mainForm.MinimumSize = new Size(1000, 400);
            mainForm.Size = Const.MainFormType1Size;
            mainForm.Name = "Form";
            mainForm.Text = "ageon";
            mainForm.Visible = false;
            mainForm.control.Icon = Resources.icon;

            Const.form = this;
            Const.form.mainForm = mainForm;
            //フォームの大きさを得る
            Const.GetDisplaySize();

            //マップフォーム
            mapMainForm = new MapMainForm();
            Const.mapForm = mapMainForm;


            ///スプリットコンテナ
            mainSplitContainerParts = SplitContainerPartsManager.Pop();
            mainSplitContainerParts.Size = new Size(Const.MainFormType1Size.Width - Scale.GetMainSplitContainerMinusSize().Width,
                Const.MainFormType1Size.Height - Scale.GetMainSplitContainerMinusSize().Height);

            mainSplitContainerParts.SplitterDistance = 250;
            mainSplitContainerParts.SetVertical();
            //mainSplitContainerParts.SetFixedPanel(1);
            mainSplitContainerParts.Location = new Point(0, 58);
            //mainSplitContainerParts.Hide();
            mainSplitContainerParts.control.BorderStyle = BorderStyle.FixedSingle;
            //mainSplitContainerParts.control.SplitterWidth = 1;

            subMainSplitContainerParts = SplitContainerPartsManager.Pop();
            subMainSplitContainerParts.Size = new Size(mainSplitContainerParts.Size.Width - mainSplitContainerParts.SplitterDistance - 2,
                mainSplitContainerParts.Size.Height);
            subMainSplitContainerParts.SplitterDistance = 350;
            subMainSplitContainerParts.SetHorizontal();
            subMainSplitContainerParts.control.BorderStyle = BorderStyle.FixedSingle;

            ///タイプ２のスプリットコンテナ
            mainSplitContainerType2Parts = SplitContainerPartsManager.Pop();
            mainSplitContainerType2Parts.Size = new Size(Const.MainFormType2Size.Width - Scale.GetMainSplitContainerMinusSize().Width, 
                Const.MainFormType2Size.Height - Scale.GetMainSplitContainerMinusSize().Height);
            mainSplitContainerType2Parts.SplitterDistance = 500;
            mainSplitContainerType2Parts.SetVertical();
            mainSplitContainerType2Parts.Location = new Point(0, 58);
            mainSplitContainerType2Parts.Hide();
            mainSplitContainerType2Parts.control.BorderStyle = BorderStyle.FixedSingle;

            subMainSplitContainerType2Parts = SplitContainerPartsManager.Pop();
            subMainSplitContainerType2Parts.Size = new Size(mainSplitContainerType2Parts.SplitterDistance - 2,
                mainSplitContainerType2Parts.Size.Height);
            subMainSplitContainerType2Parts.SplitterDistance = 350;
            subMainSplitContainerType2Parts.SetHorizontal();
            subMainSplitContainerType2Parts.control.BorderStyle = BorderStyle.FixedSingle;

            ///タイプ3のスプリットコンテナ
            mainSplitContainerType3Parts = SplitContainerPartsManager.Pop();
            mainSplitContainerType3Parts.Size = new Size(Const.MainFormType3Size.Width - Scale.GetMainSplitContainerMinusSize().Width,
                Const.MainFormType3Size.Height - Scale.GetMainSplitContainerMinusSize().Height);
            mainSplitContainerType3Parts.SplitterDistance = 600;
            mainSplitContainerType3Parts.SetVertical();
            mainSplitContainerType3Parts.Location = new Point(0, 58);
            mainSplitContainerType3Parts.Hide();
            mainSplitContainerType3Parts.control.BorderStyle = BorderStyle.FixedSingle;


            subMainSplitContainerType3Parts = SplitContainerPartsManager.Pop();
            subMainSplitContainerType3Parts.Size = new Size(mainSplitContainerType3Parts.SplitterDistance - 2,
                mainSplitContainerType3Parts.Size.Height);
            subMainSplitContainerType3Parts.SplitterDistance = 200;
            subMainSplitContainerType3Parts.SetVertical();
            subMainSplitContainerType3Parts.control.BorderStyle = BorderStyle.FixedSingle;

            ///ステータスバー
            statusStripParts = StatusStripPartsManager.Pop();
            //statusStripParts.SetPadding(11, 11, 11, 11);
            //statusStripParts.Location = new Point(0, 750);
            statusStripParts.Name = "ステータスバー";
            statusStripParts.Size = new Size(0, 30);
                                
            onLineToolStripStatusLabel = new ToolStripStatusLabel();
            onLineToolStripStatusLabel.BorderSides = ToolStripStatusLabelBorderSides.Right;
            if (Const.onLine == true)
                onLineToolStripStatusLabel.Text = "状態：オンライン　　　";
            else
                onLineToolStripStatusLabel.Text = "状態：オフライン　　　";
            
            roninToolStripStatusLabel = new ToolStripStatusLabel();
            roninToolStripStatusLabel.BorderSides = ToolStripStatusLabelBorderSides.Right;
            roninToolStripStatusLabel.Text = "Ronin：ログオフ　　　";
            
            be2chToolStripStatusLabel = new ToolStripStatusLabel();
            be2chToolStripStatusLabel.BorderSides = ToolStripStatusLabelBorderSides.Right;
            be2chToolStripStatusLabel.Text = "2chBe：ログオフ　　　";
            
            beSCToolStripStatusLabel = new ToolStripStatusLabel();
            beSCToolStripStatusLabel.BorderSides = ToolStripStatusLabelBorderSides.Right;
            beSCToolStripStatusLabel.Text = "2chBe(SC)：ログオフ　　　";

            statusStripParts.control.Items.AddRange(new ToolStripItem[] {
                onLineToolStripStatusLabel,
                roninToolStripStatusLabel,
                be2chToolStripStatusLabel,
                beSCToolStripStatusLabel
            });

            ///ツールバー
            toolStripParts = ToolStripPartsManager.Pop();

            toolStripTextBoxParts = ToolStripTextBoxPartsManager.Pop();
            toolStripTextBoxParts.Size = new Size(mainSplitContainerParts.Size.Width - 250, 0);
            toolStripTextBoxParts.Text = "";
            toolStripTextBoxParts.control.KeyPress += new KeyPressEventHandler(toolStripTextBoxParts_KeyPress);

            Type1ButtonParts = ToolStripButtonPartsManager.Pop();
            Type1ButtonParts.Click += new EventHandler(ChangeToType1);
            Type1ButtonParts.Size = new Size(30, 30);
            Type1ButtonParts.Text = "表示タイプ１";
            Type1ButtonParts.Image = new Bitmap(Resources.type1);

            Type2ButtonParts = ToolStripButtonPartsManager.Pop();
            Type2ButtonParts.Click += new EventHandler(ChangeToType2);
            Type2ButtonParts.Size = new Size(30, 30);
            Type2ButtonParts.Text = "表示タイプ２";
            Type2ButtonParts.Image = new Bitmap(Resources.type2);

            Type3ButtonParts = ToolStripButtonPartsManager.Pop();
            Type3ButtonParts.Click += new EventHandler(ChangeToType3);
            Type3ButtonParts.Size = new Size(30, 30);
            Type3ButtonParts.Text = "表示タイプ３";
            Type3ButtonParts.Image = new Bitmap(Resources.type3);

            MapButtonParts = ToolStripButtonPartsManager.Pop();
            MapButtonParts.Click += new EventHandler(PopUpMap);
            MapButtonParts.Size = new Size(30, 30);
            MapButtonParts.Text = "地図解析";
            MapButtonParts.Image = new Bitmap(Resources.map);

            AddressButtonParts = ToolStripButtonPartsManager.Pop();
            AddressButtonParts.Click += new EventHandler(OpenAddress);
            AddressButtonParts.Size = new Size(30, 30);
            AddressButtonParts.Text = "アドレスを開く";
            AddressButtonParts.Image = new Bitmap(Resources.address);


            usefulBoardButtonParts = ToolStripButtonPartsManager.Pop();
            usefulBoardButtonParts.Click += new EventHandler(UsefulBoard);
            usefulBoardButtonParts.Size = new Size(30, 30);
            usefulBoardButtonParts.Text = "最近閲覧した板";
            usefulBoardButtonParts.Image = new Bitmap(Resources.usufulboard);
            //最近閲覧した板をよみこむ
            nispi.Controls.UsefulAddress.UsefulBoard.ReadFile();

            usefulThreadButtonParts = ToolStripButtonPartsManager.Pop();
            usefulThreadButtonParts.Click += new EventHandler(UsefulThread);
            usefulThreadButtonParts.Size = new Size(30, 30);
            usefulThreadButtonParts.Text = "最近閲覧したスレッド";
            usefulThreadButtonParts.Image = new Bitmap(Resources.usufulthread);
            //最近閲覧したスレッドをよみこむ
            nispi.Controls.UsefulAddress.UsefulThread.ReadFile();


            mainForm.AddControl(mainSplitContainerParts);
            mainForm.AddControl(mainSplitContainerType2Parts);
            mainForm.AddControl(toolStripParts);
            toolStripParts.AddItem(Type1ButtonParts);
            toolStripParts.AddItem(Type2ButtonParts);
            toolStripParts.AddItem(Type3ButtonParts);
            toolStripParts.AddItem(MapButtonParts);
            toolStripParts.AddItem(AddressButtonParts);
            toolStripParts.AddItemToolStripText(toolStripTextBoxParts);
            toolStripParts.AddItem(usefulBoardButtonParts);
            toolStripParts.AddItem(usefulThreadButtonParts);

            mainForm.AddControl(statusStripParts);


            ///インデックスのタブ
            ///
            imageList = new ImageList();
            imageList.ImageSize = new Size(16, 16);
            imageList.TransparentColor = Color.White;
            imageList.Images.Add(Resources.favicon_sc);
            imageList.Images.Add(Resources.favicon_2ch);
            imageList.Images.Add(Resources.favorite);
            imageList.Images.Add(Resources.map);
            imageList.Images.Add(Resources.favicon_open2ch);
            imageList.Images.Add(Resources.favicon_next2ch);
            imageList.Images.Add(Resources.favicon_jikkyo);
            imageList.Images.Add(Resources.favicon_blogban);
            imageList.Images.Add(Resources.favicon_shizu);
            imageList.Images.Add(Resources.favicon_vip2ch);
            imageList.Images.Add(Resources.favicon_machi);
            imageList.Images.Add(Resources.favicon_jbbs);
            imageList.Images.Add(Resources.favicon_refind2ch);
            imageList.Images.Add(Resources.favicon_sc_new);
            imageList.Images.Add(Resources.favicon_2ch_new);
            imageList.Images.Add(Resources.favicon_open2ch_new);
            imageList.Images.Add(Resources.favicon_next2ch_new);
            imageList.Images.Add(Resources.favicon_jikkyo_new);
            imageList.Images.Add(Resources.favicon_blogban_new);
            imageList.Images.Add(Resources.favicon_shizu_new);
            imageList.Images.Add(Resources.favicon_vip2ch_new);
            imageList.Images.Add(Resources.favicon_machi_new);
            imageList.Images.Add(Resources.favicon_jbbs_new);


            boardIndexTabControlParts = TabControlPartsManager.Pop();
            boardIndexTabControlParts.Name = "boardIndexTabControlParts";
            boardIndexTabControlParts.ImageList = imageList;
            boardIndexTabControlParts.control.Selected += new TabControlEventHandler(boardIndexSelected);
            boardIndexTabControlParts.IsCaptionVisible = true;

            boardListTabControlParts = TabControlPartsManager.Pop();
            boardListTabControlParts.Name = "boardListTabControlParts";
            //boardListTabControlParts.Selecting += new TabControlPartsDelegate.MultiTabControlCancelEventHandler(boardListSelected);
            boardListTabControlParts.Selected += new TabControlEventHandler(boardListSelected);
            boardListTabControlParts.ImageList = imageList;
            //boardListTabControlParts.IsCaptionVisible = true;

            threadListTabControlParts = TabControlPartsManager.Pop();
            //threadListTabControlParts.Size =
            //    new Size(mainSplitContainerParts.Size.Width - mainSplitContainerParts.SplitterDistance - 4,
            //        mainSplitContainerParts.Size.Height - subMainSplitContainerParts.SplitterDistance - 4);
            threadListTabControlParts.Name = "threadListTabControlParts";
            //threadListTabControlParts.Selecting += new TabControlPartsDelegate.MultiTabControlCancelEventHandler(threadListSelecting);
            threadListTabControlParts.control.Selecting += new TabControlCancelEventHandler(threadListSelected);
            threadListTabControlParts.IsCaptionVisible = true;
            threadListTabControlParts.Set_TabSizeMode_Fixed();
            threadListTabControlParts.ItemSize = new Size(200, 25);
            threadListTabControlParts.ImageList = imageList;


            //スプリットコンテナ左
            mainSplitContainerParts.AddToPanel1(boardIndexTabControlParts);
            mainSplitContainerParts.AddToPanel2(subMainSplitContainerParts);

            //スプリットコンテナ右の上と下
            subMainSplitContainerParts.AddToPanel1(boardListTabControlParts);
            subMainSplitContainerParts.AddToPanel2(threadListTabControlParts);



            mapMainFormConst = new MapMainFormConst();
            mainFormConstituent = new MainFormConst();

            //直前に開いていたタブを開く
            try
            {
                SaveBoardAndThread.SaveIndexTabNum saveIndex = new SaveBoardAndThread.SaveIndexTabNum();
                saveIndex.Read();
            }

            catch { ;}
            ///コンテキストメニュー
            contextMenuControls = new ContextMenuControls();

            //FormResizeType1();
            //MainType1PanelResize();
            //MainFormConst.formShowStyle.ReSizeType1();

            MapMainFormConst.mapFormShowStyle.ReSize();
            PopUpManager.Setup();

            //Process.Start("kagushianalysis.exe");


            mainForm.control.Resize += new EventHandler(FormResizeType1);
            //mainForm.control.ClientSizeChanged += new EventHandler(Form_ClientSizeChanged);

            mainForm.SetFormClosing(new FormPartsDelegate.MultiFormClosingEventHandler(Form_FormClosing));
            mainSplitContainerParts.Panel1_Resize += new EventHandler(MainType1PanelResize);
            subMainSplitContainerParts.Panel1_Resize += new EventHandler(SubType1PanelResize);

            mainSplitContainerType2Parts.Panel1_Resize += new EventHandler(MainType2PanelResize);
            subMainSplitContainerType2Parts.Panel1_Resize += new EventHandler(SubType2PanelResize);

            mainSplitContainerType3Parts.Panel1_Resize += new EventHandler(MainType3PanelResize);
            subMainSplitContainerType3Parts.Panel1_Resize += new EventHandler(SubType3PanelResize);

            //表示タイプ
            if (formGuiData.Type1_Type2 == 1)
            {    
                ChangeToType1();
            }
            else if (formGuiData.Type1_Type2 == 2)
            {
                ChangeToType2();
            }
            else
            {
                ChangeToType3();
            }

            //位置、サイズ
            this.mainForm.Location = new Point(formGuiData.MainFormLocation_X, formGuiData.MainFormLocation_Y);
            this.mainForm.Size = new Size(formGuiData.MainFormSize_X, formGuiData.MainFormSize_Y);

            //パネルの区切り,サイズをそろえる
            if (formGuiData.Type1_Type2 == 1)
            {
                this.mainSplitContainerParts.SplitterDistance = formGuiData.MainFormMainDistance;
                this.subMainSplitContainerParts.SplitterDistance = formGuiData.MainFormSubDistance;
                MainType1PanelResize();

            }
            else if (formGuiData.Type1_Type2 == 2)
            {
                this.mainSplitContainerType2Parts.SplitterDistance = formGuiData.MainFormMainDistance;
                this.subMainSplitContainerType2Parts.SplitterDistance = formGuiData.MainFormSubDistance;
                MainType2PanelResize();
            }
            else
            {
                this.mainSplitContainerType3Parts.SplitterDistance = formGuiData.MainFormMainDistance;
                this.subMainSplitContainerType3Parts.SplitterDistance = formGuiData.MainFormSubDistance;
                MainType3PanelResize();
            }

            //お気に入り板追加窓
            Const.addFavoriteForm = new AddFavoriteForm();

            //表示する
            //this.mapMainForm.mapMainForm.Visible = true;
            Thread.Sleep(1);
            this.mainForm.Visible = true;

            Thread t = new Thread(new ThreadStart(nispi.LogIn.LoginUtil.GetDataTask));
            t.IsBackground = true;
            t.Start();

            //マジックコード
            Const.form.mainForm.Size = new Size(Const.form.mainForm.Size.Width - 1, Const.form.mainForm.Size.Height - 1);
            Const.form.mainForm.Size = new Size(Const.form.mainForm.Size.Width + 1, Const.form.mainForm.Size.Height + 1);

            //Const.form.mainForm.Invoke((Action)(() => ChangeUserAgent()));
        }

        private void Form_FormClosing(object sender, FormClosingEventArgs e)
        {
            /*System.Diagnostics.Process[] ps =
                System.Diagnostics.Process.GetProcessesByName("kagushiAnalysis");

            foreach (System.Diagnostics.Process p in ps)
            {
                //クローズメッセージを送信する
                p.CloseMainWindow();

                //10秒待機
                p.WaitForExit(10000);
            }*/

            //KagushiAnalysisClient kagushi = new KagushiAnalysisClient();
            //kagushi.Exit();

            //タスクトレイのアイコンを消す
            MainFormConst.menuSetup.fileMenu.notifyIcon.Dispose();

            //現在のウィンドウの大きさ等の設定を保存する
            formGuiData.MainFormLocation_X = this.mainForm.Location.X;
            formGuiData.MainFormLocation_Y = this.mainForm.Location.Y;
            formGuiData.MainFormSize_X = this.mainForm.Size.Width;
            formGuiData.MainFormSize_Y = this.mainForm.Size.Height;

            if (formGuiData.Type1_Type2 == 1)
            {
                formGuiData.MainFormMainDistance = this.mainSplitContainerParts.SplitterDistance;
                formGuiData.MainFormSubDistance = this.subMainSplitContainerParts.SplitterDistance;
            }
            else if (formGuiData.Type1_Type2 == 2)
            {
                formGuiData.MainFormMainDistance = this.mainSplitContainerType2Parts.SplitterDistance;
                formGuiData.MainFormSubDistance = this.subMainSplitContainerType2Parts.SplitterDistance;
            }
            else
            {
                formGuiData.MainFormMainDistance = this.mainSplitContainerType3Parts.SplitterDistance;
                formGuiData.MainFormSubDistance = this.subMainSplitContainerType3Parts.SplitterDistance;
            }

            formGuiData.SaveFormToFile();


            try
            {
                //レジストリを消す
                Microsoft.Win32.Registry.CurrentUser.
                    OpenSubKey(@"Software\Microsoft\Internet Explorer\Main\FeatureControl\FEATURE_BROWSER_EMULATION", true).DeleteValue("ageon.exe");
            }
            catch { ;}
            //現在表示している板を保存する
            SaveBoardAndThread.SaveBoard saveBoard = new SaveBoardAndThread.SaveBoard();
            saveBoard.Save(MainFormConst.boardListTabMain.view_list);
            //現在表示しているスレッドを保存する
            SaveBoardAndThread.SaveThread saveThread = new SaveBoardAndThread.SaveThread();
            saveThread.Save(MainFormConst.threadListTabMain.viewList);
            //今現在表示している板のインデックスを保存する
            SaveBoardAndThread.SaveIndexTabNum saveIndex = new SaveBoardAndThread.SaveIndexTabNum();
            saveIndex.Save(this.boardIndexTabControlParts.SelectedIndex);

            optionMainForm.optionFormParts.Owner = null;
            mapMainForm.mapMainForm.Owner = null;
            mainForm.control.Dispose();
        }
        private void boardIndexSelected(object sender, TabControlEventArgs e)
        {
            /*if (e.TabPageIndex == 1)
            {
                DialogResult result2 = MessageBox.Show("2ch用の新APIへの対応までお待ちください",
                    "お知らせ",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Asterisk,MessageBoxDefaultButton.Button2);
                
                e.Cancel = true;
            }*/
            //ResizeTabControl();
            //マジックコード
            try
            {
                Const.form.boardIndexTabControlParts.ItemSize = new Size(Const.form.boardIndexTabControlParts.Size.Width / 4 - 2, 25);
                MainFormConst.formShowStyle.ResizeIndexBoard();
            }
            catch { ;}
        }

        private void threadListSelected(object sender, TabControlCancelEventArgs e)//TabControlCancelEventArgs e)
        {
            //マジックコード
            try
            {
                Const.form.threadListTabControlParts.ItemSize = new Size(Const.form.threadListTabControlParts.Size.Width / 4 - 2, 25);
            }
            catch { ;}
            //if (e.TabPageIndex < 0) return;
            MainFormConst.threadListTabMain.viewList[e.TabPageIndex].threadViewControls.browserParts.Size =
                    new Size(MainFormConst.threadListTabMain.viewList[e.TabPageIndex].threadViewControls.tabPageExParts.Size.Width,
                        MainFormConst.threadListTabMain.viewList[e.TabPageIndex].threadViewControls.tabPageExParts.Size.Height - 27);

            try
            {
                toolStripTextBoxParts.Text = Util.DatUrlToThreadUrl(MainFormConst.threadListTabMain.viewList[e.TabPageIndex].datUrl);
            }
            catch { ;}

            //ResizeTabControl();
        }

        private void boardListSelected(object sender, TabControlEventArgs e)
        {
            //if (e.TabPageIndex <= 1) return;
            //マジックコード
            try
            {
                Const.form.boardListTabControlParts.ItemSize = new Size(Const.form.boardListTabControlParts.Size.Width / 4 - 2, 25);
            }
            catch { ;}

            MainFormConst.boardListTabMain.view_list[e.TabPageIndex].boardListControls.listViewParts.Size =
                    new Size(MainFormConst.boardListTabMain.view_list[e.TabPageIndex].boardListControls.tabPageExParts.Size.Width,
                        MainFormConst.boardListTabMain.view_list[e.TabPageIndex].boardListControls.tabPageExParts.Size.Height - 27);



            if (e.TabPageIndex == 1)
            {
                MainFormConst.boardListTabMain.zenbunSearchView.boardListBrowserParts.Size =
                    new Size(MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Width,
                        MainFormConst.boardListTabMain.zenbunSearchView.boardListControls.tabPageExParts.Size.Height - 27);
            }
        }
        //private Size
        private void ResizeTabControl()
        {
            //パネルの区切り,サイズをそろえる
            if (formGuiData.Type1_Type2 == 1)
            {
                MainType1PanelResize();

            }
            else if (formGuiData.Type1_Type2 == 2)
            {
                MainType2PanelResize();
            }
            else
            {
                MainType3PanelResize();
            }
        }
        private void PopUpMap(object sender, EventArgs e)
        {
            //mapMainForm.mapMainForm.control.Owner = this.mainForm.control;
            mapMainForm.mapMainForm.Show();
        }

        private void UsefulBoard(object sender, EventArgs e)
        {
            nispi.Controls.UsefulAddress.UsefulBoardMenu menu = new Controls.UsefulAddress.UsefulBoardMenu();
        }
        private void UsefulThread(object sender, EventArgs e)
        {
            nispi.Controls.UsefulAddress.UsefulThreadMenu menu = new Controls.UsefulAddress.UsefulThreadMenu();
        }

        private static int num = 0;
        private void OpenAddress(object sender, EventArgs e)
        {
            num += 1;
            string datUrl = Util.ThreadUrlToDatUrl(this.toolStripTextBoxParts.Text);
            if (datUrl.Length == 0)
                return;
            MainFormConst.threadListTabMain.ShowThread(datUrl, datUrl);
        }

        public void ChangeToType1(object sender, EventArgs e)
        {
            ChangeToType1();
            //タイプの値を変える
            this.formGuiData.Type1_Type2 = 1;

            ////ほにゃ
            //nispi.OptionControl.theme.Theme theme = new OptionControl.theme.Theme();
            //theme.OutPutXML();
            //theme.GetXMLData("Gray.xml");
            ////
        }

        public void ChangeToType1()
        {
            //イベントを取り除く
            mainForm.control.Resize -= new EventHandler(FormResizeType1);
            mainForm.control.Resize -= new EventHandler(FormResizeType2);
            mainForm.control.Resize -= new EventHandler(FormResizeType3);
            //サイズ変更
            mainForm.MinimumSize = new Size(1000, 400);
            if (this.mainForm.control.WindowState == FormWindowState.Maximized)
                Const.MainFormType1Size = mainForm.Size;
            
            mainForm.Size = Const.MainFormType1Size;
            FormResizeType1();

            //イベント再設定
            mainForm.control.Resize += new EventHandler(FormResizeType1);

            MainFormConst.formShowStyle.ChangeToType1(); 

        }

        public void ChangeToType2(object sender, EventArgs e)
        {
            ChangeToType2();
            //タイプの値を変える
            this.formGuiData.Type1_Type2 = 2;
        }

        public void ChangeToType2()
        {
            //イベントを取り除く
            mainForm.control.Resize -= new EventHandler(FormResizeType1);
            mainForm.control.Resize -= new EventHandler(FormResizeType2);
            mainForm.control.Resize -= new EventHandler(FormResizeType3);
            //サイズ変更
            mainForm.MinimumSize = new Size(1350, 400);
            if (this.mainForm.control.WindowState == FormWindowState.Maximized)
                Const.MainFormType2Size = mainForm.Size;
 
            mainForm.Size = Const.MainFormType2Size;
            FormResizeType2();

            //イベント再設定
            mainForm.control.Resize += new EventHandler(FormResizeType2);

            MainFormConst.formShowStyle.ChangeToType2();
        }

        public void ChangeToType3(object sender, EventArgs e)
        {
            ChangeToType3();
            //タイプの値を変える
            this.formGuiData.Type1_Type2 = 3;
        }

        public void ChangeToType3()
        {
            //イベントを取り除く
            mainForm.control.Resize -= new EventHandler(FormResizeType1);
            mainForm.control.Resize -= new EventHandler(FormResizeType2);
            mainForm.control.Resize -= new EventHandler(FormResizeType3);
            //サイズ変更
            mainForm.MinimumSize = new Size(1350, 400);
            if (this.mainForm.control.WindowState == FormWindowState.Maximized)
                Const.MainFormType3Size = mainForm.Size;

            mainForm.Size = Const.MainFormType3Size;
            FormResizeType3();

            //イベント再設定
            mainForm.control.Resize += new EventHandler(FormResizeType3);

            MainFormConst.formShowStyle.ChangeToType3();
        }
        public void toolStripTextBoxParts_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                e.Handled = true;
                num += 1;
                string datUrl = Util.ThreadUrlToDatUrl(this.toolStripTextBoxParts.Text);
                if (datUrl.Length == 0)
                    return;
                MainFormConst.threadListTabMain.ShowThread(datUrl, datUrl);
            }
        }
        /*public void Form_ClientSizeChanged(object sender, EventArgs e)
        {
            
            Form temp = (Form)sender;
            if (temp.WindowState == FormWindowState.Minimized)
            {
                temp.Hide();
            }
            else
            {

            }
        }*/
    }
}