﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

namespace nispi.controlclass
{
    class CountryIndexControlEvent
    {
        CountryIndexControls countryIndexControls;

        public CountryIndexControlEvent(CountryIndexControls countryIndexControls)
        {
            this.countryIndexControls = countryIndexControls;

            this.countryIndexControls.searchTextBoxParts.KeyPress += new KeyPressEventHandler(search_textBox_KeyPress);

            this.countryIndexControls.searchButtonParts.Click += new EventHandler(search_button_Click);

            this.countryIndexControls.reloadButtonParts.Click += new EventHandler(reload_button_Click);

            this.countryIndexControls.treeViewParts.MouseDoubleClick += new MouseEventHandler(treeViewParts_MouseDoubleClick);
        }

        public void RemoveEvent()
        {
            this.countryIndexControls.searchTextBoxParts.KeyPress -= new KeyPressEventHandler(search_textBox_KeyPress);

            this.countryIndexControls.searchButtonParts.Click -= new EventHandler(search_button_Click);

            this.countryIndexControls.reloadButtonParts.Click -= new EventHandler(reload_button_Click);
        }
        private void treeViewParts_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            TreeView tv = (TreeView)sender;
            if (tv.SelectedNode.Name.Length > 0)
            {
                if (e.Button == MouseButtons.Left)
                {
                    MainFormConst.boardListTabMain.show_board("local://screening/" + tv.SelectedNode.Name, true);
                }
            }
        }
        public void search_button_Click(object sender, EventArgs e)
        {
            string text = this.countryIndexControls.searchTextBoxParts.Text;
            this.countryIndexControls.treeViewParts.SearchTreeView(this.countryIndexControls.treeViewParts, text);
            this.countryIndexControls.searchTextBoxParts.Focus();
            this.countryIndexControls.treeViewParts.Invalidate();
        }

        public void reload_button_Click(object sender, EventArgs e)
        {
            try
            {
                MapMainFormConst.getScreeningData.StartScreening();
            }
            catch
            {
            }
        }

        public void search_textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                e.Handled = true;
                string text = this.countryIndexControls.searchTextBoxParts.Text;
                this.countryIndexControls.treeViewParts.SearchTreeView(this.countryIndexControls.treeViewParts, text);
                this.countryIndexControls.searchTextBoxParts.Focus();
                this.countryIndexControls.treeViewParts.Invalidate();
            }
        }
    }
}
