﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

using nispi.Menu;

namespace nispi.controlclass
{

    class BoardIndexTreeViewMenuEvent : BoardIndexTreeViewMenuMethod
    {
        public BoardIndexTreeViewMenu boardIndexTreeViewMenu;
        public BoardIndexTreeViewMainMenu boardIndexTreeViewMainMenu;

        //コンテキストメニュー
        public BoardIndexTreeViewMenuEvent(BoardIndexTreeViewMenu boardIndexTreeViewMenu)
        {
            this.boardIndexTreeViewMenu = boardIndexTreeViewMenu;

            this.boardIndexTreeViewMenu.menuItemOpenParts.Click += new EventHandler(menuItemOpen_Click);

            this.boardIndexTreeViewMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);

            this.boardIndexTreeViewMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            this.boardIndexTreeViewMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            this.boardIndexTreeViewMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            this.boardIndexTreeViewMenu.menuItemOpenBrowserParts.Image = Resources.browser;

            this.boardIndexTreeViewMenu.menuItemDeleteParts.Click += new EventHandler(menuItemDelete_Click);

            this.boardIndexTreeViewMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            this.boardIndexTreeViewMenu.menuItemReloadParts.Image = Resources.reload;

            MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);


            MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            //MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            //MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            //
            MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);

            MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);



            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.MouseUp += new MouseEventHandler(list_View_MouseUp);
            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.MouseDown += new MouseEventHandler(list_View_MouseDown);
        }
        //メインメニュー
        public BoardIndexTreeViewMenuEvent(BoardIndexTreeViewMainMenu boardIndexTreeViewMainMenu)
        {
            this.boardIndexTreeViewMainMenu = boardIndexTreeViewMainMenu;

            this.boardIndexTreeViewMainMenu.menuItemOpenParts.Click += new EventHandler(menuItemOpen_Click);

            this.boardIndexTreeViewMainMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);

            this.boardIndexTreeViewMainMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            this.boardIndexTreeViewMainMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            this.boardIndexTreeViewMainMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);

            this.boardIndexTreeViewMainMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
        }

        public void Show(Point point)
        {
            this.boardIndexTreeViewMenu.contextMenuStripParts.Show(this.treeViewParts, point);
        }

        public void list_View_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                this.Show(e.Location);
            }
        }

        public void list_View_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                if (CheckConsistency() == true)
                {

                    //２ｃｈとSCとOpen2chとNext2chのインデックス
                    if (Const.form.boardIndexTabControlParts.SelectedIndex <= 8)
                    {
                        if ((treeViewParts.SelectedNodeGetBool() == false) || (treeViewParts.SelectedNodeName.Length == 0))
                        {
                            boardIndexTreeViewMenu.menuItemOpenParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemCopyURLParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemDeleteParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemReloadParts.Enabled = true;
                        }
                        else
                        {
                            boardIndexTreeViewMenu.menuItemOpenParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemCopyURLParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemDeleteParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemReloadParts.Enabled = true;
                        }
                    }
                    //お気に入り
                    else
                    {
                        if ((treeViewParts.SelectedNodeGetBool() == false) || (treeViewParts.SelectedNodeName.Length == 0))
                        {
                            boardIndexTreeViewMenu.menuItemOpenParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemCopyURLParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemDeleteParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemReloadParts.Enabled = true;
                        }
                        else
                        {
                            boardIndexTreeViewMenu.menuItemOpenParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemAddFavoriteParts.Enabled = false;
                            boardIndexTreeViewMenu.menuItemOpenBrowserParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemCopyURLParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemCopyTitleParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemDeleteParts.Enabled = true;
                            boardIndexTreeViewMenu.menuItemReloadParts.Enabled = true;
                        }
                    }
                }
            }
        }
    }
    class BoardIndexTreeViewMenuMethod
    {
        public TreeViewParts treeViewParts;
        //public BoardIndexTreeViewMenu boardIndexTreeViewMenu;

        public BoardIndexTreeViewMenuMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
                    treeViewParts = MainFormConst.boardIndexTabMain.boardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
                    treeViewParts = MainFormConst.boardIndexTabMain.scBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
                    treeViewParts = MainFormConst.boardIndexTabMain.open2chBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
                    treeViewParts = MainFormConst.boardIndexTabMain.next2chBoardIndexView.boardIndexControls.treeViewParts;

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
                    treeViewParts = MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.boardIndexControls.treeViewParts;
                //else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                //    treeViewParts = MainFormConst.boardIndexTabMain.blogbanBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                    treeViewParts = MainFormConst.boardIndexTabMain.shizuBoardIndexView.boardIndexControls.treeViewParts;

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
                    treeViewParts = MainFormConst.boardIndexTabMain.vip2chBoardIndexView.boardIndexControls.treeViewParts;
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
                    treeViewParts = MainFormConst.boardIndexTabMain.machibbsBoardIndexView.boardIndexControls.treeViewParts;

                else
                    treeViewParts = MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts;
                return true;
            }
            catch
            {
                return false;
            }
        }

        public void menuItemOpen_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string name = treeViewParts.SelectedNodeName;
                    if (name.Length > 0)
                    {

                        string url = treeViewParts.SelectedNodeName;
                        MainFormConst.ShowBoard(url);

                    }
                }
                catch { ;}
            }
        }

        public void menuItemDownload_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    string thread_name = BoardDataBase.GetName(url);
                }
                catch
                {
                    return;
                }
            }
        }


        //お気に入りに追加する
        delegate void WriteFavoriteBoardList_Delegate(TreeViewParts treeViewParts);

        public void menuItemAddFavorite_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    if (Const.form.boardIndexTabControlParts.SelectedIndex == 9)
                    {
                        return;
                    }
                    else
                    {
                        string url = treeViewParts.SelectedNodeName;
                        string boardName = BoardDataBase.GetName(url);
                        string type = Util.BoardUrlToBoardTypeName(url);

                        //お気に入りに加える
                        FavoriteBoardManager.Add(boardName, url, type);
                        FavoriteBoardManager.Save();

                        //お気に入りを再読み込みする
                        FavoriteBoardManager.LoadFavorite();
                        //GUIに再出力する4
                        //if (FavoriteBoardManager.favoriteBoardList.Count == 0)
                        //    return; ;
                        Const.form.mainForm.Invoke(
                            new WriteFavoriteBoardList_Delegate(
                                MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.WriteFavoriteBoardList),
                                MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts);

                    }
                }
                catch { ;}
            }
        }

        public void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                string url = treeViewParts.SelectedNodeName;
                Clipboard.SetDataObject(url, true);
            }
        }

        public void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    string thread_name = BoardDataBase.GetName(url);
                    Clipboard.SetDataObject(thread_name, true);
                }
                catch
                {
                    return;
                }
            }
        }

        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    if (url.Length != 0)
                        Process.Start(url);
                }
                catch
                {
                    return;
                }
            }
        }

        public void menuItemReload_Click(object sender, EventArgs e)
        {
            try
            {
                if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
                    MainFormConst.boardIndexTabMain.boardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
                    MainFormConst.boardIndexTabMain.scBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
                    MainFormConst.boardIndexTabMain.open2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
                    MainFormConst.boardIndexTabMain.next2chBoardIndexView.LoadBoardList();

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
                    MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.LoadBoardList();
                //else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                //    MainFormConst.boardIndexTabMain.blogbanBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                    MainFormConst.boardIndexTabMain.shizuBoardIndexView.LoadBoardList();

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
                    MainFormConst.boardIndexTabMain.vip2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
                    MainFormConst.boardIndexTabMain.machibbsBoardIndexView.LoadBoardList();

                else
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.LoadFavoriteBoardList();
            }
            catch
            {
            }
        }
        public void menuItemDelete_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == true)
            {
                try
                {
                    string url = treeViewParts.SelectedNodeName;
                    string boardName = BoardDataBase.GetName(url);
                    string type = Util.BoardUrlToBoardTypeName(url);
                    //したらばの場合データベースにないのでお気に入りのデータベースを使う
                    if (boardName.Length == 0)
                    {
                        boardName = FavoriteBoardDataBase.GetName(url, Util.BoardUrlToBoardTypeName(url));
                    }
                    //削除する
                    FavoriteBoardManager.Remove(boardName, url, type);
                    FavoriteBoardManager.Save();

                    //お気に入りを再読み込みする
                    FavoriteBoardManager.LoadFavorite();
                    //GUIに再出力する4
                    //if (FavoriteBoardManager.favoriteBoardList.Count == 0)
                    //    return; ;
                    Const.form.mainForm.Invoke(
                        new WriteFavoriteBoardList_Delegate(
                            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.WriteFavoriteBoardList),
                            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts);
                }
                catch { ;}
            }
        }
    }
}