﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;

using System.Windows.Forms;

using nispi;


namespace nispi.controlclass
{
    class FormMain : System.Windows.Forms.Form
    {
        public FormMain()
        {
            this.DoubleBuffered = true;
        }
        protected override void WndProc(ref Message m)
        {
            if (m.Msg == 0x0086)
            {
                if (this.Name.Equals("isPopUp") == true)
                {
                    m.WParam = new IntPtr(1);
                }
            }
            base.WndProc(ref m);
        }
    }
    public class FormPartsDelegate
    {
        public delegate void MultiFormClosingEventHandler(object sender, FormClosingEventArgs e);
    }
    class FormParts : ControlBase
    {
        public FormMain control;

        public FormParts()
        {
            control = new FormMain();
            //control.AutoScaleMode = AutoScaleMode.Dpi;
            //control.AutoScaleDimensions = new SizeF(9F, 19F);
            control.AutoScaleMode = AutoScaleMode.Font;
            //control.AutoScaleMode = AutoScaleMode.Dpi;
            control.Font = new Font("Meiryo UI", 10.75F, FontStyle.Regular, GraphicsUnit.Point, ((byte)(128)));
            control.Margin = new Padding(3, 4, 3, 4);
            this.controlBase = (System.Windows.Forms.Control)control;
        }

        public void Close()
        {
            this.control.Close();
        }
        public Form GetControl()
        {
            return (Form)control;
        }
        public FormBorderStyle FormBorderStyle
        {
            set
            {
                this.control.FormBorderStyle = value;
            }
        }
        public Form Owner
        {
            set
            {
                this.control.Owner = value;
            }
            get
            {
                return this.control.Owner;
            }
        }

        public FormClosingEventHandler currentFormClosingEventHandler;
        public void SetFormClosing(FormPartsDelegate.MultiFormClosingEventHandler method)
        {
            currentFormClosingEventHandler = new FormClosingEventHandler(method);
            this.control.FormClosing += currentFormClosingEventHandler;
        }

        public void ReSetFormClosing()
        {
            this.control.FormClosing -= currentFormClosingEventHandler;
        }

        public Graphics CreateGraphics()
        {
            return this.control.CreateGraphics();
        }
        public Size GetDisplaySize()
        {
            //ディスプレイの高さ
            int DisplayY = System.Windows.Forms.Screen.GetWorkingArea(this.control).Height;
            //ディスプレイの幅
            int DisplayX = System.Windows.Forms.Screen.GetWorkingArea(this.control).Width;

            return new Size(DisplayX, DisplayY);
        }
        /*public new void RemoveAllCtrl()
        {
            this.control.Controls.Clear();
        }*/
        public void ResetControl()
        {
            //this.control.FormBorderStyle = FormBorderStyle.None;
        }
    }
    /// <summary>
    /// タブページのスタックを作る。足りなければ新たに作成する。
    /// 多すぎればある程度まで削減する機能があってもいい
    /// </summary>
    class FormPartsManager
    {
        public static LinkedList<FormParts> allFormList = new LinkedList<FormParts>();
        public static Stack<FormParts> tabPageStack = new Stack<FormParts>();
        public static Mutex mutex = new Mutex(false, "FormPartsManager");

        public static FormParts Pop()
        {
            mutex.WaitOne();

            if (tabPageStack.Count == 0)
                tabPageStack.Push(new FormParts());

            FormParts tabPage = tabPageStack.Pop();

            //GUIのリストを作成する
            if (null == allFormList.Find(tabPage))
            {
                ChangeOutWard(tabPage);
                allFormList.AddLast(tabPage);
            }

            mutex.ReleaseMutex();

            return tabPage;
        }

        public static void Push(FormParts tabPage)
        {
            tabPage.ResetControlBase();
            tabPage.ResetControl();

            mutex.WaitOne();

            tabPageStack.Push(tabPage);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (FormParts parts in allFormList)
            {
                parts.ForeColor = Color.FromArgb(
                    Const.opt.outWardForm.FormForeColorRed,
                    Const.opt.outWardForm.FormForeColorGreen,
                    Const.opt.outWardForm.FormForeColorBlue);
                parts.BackColor = Color.FromArgb(
                    Const.opt.outWardForm.FormBackColorRed,
                    Const.opt.outWardForm.FormBackColorGreen,
                    Const.opt.outWardForm.FormBackColorBlue);
            }

            Const.form.mainForm.Refresh();
            Const.mapForm.mapMainForm.Refresh();
            Const.form.mainForm.Update();
            Const.mapForm.mapMainForm.Update();

            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }
        public static void ChangeOutWard(FormParts parts)
        {
            mutex.WaitOne();

            //Const.form.mainForm.SuspendLayout();
            //Const.mapForm.mapMainForm.SuspendLayout();

            parts.ForeColor = Color.FromArgb(
                Const.opt.outWardForm.FormForeColorRed,
                Const.opt.outWardForm.FormForeColorGreen,
                Const.opt.outWardForm.FormForeColorBlue);
            parts.BackColor = Color.FromArgb(
                Const.opt.outWardForm.FormBackColorRed,
                Const.opt.outWardForm.FormBackColorGreen,
                Const.opt.outWardForm.FormBackColorBlue);

            //Const.form.mainForm.Refresh();
            //Const.mapForm.mapMainForm.Refresh();
            //Const.form.mainForm.Update();
            //Const.mapForm.mapMainForm.Update();

            //Const.mapForm.mapMainForm.ResumeLayout();
            //Const.form.mainForm.ResumeLayout();

            mutex.ReleaseMutex();
        }
    }
}