﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace nispi.controlclass
{
    partial class SampleListViewParts : ControlBase
    {
        public void WriteListView()
        {
            //int numx = 0;

            this.control.BeginUpdate();
            this.SuspendLayout();

            this.control.VirtualListSize = 0;

            if (this.items != null)
            {
                foreach (ListViewItemParts item in this.items)
                    item.SubItemsClear();
            }

            this.items = new ListViewItemParts[10];

            for(int num = 0; num < 10; num+=1)
            {
                string[] data = {
                                    num.ToString()
                                };

                this.items[num] = new ListViewItemParts(data);
                this.items[num].Name = num.ToString();

                if ((num % 2) == 0)
                {
                    this.items[num].BackColor = Color.AliceBlue;
                }
            }

            this.items[0].Text = "奇数行";
            this.items[1].Text = "偶数行";
            this.items[2].Text = "選択されている行";

            this.control.VirtualListSize = 10;

            this.ResumeLayout();

            this.control.EndUpdate();
        }

        ///////////////////////////////////////////////////////////////
        //カラム関連
        public byte[] GetColumnForeColor()
        {
            byte[] colmunForeByte = { columnFore.red, columnFore.green, columnFore.blue };
            return colmunForeByte;
        }
        public void SetColumnForeColor(byte[] color)
        {
            columnFore.red = color[0];
            columnFore.green = color[1];
            columnFore.blue = color[2];

            columnForeBrush = new SolidBrush(Color.FromArgb(255, color[0], color[1], color[2]));
        }

        public byte[] GetColumnBackColor()
        {
            byte[] colmunBackByte = { columnBack.red,columnBack.green,columnBack.blue};
            return colmunBackByte;
        }
        public void SetColumnBackColor(byte[] color)
        {
            columnBack.red = color[0];
            columnBack.green = color[1];
            columnBack.blue = color[2];
            
            columnBackBrush = new SolidBrush(Color.FromArgb(255, color[0], color[1], color[2]));
        }

        ///////////////////////////////////////////////////////////////
        //背景色関連
        public byte[] GetItemBackColor(int num)
        {
            byte[] color = {
                              //一行おきに色が違うためにそこにnumを使う
                              control.Items[num].BackColor.R,
                              control.Items[num].BackColor.G,
                              control.Items[num].BackColor.B,
                          };
            return color;
        }
        ///////////////////////////////////////////////////////////////
        //文字色関連
        public byte[] GetItemForeColor(int num)
        {
            byte[] color = {
                              control.Items[num].ForeColor.R,
                              control.Items[num].ForeColor.G,
                              control.Items[num].ForeColor.B
                          };
            return color;
        }
        public void SetItemForeColor(int itemNum, byte[] color)
        {
            control.Items[itemNum].ForeColor = Color.FromArgb(color[0], color[1], color[2]);
        }
        public void SetItemBackColor(int itemNum, byte[] color)
        {
            control.Items[itemNum].BackColor = Color.FromArgb(color[0], color[1], color[2]);
        }
        ///////////////////////////////////////////////////////////////
        //選択職関連
        /*}public void SetSelectForeColor(byte[] color)
        {
            control.Items[2].ForeColor = Color.FromArgb(color[0], color[1], color[2]);
        }

        public void SetSelectBackColor(byte[] color)
        {
            control.Items[2].BackColor = Color.FromArgb(color[0], color[1], color[2]);
        }
        //*/
    }
}