﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Drawing;

namespace nispi.controlclass
{
    partial class TreeViewParts : ControlBase
    {
        private void control_DrawNode(object sender, DrawTreeNodeEventArgs e)
        {
            //ノードを追加している時には描画しない
            this.mutex.WaitOne();
            if (WritingFlag == false)
            {
                this.mutex.ReleaseMutex();
                return;
            }
            this.mutex.ReleaseMutex();

            // Draw the background and node text for a selected node.
            if ((e.State & TreeNodeStates.Selected) != 0)
            {
                e.Graphics.FillRectangle(tVSelectBackBrush, e.Bounds);

                //if (e.Node.Nodes != null)
                {
                    RectangleF rectF = new RectangleF(e.Node.Bounds.Location, new SizeF(this.Size.Width - 10, this.Size.Height));
                    e.Graphics.DrawString(e.Node.Text, this.control.Font, tVSelectForeBrush, rectF);
                }
                //else
                {
                    //e.Graphics.DrawString(e.Node.Text, font, tVSelectForeBrush,e.Bounds);
                }
            }
            else
            {
                if ((e.Node.Index % 2) == 0)
                    e.Graphics.FillRectangle(tVBackBrush, e.Bounds);
                else
                    e.Graphics.FillRectangle(tVBackBrush2, e.Bounds);

                RectangleF rectF = new RectangleF(e.Node.Bounds.Location, new SizeF(this.Size.Width - 10, this.Size.Height));
                e.Graphics.DrawString(e.Node.Text, this.control.Font, tVForeBrush, rectF);

            }

            if (this.control.Focused == false)
            {
                if ((e.Node == beforeHitNode) && (beforeHitNode != null))
                {
                    e.Graphics.FillRectangle(tVSelectBackBrush, e.Bounds);

                    RectangleF rectF = new RectangleF(e.Node.Bounds.Location, new SizeF(this.Size.Width - 10, this.Size.Height));
                    e.Graphics.DrawString(e.Node.Text, this.control.Font, tVSelectForeBrush, rectF);

                }
            }


            //参考にしたサイト：https://go4answers.webhost4life.com/Example/treeview-ownerdrawall-188907.aspx

            int linelength = 0;
            int left = e.Bounds.X;
            int top = e.Bounds.Y;
            int height = e.Bounds.Height;
            int nodeleft = e.Node.Bounds.X;
            int nodetop = e.Node.Bounds.Y;
            int nodeheight = e.Node.Bounds.Height;
            int nodewidth = e.Node.Bounds.Width;
            int checkboxwidth = 13;
            int checknodespace = 0;
            if (this.control.ImageList != null)
            {
                checknodespace = 3;
            }

            int lineleft = nodeleft - checknodespace - checkboxwidth - linelength;
            if (e.Node.Nodes.Count > 0)
            {
                if (!e.Node.IsExpanded)
                {
                    e.Graphics.DrawImage(Resources.plus,
                      lineleft - Resources.plus.Width / 2, top + (height -
                      Resources.plus.Height) / 2);
                }
                else
                {
                    e.Graphics.DrawImage(Resources.minus,
                      lineleft - Resources.minus.Width / 2, top + (height -
                      Resources.minus.Height) / 2);
                }
            }

            //お気に入りのツリービューの描画
            if (((TreeView)sender).Name.Equals("favorite") == true)
            {   
                string type = Util.BoardUrlToBoardTypeName(e.Node.Name);
                Image image = null;

                if (type.Equals("2ch") == true)
                    image = Resources.favicon_2ch;
                else if (type.Equals("2chsc") == true)
                    image = Resources.favicon_sc;
                else if (type.Equals("screening") == true)
                    image = Resources.map;
                else if (type.Equals("open2ch") == true)
                    image = Resources.favicon_open2ch;
                else if (type.Equals("next2ch") == true)
                    image = Resources.favicon_next2ch;
                else if (type.Equals("jikkyo") == true)
                    image = Resources.favicon_jikkyo;
                else if (type.Equals("blogban") == true)
                    image = Resources.favicon_blogban;
                else if (type.Equals("shizu") == true)
                    image = Resources.favicon_shizu;
                else if (type.Equals("vip2ch") == true)
                    image = Resources.favicon_vip2ch;
                else if (type.Equals("machibbs") == true)
                    image = Resources.favicon_machi;
                else if (type.Equals("jbbs") == true)
                    image = Resources.favicon_jbbs;
                if (image != null)
                {
                    Rectangle rect = new Rectangle(new Point(e.Bounds.X + 2, e.Bounds.Y + 2),
                        new Size(e.Bounds.Height - 4, e.Bounds.Height - 4));
                    e.Graphics.DrawImage(image, rect);
                }
            }
        }
    }
}
