﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Drawing;
using System.Windows.Forms;

namespace nispi.controlclass
{
    class TreeViewPartsManager
    {
        public static LinkedList<TreeViewParts> allList = new LinkedList<TreeViewParts>();
        public static Stack<TreeViewParts> buttonStack = new Stack<TreeViewParts>();
        public static Mutex mutex = new Mutex(false, "TreeViewPartsManager");

        public static TreeViewParts Pop(BoardIndexViewCommon boardIndexViewCommon)
        {
            mutex.WaitOne();

            if (buttonStack.Count == 0)
                buttonStack.Push(new TreeViewParts());

            TreeViewParts buttonParts = buttonStack.Pop();

            //GUIのリストを作成する
            if (null == allList.Find(buttonParts))
            {
                ChangeOutWard(buttonParts);
                allList.AddLast(buttonParts);
            }
            mutex.ReleaseMutex();

            buttonParts.boardIndexViewCommon = boardIndexViewCommon;

            return buttonParts;
        }

        public static void Push(TreeViewParts buttonParts)
        {
            buttonParts.boardIndexViewCommon = null;
            buttonParts.ResetControlBase();

            mutex.WaitOne();

            buttonStack.Push(buttonParts);

            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard()
        {
            mutex.WaitOne();

            Const.form.mainForm.SuspendLayout();
            Const.mapForm.mapMainForm.SuspendLayout();

            foreach (TreeViewParts parts in allList)
            {
                ChangeOutWard(parts);
            }


            Const.mapForm.mapMainForm.ResumeLayout();
            Const.form.mainForm.ResumeLayout();


            mutex.ReleaseMutex();
        }

        public static void ChangeOutWard(TreeViewParts parts)
        {
            parts.Font = Const.opt.outWardList.LVFont;

            parts.tVForeBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVForeColorRed,
                Const.opt.outWardList.LVForeColorGreen,
                Const.opt.outWardList.LVForeColorBlue));

            parts.tVBackBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVBackColorRed,
                Const.opt.outWardList.LVBackColorGreen,
                Const.opt.outWardList.LVBackColorBlue));

            parts.tVBackBrush2 = new SolidBrush(Color.FromArgb(
                     255,
                Const.opt.outWardList.LVBackColor2Red,
                Const.opt.outWardList.LVBackColor2Green,
                Const.opt.outWardList.LVBackColor2Blue));

            parts.tVSelectForeBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectForeColorRed,
                Const.opt.outWardList.LVSelectForeColorGreen,
                Const.opt.outWardList.LVSelectForeColorBlue));

            parts.tVSelectBackBrush = new SolidBrush(Color.FromArgb(
                255,
                Const.opt.outWardList.LVSelectBackColorRed,
                Const.opt.outWardList.LVSelectBackColorGreen,
                Const.opt.outWardList.LVSelectBackColorBlue));

            parts.BackColor = Color.FromArgb(
                255,
                Const.opt.outWardList.LVBackColorRed,
                Const.opt.outWardList.LVBackColorGreen,
                Const.opt.outWardList.LVBackColorBlue);

           
            float scaledFloat = Scale.GetScaledFloat(Const.opt.outWardList.LVFontSize);

            //Font font = new Font(Const.opt.outWardList.LVFontName, Const.opt.outWardList.LVFontSize);
            //parts.ItemHeight = TextRenderer.MeasureText("あ", font).Height;
            //parts.ItemHeight =  (int)Math.Ceiling((double)scaledFloat);
            //parts.SetFont(Const.form.mainForm.GetFontName(), scaledFloat);
        }
    }
}