﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace nispi.OptionControl
{
    class OtherOptionEvent
    {
        private OtherOption otherOption;
        private bool changeFlag = false;

        public OtherOptionEvent(OtherOption otherOption)
        {
            this.otherOption = otherOption;
            SetEvent();
        }
        public void SetEvent()
        {
            this.otherOption.userAgentTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            this.otherOption.userAgentResetButtonParts.Click += new EventHandler(userAgentResetButtonParts_Click);

            this.otherOption.proxyCBoxParts.Click += new EventHandler(ChangeFlag);

            this.otherOption.proxyTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            this.otherOption.portTBoxParts.TextChanged += new EventHandler(ChangeFlag);

            this.otherOption.proxyResetButtonParts.Click += new EventHandler(proxyResetButtonParts_Click);


            //this.otherOption.logOpenTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            //this.otherOption.logOpenButtonParts.Click += new EventHandler(logOpenButtonParts_Click);
            //this.otherOption.logDefaultButtonParts.Click += new EventHandler(logDefaultButtonParts_Click);

            this.otherOption.taskCBoxParts.Click += new EventHandler(ChangeFlag);
            this.otherOption.saveCBoxParts.Click += new EventHandler(ChangeFlag);
            
            //画像
            this.otherOption.jpgParts.Click += new EventHandler(ChangeFlag);
            this.otherOption.pngParts.Click += new EventHandler(ChangeFlag);
            this.otherOption.gifParts.Click += new EventHandler(ChangeFlag);
            this.otherOption.bmpParts.Click += new EventHandler(ChangeFlag);

            //２ｃｈの表示モード
            this.otherOption.mode2chRButtonParts.Click += new EventHandler(ChangeFlag);
            this.otherOption.modeIERButtonParts.Click += new EventHandler(ChangeFlag);
            //オートリロード
            this.otherOption.autoReloadTBoxParts.TextChanged += new EventHandler(ChangeFlag);
            this.otherOption.autoReloadResetButtonParts.Click += new EventHandler(autoReloadResetButtonParts_Click);
            //リダイレクト
            this.otherOption.redirectRButtonParts.Click += new EventHandler(ChangeFlag);
            this.otherOption.noRedirectRButtonParts.Click += new EventHandler(ChangeFlag);

        }
        public void ResetEvent()
        {
            this.otherOption.userAgentTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            this.otherOption.userAgentResetButtonParts.Click -= new EventHandler(userAgentResetButtonParts_Click);

            this.otherOption.proxyCBoxParts.Click -= new EventHandler(ChangeFlag);

            this.otherOption.proxyTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            this.otherOption.portTBoxParts.TextChanged -= new EventHandler(ChangeFlag);

            this.otherOption.proxyResetButtonParts.Click -= new EventHandler(proxyResetButtonParts_Click);

            //this.otherOption.logOpenTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            //this.otherOption.logOpenButtonParts.Click -= new EventHandler(logOpenButtonParts_Click);
            //this.otherOption.logDefaultButtonParts.Click -= new EventHandler(logDefaultButtonParts_Click);

            this.otherOption.taskCBoxParts.Click -= new EventHandler(ChangeFlag);
            this.otherOption.saveCBoxParts.Click -= new EventHandler(ChangeFlag);

            //画像
            this.otherOption.jpgParts.Click -= new EventHandler(ChangeFlag);
            this.otherOption.pngParts.Click -= new EventHandler(ChangeFlag);
            this.otherOption.gifParts.Click -= new EventHandler(ChangeFlag);
            this.otherOption.bmpParts.Click -= new EventHandler(ChangeFlag);

            //２ｃｈの表示モード
            this.otherOption.mode2chRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.otherOption.modeIERButtonParts.Click -= new EventHandler(ChangeFlag);

            //オートリロード
            this.otherOption.autoReloadTBoxParts.TextChanged -= new EventHandler(ChangeFlag);
            this.otherOption.autoReloadResetButtonParts.Click -= new EventHandler(autoReloadResetButtonParts_Click);

            //リダイレクト
            this.otherOption.redirectRButtonParts.Click -= new EventHandler(ChangeFlag);
            this.otherOption.noRedirectRButtonParts.Click -= new EventHandler(ChangeFlag);
        }

        private void ChangeFlag(object sender, EventArgs e)
        {
            this.changeFlag = true;
        }

        private void userAgentResetButtonParts_Click(object sender, EventArgs e)
        {
            this.otherOption.userAgentTBoxParts.Text = "Monazilla/1.00 (AgeOn/2.0)";
        }

        private void proxyResetButtonParts_Click(object sender, EventArgs e)
        {
            this.otherOption.proxyTBoxParts.Text = "localhost";
            this.otherOption.portTBoxParts.Text = "8080";
            this.otherOption.proxyCBoxParts.Checked = false;
        }

        private void logOpenButtonParts_Click(object sender, EventArgs e)
        {
            //保存するフォルダを得る
            /*string path = FormGUI.GetTargetDirectory(otherOption.optionTabMain.optionFormParts, Const.DataDir);

            //ダイアログを表示する
            if (path.Length > 0)
            {
                otherOption.logOpenTBoxParts.Text = path;
            }*/
            System.Diagnostics.Process.Start("EXPLORER.EXE", this.otherOption.LogFolder);
        }
        private void autoReloadResetButtonParts_Click(object sender, EventArgs e)
        {
            this.otherOption.autoReloadTBoxParts.Text = "15";
        }
        public void SetAllOption()
        {
            if (changeFlag == true)
            {
                changeFlag = false;
                {
                    this.otherOption.UserAgent = this.otherOption.userAgentTBoxParts.Text;

                    this.otherOption.IsProxyUse = this.otherOption.proxyCBoxParts.Checked.ToString();
                    this.otherOption.ProxyAddress = this.otherOption.proxyTBoxParts.Text;
                    this.otherOption.ProxyPort = this.otherOption.portTBoxParts.Text;

                    //this.otherOption.LogFolder = this.otherOption.logOpenTBoxParts.Text;

                    this.otherOption.IsViewTaskBar = this.otherOption.taskCBoxParts.Checked.ToString();
                    this.otherOption.IsSaveOpenWindow = this.otherOption.saveCBoxParts.Checked.ToString();

                    this.otherOption.IsJpegImage = this.otherOption.jpgParts.Checked.ToString();
                    this.otherOption.IsPngImage = this.otherOption.pngParts.Checked.ToString();
                    this.otherOption.IsGifImage = this.otherOption.gifParts.Checked.ToString();
                    this.otherOption.IsBmpImage = this.otherOption.bmpParts.Checked.ToString();

                    if (this.otherOption.modeIERButtonParts.Checked == true)
                        this.otherOption.ModeType2ch = "IEMode";
                    else if (this.otherOption.mode2chRButtonParts.Checked == true)
                        this.otherOption.ModeType2ch = "2chMode";

                    //オートリロード
                    this.otherOption.AutoReloadTime = this.otherOption.autoReloadTBoxParts.Text;

                    //リダイレクト
                    if (this.otherOption.redirectRButtonParts.Checked == true)
                        this.otherOption.Redirect = "redirect";
                    else if (this.otherOption.noRedirectRButtonParts.Checked == true)
                        this.otherOption.Redirect = "noDirect";

                    this.otherOption.SaveToFile();
                }
            }
        }
    }
}
