﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using nispi.controlclass;

namespace nispi.AgeOnDebuger
{
    partial class DebugMainForm
    {
        public void OutPutDebug(string type, System.Exception ex)
        {
            //return;
            StackTrace st = new StackTrace(false);

            string traceData = "";
            string space = " ";
            for (int num = st.FrameCount - 20; num >= 0; num -= 1)
            {
                StackFrame sf = st.GetFrame(num);

                string tempClassName = sf.GetMethod().ReflectedType.FullName;
                string tempMethodName = sf.GetMethod().Name;

                traceData += space.PadLeft(num) + num.ToString() + ":" + tempClassName + "----" + tempMethodName + "\r\n";
            }

            TextBoxParts dummyTBoxParts;

            switch (type)
            {
                case "BoardIndex":
                    dummyTBoxParts = boardIndexTBParts;
                    break;
                case "BoardList":
                    dummyTBoxParts = boardListTBParts;
                    break;
                case "ThreadList":
                    dummyTBoxParts = threadListTBParts;
                    break;
                case "Analysis":
                    dummyTBoxParts = analysisTBParts;
                    break;
                case "Map":
                    dummyTBoxParts = mapTBParts;
                    break;
                case "Menu":
                    dummyTBoxParts = menuTBParts;
                    break;
                case "Other":
                    dummyTBoxParts = otherTBParts;
                    break;
                case "htmlPopUp":
                    dummyTBoxParts = htmlPopUpTBParts;
                    break;
                default:
                    return;
            }
            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.Text += ("-------------------------------------\r\n")));
            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.Text += (traceData)));
            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.Text += ("-------------------------------------\r\n")));

            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.SelectionStart = dummyTBoxParts.Text.Length));
            //dummyTBoxParts.ScrollToCaret();
        }

        public void OutPutDebug(string type, string fileName)
        {
            StackTrace st = new StackTrace(false);

            string traceData = "";
            string space = " ";
            /*for (int num = st.FrameCount - 20; num >= 0; num -= 1)
            {
                StackFrame sf = st.GetFrame(num);

                string tempClassName = sf.GetMethod().ReflectedType.FullName;
                string tempMethodName = sf.GetMethod().Name;

                traceData += space.PadLeft(num) + num.ToString() + ":" + tempClassName + "----" + tempMethodName + "\r\n";
            }*/
            traceData = fileName;

            TextBoxParts dummyTBoxParts;

            switch (type)
            {
                case "BoardIndex":
                    dummyTBoxParts = boardIndexTBParts;
                    break;
                case "BoardList":
                    dummyTBoxParts = boardListTBParts;
                    break;
                case "ThreadList":
                    dummyTBoxParts = threadListTBParts;
                    break;
                case "Analysis":
                    dummyTBoxParts = analysisTBParts;
                    break;
                case "Map":
                    dummyTBoxParts = mapTBParts;
                    break;
                case "Menu":
                    dummyTBoxParts = menuTBParts;
                    break;
                case "Other":
                    dummyTBoxParts = otherTBParts;
                    break;
                case "htmlPopUp":
                    dummyTBoxParts = htmlPopUpTBParts;
                    break;
                default:
                    return;
            }
            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.Text += ("-------------------------------------\r\n")));
            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.Text += (traceData)));
            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.Text += ("-------------------------------------\r\n")));

            Const.form.mainForm.Invoke((Action)(() => dummyTBoxParts.SelectionStart = dummyTBoxParts.Text.Length));
            //dummyTBoxParts.ScrollToCaret();
        }

        public void Print(string str)
        {
            Const.form.mainForm.Invoke((Action)(() => printTBParts.Text += ("-------------------------------------\r\n")));
            Const.form.mainForm.Invoke((Action)(() => printTBParts.Text += (str  + "\r\n")));
            Const.form.mainForm.Invoke((Action)(() => printTBParts.Text += ("-------------------------------------\r\n")));
        }
    }
}
