﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using System.Windows.Forms;
using mshtml;

namespace nispi.controlclass
{
    class BoardIndexControlEvent
    {
        BoardIndexControls boardIndexControls;

        public BoardIndexControlEvent(BoardIndexControls boardIndexControls)
        {
            this.boardIndexControls = boardIndexControls;

            this.boardIndexControls.searchTextBoxParts.KeyPress += new KeyPressEventHandler(search_textBox_KeyPress);

            this.boardIndexControls.searchButtonParts.Click += new EventHandler(search_button_Click);

            this.boardIndexControls.reloadButtonParts.Click += new EventHandler(reload_button_Click);
        }

        public void RemoveEvent()
        {
            this.boardIndexControls.searchTextBoxParts.KeyPress -= new KeyPressEventHandler(search_textBox_KeyPress);

            this.boardIndexControls.searchButtonParts.Click -= new EventHandler(search_button_Click);

            this.boardIndexControls.reloadButtonParts.Click -= new EventHandler(reload_button_Click);
        }

        public void search_button_Click(object sender, EventArgs e)
        {
            string text = this.boardIndexControls.searchTextBoxParts.Text;
            this.boardIndexControls.treeViewParts.Invalidate();
            this.boardIndexControls.treeViewParts.SearchTreeView(this.boardIndexControls.treeViewParts, text);
            this.boardIndexControls.searchTextBoxParts.Focus();
        }

        public void reload_button_Click(object sender, EventArgs e)
        {
            try
            {
                if (Const.form.boardIndexTabControlParts.SelectedIndex == 0)
                    MainFormConst.boardIndexTabMain.boardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 1)
                    MainFormConst.boardIndexTabMain.scBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 2)
                    MainFormConst.boardIndexTabMain.open2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 3)
                    MainFormConst.boardIndexTabMain.next2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 4)
                    MainFormConst.boardIndexTabMain.jikkyoBoardIndexView.LoadBoardList();
                //else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                //    MainFormConst.boardIndexTabMain.blogbanBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 5)
                    MainFormConst.boardIndexTabMain.shizuBoardIndexView.LoadBoardList();

                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 6)
                    MainFormConst.boardIndexTabMain.vip2chBoardIndexView.LoadBoardList();
                else if (Const.form.boardIndexTabControlParts.SelectedIndex == 7)
                    MainFormConst.boardIndexTabMain.machibbsBoardIndexView.LoadBoardList();

                else
                    MainFormConst.boardIndexTabMain.favoriteBoardIndexView.LoadFavoriteBoardList();
            }
            catch
            {
            }
        }

        public void search_textBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                e.Handled = true;
                string text = this.boardIndexControls.searchTextBoxParts.Text;
                this.boardIndexControls.treeViewParts.SearchTreeView(this.boardIndexControls.treeViewParts, text);
                this.boardIndexControls.searchTextBoxParts.Focus();
                this.boardIndexControls.treeViewParts.Invalidate();
            }
        }
    }
}
