﻿//ライセンス情報はAgeOnフォルダのLISENCEフォルダを参照してください
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Drawing;
using System.Threading;
using System.Diagnostics;

using nispi.WriteToBoard;
using System.Windows.Forms;
using mshtml;

using nispi.Menu;

namespace nispi.controlclass
{
    class BoardListTabEvent:BoardListTabMethod
    {
        BoardListTabMenu boardListTabMenu;
        BoardListTabMainMenu boardListTabMainMenu;
        
        public BoardListTabEvent(BoardListTabMenu boardListTabMenu)
        {
            this.boardListTabMenu = boardListTabMenu;

            boardListTabMenu.menuItemCloseTabParts.Click += new EventHandler(menuItemCloseTab_Click);

            boardListTabMenu.menuItemCloseAllTabParts.Click += new EventHandler(menuItemCloseAllTab_Click);

            boardListTabMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);
            boardListTabMenu.menuItemAddFavoriteParts.Image = Resources.favorite;
            boardListTabMenu.menuItemAddFavoriteParts.ImageTransparentColor = Color.White;

            boardListTabMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            boardListTabMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            boardListTabMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            boardListTabMenu.menuItemCreateNewThreadParts.Click += new EventHandler(menuItemCreateNewThreadParts_Click);
            boardListTabMenu.menuItemCreateNewThreadParts.Image = Resources.write2;
            boardListTabMenu.menuItemCreateNewThreadParts.ImageTransparentColor = Color.White;

            boardListTabMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            boardListTabMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            boardListTabMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            boardListTabMenu.menuItemReloadParts.Image = Resources.reload;
            boardListTabMenu.menuItemReloadParts.ImageTransparentColor = Color.White;

            Const.form.boardListTabControlParts.MouseUp += new MouseEventHandler(threadList_tabControl_MouseUp);
            Const.form.boardListTabControlParts.MouseDown += new MouseEventHandler(threadList_tabControl_MouseDown);

            //Const.form.boardIndexTabControlParts.MouseDoubleClick += new MouseEventHandler(control_DoubleClick);
        }

        public BoardListTabEvent(BoardListTabMainMenu boardListTabMainMenu)
        {
            this.boardListTabMainMenu = boardListTabMainMenu;

            boardListTabMainMenu.menuItemCloseTabParts.Click += new EventHandler(menuItemCloseTab_Click);

            boardListTabMainMenu.menuItemCloseAllTabParts.Click += new EventHandler(menuItemCloseAllTab_Click);

            boardListTabMainMenu.menuItemAddFavoriteParts.Click += new EventHandler(menuItemAddFavorite_Click);
            boardListTabMainMenu.menuItemAddFavoriteParts.Image = Resources.favorite;
            boardListTabMainMenu.menuItemAddFavoriteParts.ImageTransparentColor = Color.White;

            boardListTabMainMenu.menuItemOpenBrowserParts.Click += new EventHandler(menuItemOpenBrowser_Click);
            boardListTabMainMenu.menuItemOpenBrowserParts.Image = Resources.browser;
            boardListTabMainMenu.menuItemOpenBrowserParts.ImageTransparentColor = Color.White;

            boardListTabMainMenu.menuItemCreateNewThreadParts.Click += new EventHandler(menuItemCreateNewThreadParts_Click);
            boardListTabMainMenu.menuItemCreateNewThreadParts.Image = Resources.write2;
            boardListTabMainMenu.menuItemCreateNewThreadParts.ImageTransparentColor = Color.White;

            boardListTabMainMenu.menuItemCopyURLParts.Click += new EventHandler(menuItemCopyURL_Click);

            boardListTabMainMenu.menuItemCopyTitleParts.Click += new EventHandler(menuItemCopyTitle_Click);

            boardListTabMainMenu.menuItemReloadParts.Click += new EventHandler(menuItemReload_Click);
            boardListTabMainMenu.menuItemReloadParts.Image = Resources.reload;
            boardListTabMainMenu.menuItemReloadParts.ImageTransparentColor = Color.White;
        }

        private void control_DoubleClick(object sender, MouseEventArgs e)
        {
            int num = Const.form.boardListTabControlParts.SelectedIndex;

            MainFormConst.boardListTabMain.view_list[num].reload();
        }

        private void threadList_tabControl_MouseUp(object sender, MouseEventArgs e)
        {
            if (e.Button == MouseButtons.Right)
            {
                boardListTabMenu.contextMenuStripParts.Show(Const.form.boardListTabControlParts, e.Location);
            }
            return;
        }

        //マウスの押下時にメニューのアイテムを設定する
        private void threadList_tabControl_MouseDown(object sender, MouseEventArgs e)
        {
            int selectNum = 0;
            if (e.Button == MouseButtons.Right)
            {
                for (int i = 0; i < Const.form.boardListTabControlParts.Count; i++)
                {
                    if (Const.form.boardListTabControlParts.GetTabRect(i).Contains(e.X, e.Y))
                    {
                        Const.form.boardListTabControlParts.SelectedIndex = i;
                        selectNum = i;
                        break;
                    }
                }
            }
            else
            {
                return;
            }
            //お気に入りの場合
            if ((selectNum == 0) || (selectNum == 1))
            {
                this.boardListTabMenu.menuItemCloseTabParts.Enabled = false;
                this.boardListTabMenu.menuItemCloseAllTabParts.Enabled = false;
                this.boardListTabMenu.menuItemAddFavoriteParts.Enabled = false;
                this.boardListTabMenu.menuItemCreateNewThreadParts.Enabled = false;
                this.boardListTabMenu.menuItemOpenBrowserParts.Enabled = true;
                this.boardListTabMenu.menuItemCopyURLParts.Enabled = true;
                this.boardListTabMenu.menuItemCopyTitleParts.Enabled = true;
                this.boardListTabMenu.menuItemReloadParts.Enabled = true;
            }
            //普通のタブの場合
            else
            {
                if (Const.form.boardListTabControlParts.GetSelectedTab().Text.Length == 0)
                {
                    this.boardListTabMenu.menuItemCloseTabParts.Enabled = false;
                    this.boardListTabMenu.menuItemCloseAllTabParts.Enabled = false;
                    this.boardListTabMenu.menuItemAddFavoriteParts.Enabled = false;
                    this.boardListTabMenu.menuItemCreateNewThreadParts.Enabled = false;
                    this.boardListTabMenu.menuItemOpenBrowserParts.Enabled = false;
                    this.boardListTabMenu.menuItemCopyURLParts.Enabled = false;
                    this.boardListTabMenu.menuItemCopyTitleParts.Enabled = false;
                    this.boardListTabMenu.menuItemReloadParts.Enabled = false;
                }
                else
                {
                    this.boardListTabMenu.menuItemCloseTabParts.Enabled = true;
                    this.boardListTabMenu.menuItemCloseAllTabParts.Enabled = true;
                    this.boardListTabMenu.menuItemAddFavoriteParts.Enabled = true;
                    this.boardListTabMenu.menuItemCreateNewThreadParts.Enabled = true;
                    this.boardListTabMenu.menuItemOpenBrowserParts.Enabled = true;
                    this.boardListTabMenu.menuItemCopyURLParts.Enabled = true;
                    this.boardListTabMenu.menuItemCopyTitleParts.Enabled = true;
                    this.boardListTabMenu.menuItemReloadParts.Enabled = true;
                }
            }
        }
    }

    class BoardListTabMethod
    {
        public BoardViewCommon boardViewCommon;

        public BoardListTabMethod()
        {
        }

        public bool CheckConsistency()
        {
            try
            {
                int index = Const.form.boardListTabControlParts.SelectedIndex;
                boardViewCommon = MainFormConst.boardListTabMain.view_list[index];
                return true;
            }
            catch
            {
                return false;
            }
        }
        public void menuItemCreateNewThreadParts_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;
            try
            {
                WriteMain writeMainForm = new WriteMain((BoardView)boardViewCommon);
            }
            catch { ;}
        }
        //選択しているタブが扱っているＵＲＬ名をコピー
        public void menuItemCopyURL_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string url = boardViewCommon.board_url;
                Clipboard.SetDataObject(url, true);
                return;

            }
            catch { ;}
        }

        public void menuItemCopyTitle_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                string title = boardViewCommon.board_title;
                Clipboard.SetDataObject(title, true);
                return;
            }
            catch { ;}
        }

        public void menuItemCloseTab_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                if (Const.form.boardListTabControlParts.SelectedIndex == 0)
                {
                    return;
                }
                else if (Const.form.boardListTabControlParts.SelectedIndex == 1)
                {
                    return;
                }
                else
                {
                    boardViewCommon.Dispoose();

                }
            }
            catch { ;}
        }

        //お気に入りを除くすべてのタブを閉じる
        public void menuItemCloseAllTab_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            Const.form.boardListTabControlParts.SuspendLayout();
            try
            {
                for (int i = Const.form.boardListTabControlParts.Count - 1; i > 1; i--)
                {
                    MainFormConst.boardListTabMain.view_list[i].DispooseAll();
                }
            }
            catch { ;}
            Const.form.boardListTabControlParts.ResumeLayout();
        }

        public void menuItemOpenBrowser_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                if (Const.form.boardListTabControlParts.SelectedIndex == 0)
                {
                    return;
                }
                else
                {
                    Process.Start(boardViewCommon.board_url);
                    return;
                }
            }
            catch { ;}
        }

        public void menuItemReload_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                if (Const.form.boardListTabControlParts.SelectedIndex == 0)
                {
                    //再読み込み
                    MainFormConst.LoadFavoriteBoardList();
                }
                else
                {
                    boardViewCommon.reload();
                }
            }
            catch { ;}
        }

        //お気に入りに追加する
        delegate void WriteFavoriteBoardList_Delegate(TreeViewParts treeViewParts);

        public void menuItemAddFavorite_Click(object sender, EventArgs e)
        {
            if (CheckConsistency() == false)
                return;

            try
            {
                if (Const.form.boardListTabControlParts.SelectedIndex == 0)
                {
                    return;
                }
                else
                {
                    string url = boardViewCommon.board_url;
                    string boardName = BoardDataBase.GetName(url);
                    string type = Util.BoardUrlToBoardTypeName(url);

                    //お気に入りに加える
                    FavoriteBoardManager.Add(boardName, url, type);
                    FavoriteBoardManager.Save();

                    //お気に入りを再読み込みする
                    FavoriteBoardManager.LoadFavorite();
                    //GUIに再出力する4
                    if (FavoriteBoardManager.favoriteBoardList.Count == 0)
                        return; ;
                    Const.form.mainForm.Invoke(
                        new WriteFavoriteBoardList_Delegate(
                            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts.WriteFavoriteBoardList),
                            MainFormConst.boardIndexTabMain.favoriteBoardIndexView.boardIndexControls.treeViewParts);
           
                }
            }
            catch { ;}
        }
    }
}